/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.meta.IllegalAttributeException;
import java.util.HashMap;
import java.util.Map;

public class CICSLongAttributeHint
implements ICICSLongAttributeHint {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private long[] range;
    private Map<String, Long> specialValues = new HashMap<String, Long>();

    public CICSLongAttributeHint(long min, long max, SpecialValue[] specialValues, Long[] extraValues) {
        int n;
        int n2;
        Object[] objectArray;
        this.range = new long[]{min, max};
        if (specialValues != null) {
            objectArray = specialValues;
            n2 = specialValues.length;
            n = 0;
            while (n < n2) {
                Object specialValue = objectArray[n];
                if (((SpecialValue)specialValue).getMnemonic() == SpecialValue.NO_MNEMONIC) {
                    this.specialValues.put(((SpecialValue)specialValue).getValue().toString(), ((SpecialValue)specialValue).getValue());
                } else {
                    this.specialValues.put(((SpecialValue)specialValue).getMnemonic(), ((SpecialValue)specialValue).getValue());
                }
                ++n;
            }
        }
        if (extraValues != null) {
            objectArray = extraValues;
            n2 = extraValues.length;
            n = 0;
            while (n < n2) {
                Object extraValue = objectArray[n];
                this.specialValues.put(((Long)extraValue).toString(), (Long)extraValue);
                ++n;
            }
        }
    }

    public CICSLongAttributeHint(long min, long max) {
        this(min, max, null, null);
    }

    public void validate(Long value) throws IllegalAttributeException {
        SimpleValidationHelper.validateNotNull((Object)value, null);
        if (this.hasSpecialValues()) {
            SimpleValidationHelper.validateMinMaxInclusiveOrSpecial((Long)value, (long)this.range[0], (long)this.range[1], this.getSpecialValues().values());
        } else {
            SimpleValidationHelper.validateMinMaxInclusive((Long)value, (long)this.range[0], (long)this.range[1]);
        }
    }

    public long[] getNumericRange() {
        return this.range;
    }

    public boolean hasSpecialValues() {
        return this.specialValues.size() > 0;
    }

    public Map<String, Long> getSpecialValues() {
        return this.specialValues;
    }

    public static SpecialValue s(String mnemonic, Long value) {
        return new SpecialValue(mnemonic, value);
    }

    public static class SpecialValue {
        private final String mnemonic;
        private final Long value;
        public static final String NO_MNEMONIC = new String("");

        public SpecialValue(String mnemonic, Long value) {
            this.mnemonic = mnemonic;
            this.value = value;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public Long getValue() {
            return this.value;
        }
    }
}

