/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadTransactionGroupReference;
import com.ibm.cics.core.model.WorkloadTransactionGroupType;
import com.ibm.cics.core.model.internal.MutableCPSMManager;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.IWorkloadTransactionGroup;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWorkloadTransactionGroup;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableWorkloadTransactionGroup
extends MutableCPSMManager
implements IMutableWorkloadTransactionGroup {
    private IWorkloadTransactionGroup delegate;
    private MutableSMRecord record;

    public MutableWorkloadTransactionGroup(ICPSM cpsm, IContext context, IWorkloadTransactionGroup cicsObject) {
        super(cpsm, context, (ICPSMManager)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WLMATGRP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getTransactionGroup() {
        return this.delegate.getTransactionGroup();
    }

    public String getWorkload() {
        return this.delegate.getWorkload();
    }

    public IWorkloadTransactionGroup.StatusValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IWorkloadTransactionGroup.StatusValue)((CICSAttribute)WorkloadTransactionGroupType.STATUS).get(result, this.record.getNormalizers());
    }

    public IWorkloadTransactionGroup.FilterValue getFilter() {
        return this.delegate.getFilter();
    }

    public IWorkloadTransactionGroup.AffinityValue getAffinity() {
        return this.delegate.getAffinity();
    }

    public IWorkloadTransactionGroup.AffinityLifetimeValue getAffinityLifetime() {
        return this.delegate.getAffinityLifetime();
    }

    public Long getAbendCrit() {
        return this.delegate.getAbendCrit();
    }

    public Long getAbendThreshold() {
        return this.delegate.getAbendThreshold();
    }

    public String getEventName() {
        return this.delegate.getEventName();
    }

    public String getWorkloadOwner() {
        return this.delegate.getWorkloadOwner();
    }

    public IWorkloadTransactionGroup.AutomaticAffinityCreationValue getAutomaticAffinityCreation() {
        return this.delegate.getAutomaticAffinityCreation();
    }

    public IWorkloadTransactionGroup.AlgorithmTypeValue getAlgorithmType() {
        String result = this.record.get("ALGTYPE");
        if (result == null) {
            return this.delegate.getAlgorithmType();
        }
        return (IWorkloadTransactionGroup.AlgorithmTypeValue)((CICSAttribute)WorkloadTransactionGroupType.ALGORITHM_TYPE).get(result, this.record.getNormalizers());
    }

    public Long getTransactionCount() {
        return this.delegate.getTransactionCount();
    }

    public void setStatus(IWorkloadTransactionGroup.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            WorkloadTransactionGroupType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadTransactionGroupType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setAlgorithmType(IWorkloadTransactionGroup.AlgorithmTypeValue _algorithmType) {
        if (_algorithmType.equals((Object)this.delegate.getAlgorithmType())) {
            this.record.set("ALGTYPE", null);
        } else {
            WorkloadTransactionGroupType.ALGORITHM_TYPE.validate((Object)_algorithmType);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadTransactionGroupType.ALGORITHM_TYPE).set(_algorithmType, this.record.getNormalizers());
            this.record.set("ALGTYPE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadTransactionGroupType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == WorkloadTransactionGroupType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadTransactionGroupType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == WorkloadTransactionGroupType.FILTER) {
            return (V)this.getFilter();
        }
        if (attribute == WorkloadTransactionGroupType.AFFINITY) {
            return (V)this.getAffinity();
        }
        if (attribute == WorkloadTransactionGroupType.AFFINITY_LIFETIME) {
            return (V)this.getAffinityLifetime();
        }
        if (attribute == WorkloadTransactionGroupType.ABEND_CRIT) {
            return (V)this.getAbendCrit();
        }
        if (attribute == WorkloadTransactionGroupType.ABEND_THRESHOLD) {
            return (V)this.getAbendThreshold();
        }
        if (attribute == WorkloadTransactionGroupType.EVENT_NAME) {
            return (V)this.getEventName();
        }
        if (attribute == WorkloadTransactionGroupType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadTransactionGroupType.AUTOMATIC_AFFINITY_CREATION) {
            return (V)this.getAutomaticAffinityCreation();
        }
        if (attribute == WorkloadTransactionGroupType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        if (attribute == WorkloadTransactionGroupType.TRANSACTION_COUNT) {
            return (V)this.getTransactionCount();
        }
        return super.getAttributeValue(attribute);
    }

    public WorkloadTransactionGroupType getObjectType() {
        return WorkloadTransactionGroupType.getInstance();
    }

    @Override
    public WorkloadTransactionGroupReference getCICSObjectReference() {
        return new WorkloadTransactionGroupReference(this.getCICSContainer(), this.getWorkload(), this.getWorkloadOwner(), this.getTransactionGroup());
    }
}

