/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PackagesetReference;
import com.ibm.cics.core.model.PackagesetType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IPackageset;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class Packageset
extends CICSResource
implements IPackageset {
    private String _name;
    private String _changeagent;
    private String _changeagrel;
    private String _changeusrid;
    private String _definesource;
    private Date _definetime;
    private Date _changetime;
    private Date _installtime;
    private String _installagent;
    private String _installusrid;
    private String _baseplatform;
    private String _baseapplictn;
    private Long _baseapmajver;
    private Long _baseapminver;
    private Long _baseapmicver;
    private IPackageset.EnableStatusValue _enablestatus;

    public Packageset(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)PackagesetType.PACKAGESET_NAME).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGENT");
        this._changeagent = (String)((CICSAttribute)PackagesetType.LAST_MODIFICATION_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGREL");
        this._changeagrel = (String)((CICSAttribute)PackagesetType.LAST_MODIFICATION_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("CHANGEUSRID");
        this._changeusrid = (String)((CICSAttribute)PackagesetType.LAST_MODIFICATION_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("DEFINESOURCE");
        this._definesource = (String)((CICSAttribute)PackagesetType.SOURCE_OF_THE_RESOURCE_DEFINITION).get(stringValue, normalizers);
        stringValue = record.get("DEFINETIME");
        this._definetime = (Date)((CICSAttribute)PackagesetType.CREATION_TIME).get(stringValue, normalizers);
        stringValue = record.get("CHANGETIME");
        this._changetime = (Date)((CICSAttribute)PackagesetType.LAST_MODIFICATION_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLTIME");
        this._installtime = (Date)((CICSAttribute)PackagesetType.INSTALLATION_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLAGENT");
        this._installagent = (String)((CICSAttribute)PackagesetType.INSTALLATION_AGENT).get(stringValue, normalizers);
        stringValue = record.get("INSTALLUSRID");
        this._installusrid = (String)((CICSAttribute)PackagesetType.INSTALLATION_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("BASEPLATFORM");
        this._baseplatform = (String)((CICSAttribute)PackagesetType.BASE_PLATFORM_NAME).get(stringValue, normalizers);
        stringValue = record.get("BASEAPPLICTN");
        this._baseapplictn = (String)((CICSAttribute)PackagesetType.BASE_APPLICATION_NAME).get(stringValue, normalizers);
        stringValue = record.get("BASEAPMAJVER");
        this._baseapmajver = (Long)((CICSAttribute)PackagesetType.BASE_APPLICATION_MAJOR_VERSION).get(stringValue, normalizers);
        stringValue = record.get("BASEAPMINVER");
        this._baseapminver = (Long)((CICSAttribute)PackagesetType.BASE_APPLICATION_MINOR_VERSION).get(stringValue, normalizers);
        stringValue = record.get("BASEAPMICVER");
        this._baseapmicver = (Long)((CICSAttribute)PackagesetType.BASE_APPLICATION_MICRO_VERSION).get(stringValue, normalizers);
        stringValue = record.get("ENABLESTATUS");
        this._enablestatus = (IPackageset.EnableStatusValue)((CICSAttribute)PackagesetType.ENABLE_STATUS).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return PackagesetType.BASE_PLATFORM_NAME.internalToExternal((Object)this.getBasePlatformName());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getPackagesetName() {
        return this._name;
    }

    public String getLastModificationAgent() {
        return this._changeagent;
    }

    public String getLastModificationAgentRelease() {
        return this._changeagrel;
    }

    public String getLastModificationUserID() {
        return this._changeusrid;
    }

    public String getSourceOfTheResourceDefinition() {
        return this._definesource;
    }

    public Date getCreationTime() {
        return this._definetime;
    }

    public Date getLastModificationTime() {
        return this._changetime;
    }

    public Date getInstallationTime() {
        return this._installtime;
    }

    public String getInstallationAgent() {
        return this._installagent;
    }

    public String getInstallationUserID() {
        return this._installusrid;
    }

    public String getBasePlatformName() {
        return this._baseplatform;
    }

    public String getBaseApplicationName() {
        return this._baseapplictn;
    }

    public Long getBaseApplicationMajorVersion() {
        return this._baseapmajver;
    }

    public Long getBaseApplicationMinorVersion() {
        return this._baseapminver;
    }

    public Long getBaseApplicationMicroVersion() {
        return this._baseapmicver;
    }

    public IPackageset.EnableStatusValue getEnableStatus() {
        return this._enablestatus;
    }

    public PackagesetType getObjectType() {
        return PackagesetType.getInstance();
    }

    @Override
    public PackagesetReference getCICSObjectReference() {
        return new PackagesetReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PackagesetType.PACKAGESET_NAME) {
            return (V)this.getPackagesetName();
        }
        if (attribute == PackagesetType.LAST_MODIFICATION_AGENT) {
            return (V)this.getLastModificationAgent();
        }
        if (attribute == PackagesetType.LAST_MODIFICATION_AGENT_RELEASE) {
            return (V)this.getLastModificationAgentRelease();
        }
        if (attribute == PackagesetType.LAST_MODIFICATION_USER_ID) {
            return (V)this.getLastModificationUserID();
        }
        if (attribute == PackagesetType.SOURCE_OF_THE_RESOURCE_DEFINITION) {
            return (V)this.getSourceOfTheResourceDefinition();
        }
        if (attribute == PackagesetType.CREATION_TIME) {
            return (V)this.getCreationTime();
        }
        if (attribute == PackagesetType.LAST_MODIFICATION_TIME) {
            return (V)this.getLastModificationTime();
        }
        if (attribute == PackagesetType.INSTALLATION_TIME) {
            return (V)this.getInstallationTime();
        }
        if (attribute == PackagesetType.INSTALLATION_AGENT) {
            return (V)this.getInstallationAgent();
        }
        if (attribute == PackagesetType.INSTALLATION_USER_ID) {
            return (V)this.getInstallationUserID();
        }
        if (attribute == PackagesetType.BASE_PLATFORM_NAME) {
            return (V)this.getBasePlatformName();
        }
        if (attribute == PackagesetType.BASE_APPLICATION_NAME) {
            return (V)this.getBaseApplicationName();
        }
        if (attribute == PackagesetType.BASE_APPLICATION_MAJOR_VERSION) {
            return (V)this.getBaseApplicationMajorVersion();
        }
        if (attribute == PackagesetType.BASE_APPLICATION_MINOR_VERSION) {
            return (V)this.getBaseApplicationMinorVersion();
        }
        if (attribute == PackagesetType.BASE_APPLICATION_MICRO_VERSION) {
            return (V)this.getBaseApplicationMicroVersion();
        }
        if (attribute == PackagesetType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        return super.getAttributeValue(attribute);
    }
}

