/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PhysicalDataSetReference;
import com.ibm.cics.core.model.PhysicalDataSetType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IPhysicalDataSet;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class PhysicalDataSet
extends CICSResource
implements IPhysicalDataSet {
    private String _dsname;
    private IPhysicalDataSet.AccessMethodValue _accessmethod;
    private IPhysicalDataSet.BackUpTypeValue _backuptype;
    private String _basedsname;
    private Long _filecount;
    private IPhysicalDataSet.DataSetTypeValue _object;
    private IPhysicalDataSet.RecoveryStatusValue _recovstatus;
    private IPhysicalDataSet.DataSetValidityValue _validity;
    private Long _fwdrecovlog;
    private String _fwdrecovlsn;
    private IPhysicalDataSet.AvailabilityValue _availability;
    private IPhysicalDataSet.LostLocksValue _lostlocks;
    private IPhysicalDataSet.QuiesceStateValue _quiescestate;
    private IPhysicalDataSet.RetainedRecordLocksValue _retlocks;
    private IPhysicalDataSet.ReplicationLoggingStatusValue _logrepstatus;

    public PhysicalDataSet(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("DSNAME");
        this._dsname = (String)((CICSAttribute)PhysicalDataSetType.DSNAME).get(stringValue, normalizers);
        stringValue = record.get("ACCESSMETHOD");
        this._accessmethod = (IPhysicalDataSet.AccessMethodValue)((CICSAttribute)PhysicalDataSetType.ACCESS_METHOD).get(stringValue, normalizers);
        stringValue = record.get("BACKUPTYPE");
        this._backuptype = (IPhysicalDataSet.BackUpTypeValue)((CICSAttribute)PhysicalDataSetType.BACK_UP_TYPE).get(stringValue, normalizers);
        stringValue = record.get("BASEDSNAME");
        this._basedsname = (String)((CICSAttribute)PhysicalDataSetType.BASE_DS_NAME).get(stringValue, normalizers);
        stringValue = record.get("FILECOUNT");
        this._filecount = (Long)((CICSAttribute)PhysicalDataSetType.FILE_COUNT).get(stringValue, normalizers);
        stringValue = record.get("OBJECT");
        this._object = (IPhysicalDataSet.DataSetTypeValue)((CICSAttribute)PhysicalDataSetType.DATA_SET_TYPE).get(stringValue, normalizers);
        stringValue = record.get("RECOVSTATUS");
        this._recovstatus = (IPhysicalDataSet.RecoveryStatusValue)((CICSAttribute)PhysicalDataSetType.RECOVERY_STATUS).get(stringValue, normalizers);
        stringValue = record.get("VALIDITY");
        this._validity = (IPhysicalDataSet.DataSetValidityValue)((CICSAttribute)PhysicalDataSetType.DATA_SET_VALIDITY).get(stringValue, normalizers);
        stringValue = record.get("FWDRECOVLOG");
        this._fwdrecovlog = (Long)((CICSAttribute)PhysicalDataSetType.JOURNAL_NUMBER).get(stringValue, normalizers);
        stringValue = record.get("FWDRECOVLSN");
        this._fwdrecovlsn = (String)((CICSAttribute)PhysicalDataSetType.LOG_STREAM_NAME).get(stringValue, normalizers);
        stringValue = record.get("AVAILABILITY");
        this._availability = (IPhysicalDataSet.AvailabilityValue)((CICSAttribute)PhysicalDataSetType.AVAILABILITY).get(stringValue, normalizers);
        stringValue = record.get("LOSTLOCKS");
        this._lostlocks = (IPhysicalDataSet.LostLocksValue)((CICSAttribute)PhysicalDataSetType.LOST_LOCKS).get(stringValue, normalizers);
        stringValue = record.get("QUIESCESTATE");
        this._quiescestate = (IPhysicalDataSet.QuiesceStateValue)((CICSAttribute)PhysicalDataSetType.QUIESCE_STATE).get(stringValue, normalizers);
        stringValue = record.get("RETLOCKS");
        this._retlocks = (IPhysicalDataSet.RetainedRecordLocksValue)((CICSAttribute)PhysicalDataSetType.RETAINED_RECORD_LOCKS).get(stringValue, normalizers);
        stringValue = record.get("LOGREPSTATUS");
        this._logrepstatus = (IPhysicalDataSet.ReplicationLoggingStatusValue)((CICSAttribute)PhysicalDataSetType.REPLICATION_LOGGING_STATUS).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return PhysicalDataSetType.DSNAME.internalToExternal((Object)this.getDsname());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getDsname() {
        return this._dsname;
    }

    public IPhysicalDataSet.AccessMethodValue getAccessMethod() {
        return this._accessmethod;
    }

    public IPhysicalDataSet.BackUpTypeValue getBackUpType() {
        return this._backuptype;
    }

    public String getBaseDSName() {
        return this._basedsname;
    }

    public Long getFileCount() {
        return this._filecount;
    }

    public IPhysicalDataSet.DataSetTypeValue getDataSetType() {
        return this._object;
    }

    public IPhysicalDataSet.RecoveryStatusValue getRecoveryStatus() {
        return this._recovstatus;
    }

    public IPhysicalDataSet.DataSetValidityValue getDataSetValidity() {
        return this._validity;
    }

    public Long getJournalNumber() {
        return this._fwdrecovlog;
    }

    public String getLogStreamName() {
        return this._fwdrecovlsn;
    }

    public IPhysicalDataSet.AvailabilityValue getAvailability() {
        return this._availability;
    }

    public IPhysicalDataSet.LostLocksValue getLostLocks() {
        return this._lostlocks;
    }

    public IPhysicalDataSet.QuiesceStateValue getQuiesceState() {
        return this._quiescestate;
    }

    public IPhysicalDataSet.RetainedRecordLocksValue getRetainedRecordLocks() {
        return this._retlocks;
    }

    public IPhysicalDataSet.ReplicationLoggingStatusValue getReplicationLoggingStatus() {
        return this._logrepstatus;
    }

    public PhysicalDataSetType getObjectType() {
        return PhysicalDataSetType.getInstance();
    }

    @Override
    public PhysicalDataSetReference getCICSObjectReference() {
        return new PhysicalDataSetReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PhysicalDataSetType.DSNAME) {
            return (V)this.getDsname();
        }
        if (attribute == PhysicalDataSetType.ACCESS_METHOD) {
            return (V)this.getAccessMethod();
        }
        if (attribute == PhysicalDataSetType.BACK_UP_TYPE) {
            return (V)this.getBackUpType();
        }
        if (attribute == PhysicalDataSetType.BASE_DS_NAME) {
            return (V)this.getBaseDSName();
        }
        if (attribute == PhysicalDataSetType.FILE_COUNT) {
            return (V)this.getFileCount();
        }
        if (attribute == PhysicalDataSetType.DATA_SET_TYPE) {
            return (V)this.getDataSetType();
        }
        if (attribute == PhysicalDataSetType.RECOVERY_STATUS) {
            return (V)this.getRecoveryStatus();
        }
        if (attribute == PhysicalDataSetType.DATA_SET_VALIDITY) {
            return (V)this.getDataSetValidity();
        }
        if (attribute == PhysicalDataSetType.JOURNAL_NUMBER) {
            return (V)this.getJournalNumber();
        }
        if (attribute == PhysicalDataSetType.LOG_STREAM_NAME) {
            return (V)this.getLogStreamName();
        }
        if (attribute == PhysicalDataSetType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        if (attribute == PhysicalDataSetType.LOST_LOCKS) {
            return (V)this.getLostLocks();
        }
        if (attribute == PhysicalDataSetType.QUIESCE_STATE) {
            return (V)this.getQuiesceState();
        }
        if (attribute == PhysicalDataSetType.RETAINED_RECORD_LOCKS) {
            return (V)this.getRetainedRecordLocks();
        }
        if (attribute == PhysicalDataSetType.REPLICATION_LOGGING_STATUS) {
            return (V)this.getReplicationLoggingStatus();
        }
        return super.getAttributeValue(attribute);
    }
}

