/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SystemParameterReference;
import com.ibm.cics.core.model.SystemParameterType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.ISystemParameter;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class SystemParameterGen
extends CICSResource
implements ISystemParameter {
    private String _keyword;
    private ISystemParameter.TypeValue _type;
    private ISystemParameter.SourceValue _source;
    private Long _valuelen;
    private Long _segnum;
    private Long _segtot;
    private Long _totallen;
    private String _value;

    public SystemParameterGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("KEYWORD");
        this._keyword = (String)((CICSAttribute)SystemParameterType.KEYWORD).get(stringValue, normalizers);
        stringValue = record.get("TYPE");
        this._type = (ISystemParameter.TypeValue)((CICSAttribute)SystemParameterType.TYPE).get(stringValue, normalizers);
        stringValue = record.get("SOURCE");
        this._source = (ISystemParameter.SourceValue)((CICSAttribute)SystemParameterType.SOURCE).get(stringValue, normalizers);
        stringValue = record.get("VALUELEN");
        this._valuelen = (Long)((CICSAttribute)SystemParameterType.VALUELEN).get(stringValue, normalizers);
        stringValue = record.get("SEGNUM");
        this._segnum = (Long)((CICSAttribute)SystemParameterType.SEGNUM).get(stringValue, normalizers);
        stringValue = record.get("SEGTOT");
        this._segtot = (Long)((CICSAttribute)SystemParameterType.SEGTOT).get(stringValue, normalizers);
        stringValue = record.get("TOTALLEN");
        this._totallen = (Long)((CICSAttribute)SystemParameterType.TOTALLEN).get(stringValue, normalizers);
        stringValue = record.get("VALUE");
        this._value = (String)((CICSAttribute)SystemParameterType.VALUE).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return SystemParameterType.KEYWORD.internalToExternal((Object)this.getKeyword());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getKeyword() {
        return this._keyword;
    }

    public ISystemParameter.TypeValue getType() {
        return this._type;
    }

    public ISystemParameter.SourceValue getSource() {
        return this._source;
    }

    public Long getValuelen() {
        return this._valuelen;
    }

    public Long getSegnum() {
        return this._segnum;
    }

    public Long getSegtot() {
        return this._segtot;
    }

    public Long getTotallen() {
        return this._totallen;
    }

    public String getValue() {
        return this._value;
    }

    public SystemParameterType getObjectType() {
        return SystemParameterType.getInstance();
    }

    @Override
    public SystemParameterReference getCICSObjectReference() {
        return new SystemParameterReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == SystemParameterType.KEYWORD) {
            return (V)this.getKeyword();
        }
        if (attribute == SystemParameterType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == SystemParameterType.SOURCE) {
            return (V)this.getSource();
        }
        if (attribute == SystemParameterType.VALUELEN) {
            return (V)this.getValuelen();
        }
        if (attribute == SystemParameterType.SEGNUM) {
            return (V)this.getSegnum();
        }
        if (attribute == SystemParameterType.SEGTOT) {
            return (V)this.getSegtot();
        }
        if (attribute == SystemParameterType.TOTALLEN) {
            return (V)this.getTotallen();
        }
        if (attribute == SystemParameterType.VALUE) {
            return (V)this.getValue();
        }
        return super.getAttributeValue(attribute);
    }
}

