/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadTransactionReference;
import com.ibm.cics.core.model.WorkloadTransactionType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkloadTransaction;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class WorkloadTransactionGen
extends CPSMManager
implements IWorkloadTransaction {
    private String _tranid;
    private IWorkloadTransaction.PseudoModeValue _pseudomode;
    private String _trangrp;
    private String _workload;
    private String _wrklowner;

    public WorkloadTransactionGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TRANID");
        this._tranid = (String)((CICSAttribute)WorkloadTransactionType.TRANSACTION_ID).get(stringValue, normalizers);
        stringValue = record.get("PSEUDOMODE");
        this._pseudomode = (IWorkloadTransaction.PseudoModeValue)((CICSAttribute)WorkloadTransactionType.PSEUDO_MODE).get(stringValue, normalizers);
        stringValue = record.get("TRANGRP");
        this._trangrp = (String)((CICSAttribute)WorkloadTransactionType.TRANSACTION_GROUP).get(stringValue, normalizers);
        stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadTransactionType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadTransactionType.WORKLOAD_OWNER).get(stringValue, normalizers);
    }

    public String getTransactionID() {
        return this._tranid;
    }

    public IWorkloadTransaction.PseudoModeValue getPseudoMode() {
        return this._pseudomode;
    }

    public String getTransactionGroup() {
        return this._trangrp;
    }

    public String getWorkload() {
        return this._workload;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public WorkloadTransactionType getObjectType() {
        return WorkloadTransactionType.getInstance();
    }

    @Override
    public WorkloadTransactionReference getCICSObjectReference() {
        return new WorkloadTransactionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadTransactionType.TRANSACTION_ID) {
            return (V)this.getTransactionID();
        }
        if (attribute == WorkloadTransactionType.PSEUDO_MODE) {
            return (V)this.getPseudoMode();
        }
        if (attribute == WorkloadTransactionType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == WorkloadTransactionType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadTransactionType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        return super.getAttributeValue(attribute);
    }
}

