/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class ExplorerLoggerFormatter
extends Formatter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");
    private static final String lineSeparator = ExplorerLoggerFormatter.getLineSeparatorProperty();
    private final String head;

    public ExplorerLoggerFormatter() {
        this(null);
    }

    public ExplorerLoggerFormatter(String head) {
        this.head = head;
    }

    private static String getLineSeparatorProperty() {
        String value;
        try {
            value = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            value = "\n";
        }
        return value;
    }

    @Override
    public String getHead(Handler h) {
        if (this.head == null) {
            return super.getHead(h);
        }
        return String.valueOf(this.head) + ExplorerLoggerFormatter.getLineSeparatorProperty();
    }

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() != null) {
            return String.valueOf(ExplorerLoggerFormatter.formatDate(record.getMillis())) + " [" + ExplorerLoggerFormatter.formatThread(record) + "] ! " + record.getSourceClassName() + "." + record.getSourceMethodName() + "()" + ExplorerLoggerFormatter.formatThrown(record.getThrown()) + lineSeparator;
        }
        return String.valueOf(ExplorerLoggerFormatter.formatDate(record.getMillis())) + " [" + ExplorerLoggerFormatter.formatThread(record) + "] " + record.getMessage() + " " + record.getSourceClassName() + "." + record.getSourceMethodName() + "()" + ExplorerLoggerFormatter.formatParameters(record.getParameters()) + lineSeparator;
    }

    private static String formatDate(long millis) {
        return timeFormat.format(new Date(millis));
    }

    private static String formatThread(LogRecord record) {
        return String.valueOf(record.getThreadID());
    }

    private static String formatParameters(Object[] parameters) {
        if (parameters != null) {
            return " " + Arrays.asList(parameters);
        }
        return "";
    }

    public Object formatParameter(Object parameter) {
        if (parameter == null || parameter instanceof String || parameter instanceof Number || parameter instanceof Boolean || parameter instanceof Exception || parameter instanceof Character || parameter instanceof Class || parameter instanceof File || parameter instanceof StringBuffer || parameter instanceof URL) {
            return parameter;
        }
        if (parameter.getClass().isArray()) {
            return Arrays.asList(parameter);
        }
        return String.valueOf(parameter);
    }

    private static String formatThrown(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Throwable cause = throwable;
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        printWriter.close();
        return " [" + throwable + "]" + lineSeparator + stringWriter;
    }
}

