/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.explorer.tables.ui.internal.ILegacyNavigationListener;
import com.ibm.cics.model.ICMASList;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class LegacyNavigationService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(LegacyNavigationService.class);
    private Map<Class<? extends IContext>, IContext> selectedContexts = new HashMap<Class<? extends IContext>, IContext>();
    private Map<Class<? extends IContext>, Object> selectedObjects = new HashMap<Class<? extends IContext>, Object>();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IStructuredSelection structuredSelection;
            Object firstElement;
            if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
                IContext newContext = LegacyNavigationService.this.getContextFor(firstElement);
                DEBUG.event("selectionChanged", (Object)this, (Object)part, firstElement);
                if (newContext != null) {
                    Class contextType = newContext instanceof ICMASContext ? ICMASContext.class : IContext.class;
                    LegacyNavigationService.this.setContext(contextType, newContext);
                    LegacyNavigationService.this.setSelectedObject(contextType, firstElement);
                }
            }
        }
    };
    private ISelectionService selectionService;
    List<ILegacyNavigationListener> listeners = new ArrayList<ILegacyNavigationListener>();

    public void dispose() {
        this.selectionService.removeSelectionListener(this.selectionListener);
    }

    private IContext getContextFor(Object element) {
        Object elementContext = null;
        String adapterTypeName = IContextProvider.class.getName();
        IContextProvider adapter = (IContextProvider)Platform.getAdapterManager().loadAdapter(element, adapterTypeName);
        if (adapter != null) {
            elementContext = adapter.getIContext();
        } else {
            if (element instanceof IContextProvider) {
                IContextProvider provider = (IContextProvider)element;
                return provider.getIContext();
            }
            if (element instanceof ICMASList) {
                final String cmasName = ((ICMASList)element).getName();
                elementContext = new ICMASContext(){

                    public String getContext() {
                        return cmasName;
                    }
                };
            }
        }
        return elementContext;
    }

    private boolean isConnected() {
        return ConnectionsPlugin.getDefault().getConnectionService().getConnectionState("com.ibm.cics.sm.connection") instanceof ConnectedState;
    }

    public IContext getContext(Class<? extends IContext> contextType) {
        if (this.isConnected()) {
            IContext context = this.selectedContexts.get(contextType);
            DEBUG.event("getContext", contextType, (Object)context);
            return context;
        }
        return null;
    }

    private void setContext(Class<? extends IContext> contextType, IContext newContext) {
        DEBUG.event("setContext", contextType, (Object)newContext);
        this.selectedContexts.put(contextType, newContext);
        this.fireContextChanged();
    }

    public Object getSelectedObject(Class<? extends IContext> contextType) {
        if (this.isConnected()) {
            Object object = this.selectedObjects.get(contextType);
            DEBUG.event("getSelectedObject", contextType, object);
            return object;
        }
        return null;
    }

    private void setSelectedObject(Class<? extends IContext> contextType, Object newSelectedObject) {
        DEBUG.event("setContext", contextType, newSelectedObject);
        this.selectedObjects.put(contextType, newSelectedObject);
    }

    public void addLegacyNavigationListener(ILegacyNavigationListener listener) {
        this.listeners.add(listener);
    }

    public void removeLegacyNavigationListener(ILegacyNavigationListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireContextChanged() {
        for (ILegacyNavigationListener listener : this.listeners) {
            listener.contextChanged();
        }
    }

    void setSelectionService(ISelectionService selectionService) {
        this.selectionService = selectionService;
        selectionService.addSelectionListener(this.selectionListener);
    }
}

