/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ResourceDescriptionDefinitionType;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.actions.GetExecutionDelegate;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.core.runtime.IStatus;

public class RemoveFromResourceDescriptionExecutionDelegate
implements IOperationExecutionDelegate<IResourceGroupDefinition> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPrimaryKey resourceDescriptionPrimaryKey;
    private IResourceDescriptionDefinition resourceDescriptionDefinition;

    public RemoveFromResourceDescriptionExecutionDelegate(IPrimaryKey resourceDescriptionPrimaryKey) {
        this.resourceDescriptionPrimaryKey = resourceDescriptionPrimaryKey;
    }

    public void execute(IResourceGroupDefinition target) throws ExecutionFailedException {
        ICPSM cpsm = ((ICoreObject)target).getCPSM();
        try {
            cpsm.remove(this.getResourceDescriptionDefinition(cpsm), target);
        }
        catch (CICSSystemManagerException ex) {
            IStatus status = ExceptionMessageHelper.getStatus((CICSActionException)((Object)ex), ResourceGroupDefinitionType.getInstance(), 2);
            throw new ExecutionFailedException(status);
        }
    }

    private IResourceDescriptionDefinition getResourceDescriptionDefinition(ICPSM cpsm) throws ExecutionFailedException {
        if (this.resourceDescriptionDefinition == null) {
            GetExecutionDelegate executionDelegate = new GetExecutionDelegate((ICICSType<?>)ResourceDescriptionDefinitionType.getInstance(), cpsm);
            executionDelegate.execute(this.resourceDescriptionPrimaryKey);
            this.resourceDescriptionDefinition = (IResourceDescriptionDefinition)executionDelegate.getCICSObject();
        }
        return this.resourceDescriptionDefinition;
    }

    public String getOperationDescription(IResourceGroupDefinition target) {
        String groupTypeName = Messages.getTableDescription(ResourceGroupDefinitionType.getInstance().getResourceTableName());
        String listTypeName = Messages.getTableDescription(ResourceDescriptionDefinitionType.getInstance().getResourceTableName());
        String groupName = target.getName();
        String listName = this.resourceDescriptionPrimaryKey.getAttributeValue(ResourceDescriptionDefinitionType.NAME.getCicsName());
        String repositoryName = ExceptionMessageHelper.getContextOrScopeNameFor((IContext)this.resourceDescriptionPrimaryKey);
        return com.ibm.cics.core.ui.actions.Messages.getString("operation.removeGroupFromList.description", groupTypeName, groupName, listTypeName, listName, repositoryName);
    }

    public String getOperationName() {
        return com.ibm.cics.core.ui.actions.Messages.getString("RemoveFromResourceDescriptionExecutionDelegate.removeFromResourceDescription");
    }

    public int getID() {
        return 615;
    }
}

