/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class CICSSystemsTreeAdapter
implements IDeferredWorkbenchAdapter,
IAdaptable,
IAdaptableTreeNode,
IContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CICSSystemsTreeAdapter.class);
    private ICICSplex cicsPlex;

    public CICSSystemsTreeAdapter(ICICSplex cicsPlex) {
        this.cicsPlex = cicsPlex;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ModelUIPlugin.getTypeImageDescriptor((ICICSType)ManagedRegionType.getInstance());
    }

    public String getLabel(Object o) {
        return Messages.getString("CICSSystemsTreeAdapter.systems");
    }

    public Object getParent(Object o) {
        return this.cicsPlex;
    }

    public ICPSM getCPSM() {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        debug.enter("getAdapter", (Object)this, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return new CICSObjectPropertySource((ICICSObject)CICSSystemsTreeAdapter.this.cicsPlex);
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        debug.exit("getAdapter", adapter);
        return adapter;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        debug.enter("fetchDeferredChildren", (Object)this, object, (Object)collector, (Object)monitor);
        monitor.beginTask(Messages.getString("CICSSystemsTreeAdapter.fetchManagedRegions"), -1);
        Object[] regions = this.getCICSSystems();
        collector.add(regions, monitor);
        monitor.done();
        debug.exit("fetchDeferredChildren");
    }

    public ICICSObject[] getCICSSystems() {
        ICICSObject[] managedRegions = ((IParent)this.cicsPlex).getChildrenAsArray((ICICSType)ManagedRegionType.getInstance());
        return managedRegions;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public IContext getIContext() {
        return new Context(this.cicsPlex.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cicsPlex == null ? 0 : this.cicsPlex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CICSSystemsTreeAdapter other = (CICSSystemsTreeAdapter)obj;
        return !(this.cicsPlex == null ? other.cicsPlex != null : !this.cicsPlex.equals(other.cicsPlex));
    }
}

