/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.model.TransactionGroupReference;
import com.ibm.cics.core.model.WorkloadDefinitionType;
import com.ibm.cics.core.model.WorkloadTransactionGroupType;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.model.extra.IWLMActiveRuleEditorSource;
import com.ibm.cics.core.ui.adapters.IDecoratableWLMAdapter;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.core.ui.adapters.WLMRuleTargetsAdapter;
import com.ibm.cics.core.ui.adapters.WLMTransactionGroupAdapter;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.ITransactionGroup;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTransactionGroup;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMRuleAdapter
extends WLMAbstractRuleRelatedAdapter
implements IAdaptableTreeNode,
IAdaptable,
IDeferredWorkbenchAdapter,
IWLMActiveRuleEditorSource,
IDecoratableWLMAdapter,
IContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(WLMRuleAdapter.class);
    private final IActiveWorkloadDefinition rule;

    public WLMRuleAdapter(IWorkload wlmActiveWorkload, IActiveWorkloadDefinition rule) {
        super(wlmActiveWorkload);
        this.rule = rule;
    }

    public IActiveWorkloadDefinition getAdaptedRule() {
        return this.rule;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public Object[] getChildren(Object o) {
        Object[] children;
        DEBUG.enter("getChildren", (Object)this, o);
        String transactionGroup = this.rule.getTransactionGroup();
        if (!transactionGroup.isEmpty()) {
            children = new Object[2];
            children[1] = this.getWorkloadTransactionGroup(transactionGroup);
        } else {
            children = new Object[]{new WLMRuleTargetsAdapter(this, this.activeWorkload)};
        }
        DEBUG.exit("getChildren", (Object)children);
        return children;
    }

    public ICPSM getCPSM() {
        return ((ICoreObject)this.rule).getCPSM();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return ModelUIPlugin.getTypeImageDescriptor((ICICSType)WorkloadDefinitionType.getInstance());
    }

    public String getLabel(Object o) {
        String description = this.rule.getDescription();
        if (description != null && !description.isEmpty()) {
            return description;
        }
        return this.getName();
    }

    public String getName() {
        return this.rule.getName();
    }

    public ICICSType getObjectType() {
        return this.rule.getObjectType();
    }

    public Object getParent(Object o) {
        return null;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    private Object getWorkloadTransactionGroup(String name) {
        DEBUG.enter("getWorkloadTransactionGroup", (Object)this, (Object)name);
        FilteredContext filteredContext = new FilteredContext((IContext)WLMAbstractRuleRelatedAdapter.getWorkloadBaseContext(this.activeWorkload), new AttributeValue[]{new AttributeValue(WorkloadTransactionGroupType.TRANSACTION_GROUP, (Object)name)});
        filteredContext.setAttributeValue(WorkloadTransactionGroupType.WORKLOAD, (Object)this.activeWorkload.getName());
        WLMTransactionGroupAdapter workloadTransactionGroup = null;
        ICICSObject[] workloadTransactionGroups = null;
        try {
            workloadTransactionGroups = WLMAbstractRuleRelatedAdapter.getWorkloadCPSM(this.activeWorkload).getDefinitions2((ICICSType)WorkloadTransactionGroupType.getInstance(), (IContext)filteredContext);
            if (workloadTransactionGroups.length != 1 || !(workloadTransactionGroups[0] instanceof IWorkloadTransactionGroup)) {
                throw new RuntimeException("Failed to get workload transaction group");
            }
            IWorkloadTransactionGroup wlmTranGroup = (IWorkloadTransactionGroup)workloadTransactionGroups[0];
            workloadTransactionGroup = new WLMTransactionGroupAdapter(this.activeWorkload, wlmTranGroup, this.getRelatedTransactionGroup(wlmTranGroup), this);
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null && !(e.getCause() instanceof SystemManagerConnectionException)) {
                DEBUG.event("getChildren", (Object)e);
                return new ErrorWrapper(e.getCause());
            }
            DEBUG.error("getChildren", (Throwable)e);
        }
        DEBUG.exit("getWorkloadTransactionGroup", workloadTransactionGroup);
        return workloadTransactionGroup;
    }

    private ITransactionGroup getRelatedTransactionGroup(IWorkloadTransactionGroup wlmTranGroup) {
        ITransactionGroup relatedTranGroup;
        try {
            ICPSMDefinitionContainer cpsmDefinitionContainer = wlmTranGroup.getCICSContainer().getCPSMDefinitionContainer();
            relatedTranGroup = (ITransactionGroup)new TransactionGroupReference(cpsmDefinitionContainer, wlmTranGroup.getName()).resolve();
        }
        catch (CICSActionException e) {
            DEBUG.error("getRelatedTransactionGroupDefinition", e.getCause());
            relatedTranGroup = null;
        }
        return relatedTranGroup;
    }

    public ICICSObject getEditorInputObject() {
        return this.getAdaptedRule();
    }

    public Object getAdapter(Class adapterType) {
        DEBUG.enter("getAdapter", (Object)this, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return new CICSObjectPropertySource((ICICSObject)WLMRuleAdapter.this.getAdaptedRule());
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        DEBUG.exit("getAdapter", adapter);
        return adapter;
    }

    @Override
    public String getDecoration() {
        String description = this.rule.getDescription();
        if (description != null && !description.isEmpty()) {
            return this.getName();
        }
        return null;
    }

    public IContext getIContext() {
        return new ScopedContext((IContext)WLMRuleAdapter.getWorkloadBaseContext(this.activeWorkload), this.getAdaptedRule().getTargetScope());
    }
}

