/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.IPlatformProvider;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.PlatformAppsNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformRegionTypesNodeDeferredWorkbenchAdapter;
import com.ibm.cics.model.IPlatform;
import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

final class PlatformDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter
implements IPlatformProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(PlatformDeferredWorkbenchAdapter.class);
    private final IPlatform platform;

    PlatformDeferredWorkbenchAdapter(CloudInput input, IPlatform aPlatform) {
        super(input);
        DEBUG.enter("constructor", (Object)this, (Object)aPlatform);
        this.platform = aPlatform;
        DEBUG.exit("constructor");
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = this.platform.getName();
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = ImageDescriptor.createFromImage((Image)UIPlugin.getTableImage(PlatformType.getInstance().getResourceTableName()));
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        DEBUG.enter("getDataChildren", (Object)this, o);
        ArrayList<AbstractCPSMDeferredWorkbenchAdapter> headingNodes = new ArrayList<AbstractCPSMDeferredWorkbenchAdapter>();
        headingNodes.add(new PlatformAppsNodeDeferredWorkbenchAdapter(this.getCloudInput(), this.platform));
        headingNodes.add(new PlatformRegionTypesNodeDeferredWorkbenchAdapter(this.getCloudInput(), this.platform));
        Object[] children = headingNodes.toArray();
        DEBUG.exit("getDataChildren", (Object)children);
        return children;
    }

    public boolean isContainer() {
        DEBUG.enter("isContainer", (Object)this);
        boolean result = true;
        DEBUG.exit("isContainer", (Object)result);
        return result;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        DEBUG.enter("getDecorateText", (Object)this, (Object)context);
        String result = this.platform.getStatus().toString();
        DEBUG.exit("getDecorateText", (Object)result);
        return result;
    }

    @Override
    public String getPlatformDefinitionName() {
        return this.platform.getPlatformDefinitionName();
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_applications, null);
    }
}

