/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.viewers.GroupNode;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class GroupedCICSObjectTreeLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ILabelProvider delegate;

    public GroupedCICSObjectTreeLabelProvider(ILabelProvider delegate) {
        this.delegate = delegate;
    }

    public Image getImage(Object element) {
        if (element instanceof GroupNode) {
            return this.getNodeImage(element);
        }
        return this.delegate.getImage(element);
    }

    private Image getNodeImage(Object element) {
        String groupType = ((GroupNode)element).getCICSType();
        return UIPlugin.getTableImage(groupType);
    }

    public String getText(Object element) {
        if (element instanceof GroupNode) {
            return this.getLabel((GroupNode)element);
        }
        return this.delegate.getText(element);
    }

    private String getLabel(GroupNode node) {
        String groupType = node.getCICSType();
        return Messages.getPluralTableDescription(groupType);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof GroupNode) {
            GroupNode groupNode = (GroupNode)element;
            String label = this.getLabel(groupNode);
            Image image = this.getNodeImage(groupNode);
            cell.setText(label);
            cell.setImage(image);
        } else if (this.delegate instanceof CellLabelProvider) {
            ((CellLabelProvider)this.delegate).update(cell);
        } else {
            cell.setText(this.getText(element));
            cell.setImage(this.getImage(element));
        }
        super.update(cell);
    }

    public void dispose() {
        this.delegate.dispose();
        super.dispose();
    }
}

