/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.ResourcesViewColumnDialog;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class ColumnDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String PROPERTY_DESCRIPTOR = "PROPERTY_DESCRIPTOR";
    protected static final String DIALOG_HELP_CONTEXT_ID = "com.ibm.cics.core.ui.dialog_ResourcesViewColumnDialog";
    private static final int RESET = 12345;
    protected static final Logger logger = Logger.getLogger(ResourcesViewColumnDialog.class.getPackage().getName());
    protected static final String X_LOCATION = "ResourcesView.customizeColumns.dialog.x_location";
    protected static final String Y_LOCATION = "ResourcesView.customizeColumns.dialog.y_location";
    protected static final String WIDTH = "ResourcesView.customizeColumns.dialog.width";
    protected static final String HEIGHT = "ResourcesView.customizeColumns.dialog.height";
    protected Button addButton;
    protected Button removeButton;
    protected FilteredTree availableColumnsTree;
    protected FilteredTree currentlyUsedColumnsTree;
    protected TreeViewer availableColumnsTreeViewer;
    protected TreeViewer currentlyUsedColumnsTreeViewer;

    protected ColumnDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.getViewTitle());
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite columnsComposite = new Composite(c, 0);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        columnsComposite.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(columnsComposite, 0);
        l.setText(this.getAvailableAttributesString());
        l = new Label(columnsComposite, 0);
        l = new Label(columnsComposite, 0);
        l.setText(this.getCurrentlyUsedAttributesString());
        this.availableColumnsTree = new FilteredTree(columnsComposite, 2818, new PatternFilter(), true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.availableColumnsTree.setLayoutData((Object)data);
        Composite buttonArea = new Composite(columnsComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        this.currentlyUsedColumnsTree = new FilteredTree(columnsComposite, 2818, new PatternFilter(), true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.currentlyUsedColumnsTree.setLayoutData((Object)data);
        this.availableColumnsTreeViewer = this.availableColumnsTree.getViewer();
        this.availableColumnsTreeViewer.setContentProvider((IContentProvider)this.getAvailableTreeContentProvider());
        this.availableColumnsTreeViewer.setInput(this.getAvailableTreeInput());
        this.availableColumnsTreeViewer.setLabelProvider((IBaseLabelProvider)this.getTreeLabelProvider());
        this.currentlyUsedColumnsTreeViewer = this.currentlyUsedColumnsTree.getViewer();
        this.currentlyUsedColumnsTreeViewer.setContentProvider((IContentProvider)this.getCurrentlyUsedTreeContentProvider());
        this.currentlyUsedColumnsTreeViewer.setInput(this.getCurrentlyUsedTreeInput());
        this.currentlyUsedColumnsTreeViewer.setLabelProvider((IBaseLabelProvider)this.getTreeLabelProvider());
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(this.getAddButtonText());
        data = new GridData(4, 0, true, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText(this.getRemoveButtonText());
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        this.availableColumnsTreeViewer.getTree().addSelectionListener((SelectionListener)this.getAvailableSelectionListener());
        this.currentlyUsedColumnsTreeViewer.getTree().addSelectionListener((SelectionListener)this.getCurrentlyUsedSelectionListener());
        this.addButton.addSelectionListener((SelectionListener)this.getAddButtonSelectionListener());
        this.removeButton.addSelectionListener((SelectionListener)this.getRemoveButtonSelectionListener());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point location = ColumnDialog.this.getShell().getLocation();
                Point size = ColumnDialog.this.getShell().getSize();
                IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(ColumnDialog.X_LOCATION, location.x);
                preferenceStore.setValue(ColumnDialog.Y_LOCATION, location.y);
                preferenceStore.setValue(ColumnDialog.WIDTH, size.x);
                preferenceStore.setValue(ColumnDialog.HEIGHT, size.y);
                UIPlugin.getDefault().savePluginPreferences();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), DIALOG_HELP_CONTEXT_ID);
        return c;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        int x_location = this.getPreferenceValue(X_LOCATION);
        int y_location = this.getPreferenceValue(Y_LOCATION);
        if (x_location != 0 && y_location != 0) {
            this.getShell().setLocation(x_location, y_location);
        }
        int width = this.getPreferenceValue(WIDTH);
        int height = this.getPreferenceValue(HEIGHT);
        if (width != 0 && height != 0) {
            this.getShell().setSize(width, height);
        }
    }

    private int getPreferenceValue(String preferenceKey) {
        return UIPlugin.getDefault().getPreferenceStore().getInt(preferenceKey);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12345, Messages.getString("ColumnSelectionDialog_Reset"), false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12345) {
            this.reset();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public abstract void reset();

    public abstract String getViewTitle();

    public abstract String getAvailableAttributesString();

    public abstract String getCurrentlyUsedAttributesString();

    public abstract ITreeContentProvider getAvailableTreeContentProvider();

    public abstract ITreeContentProvider getCurrentlyUsedTreeContentProvider();

    public abstract Object getAvailableTreeInput();

    public abstract Object getCurrentlyUsedTreeInput();

    public abstract ILabelProvider getTreeLabelProvider();

    public abstract String getAddButtonText();

    public abstract String getRemoveButtonText();

    public abstract SelectionAdapter getAddButtonSelectionListener();

    public abstract SelectionAdapter getRemoveButtonSelectionListener();

    public abstract SelectionAdapter getAvailableSelectionListener();

    public abstract SelectionAdapter getCurrentlyUsedSelectionListener();

    public abstract class FlatTreeContentProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }
}

