/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import java.util.List;

public class StringUtil {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final char BLANK_SPACE_CHAR = ' ';
    public static final char TILDE_CHAR = '~';
    public static final char INVERTED_EXCLAMATION_MARK = '\u00a1';
    public static final char Y_WITH_DIERESIS = '\u00ff';

    public static String toDisplayString(String aString) {
        return aString == null ? "" : aString;
    }

    public static boolean containsNonLatin1PrintableChars(String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (!(c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u00ff')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static boolean hasContent(String aString) {
        return !StringUtil.isEmpty(aString);
    }

    public static boolean safeEquals(Object s1, Object s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static String removeCharNulls(String input) {
        char ascii0 = '\u0000';
        return input.replaceAll(String.valueOf(ascii0), "");
    }

    public static String join(List<?> list, String delimeter) {
        StringBuffer buff = new StringBuffer();
        for (Object o : list) {
            if (buff.length() > 0) {
                buff.append(delimeter);
            }
            buff.append(String.valueOf(o));
        }
        return buff.toString();
    }

    public static String padString(String source, int totalLength) throws IllegalArgumentException {
        if (source.length() > totalLength) {
            throw new IllegalArgumentException("String to pad shorter than total length required");
        }
        StringBuffer result = new StringBuffer();
        result.append(source);
        int j = source.length();
        while (j < totalLength) {
            result.append(' ');
            ++j;
        }
        return result.toString();
    }
}

