/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.IConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.cics.core.connections.IConnectionsInfoProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractConnectionCustomizer
implements IConnectionCustomizer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<IConnectionCustomizerListener> listeners = new ArrayList<IConnectionCustomizerListener>();
    private IConnectionsInfoProvider connectionPreferencePage;

    public List<IConnectionCustomizerListener> getListeners() {
        return this.listeners;
    }

    public IConnectionsInfoProvider getConnectionPreferencePage() {
        return this.connectionPreferencePage;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public void addListener(IConnectionCustomizerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IConnectionCustomizerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setConnectionsInfoProvider(IConnectionsInfoProvider provider) {
        this.connectionPreferencePage = provider;
    }

    @Override
    public boolean performOk() {
        return true;
    }

    @Override
    public void setDirty(boolean isDirty) {
    }

    @Override
    public String validateEnteredData() {
        return null;
    }

    public String getDefaultValue(String extendedAttributeName) {
        IConnectionDescriptor.ExtendedAttribute attribute;
        IConnectionDescriptor descriptor = this.connectionPreferencePage.getCurrentDescriptor();
        if (descriptor != null && (attribute = descriptor.getExtendedAttribute(extendedAttributeName)) != null) {
            return attribute.getDefault();
        }
        return "";
    }
}

