/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.DebugEncrypter;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IPassphraseManager;
import com.ibm.cics.core.connections.ICredentialsManager;

public class PassphraseManager
implements IPassphraseManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PassphraseManager.class);
    private static DebugEncrypter debugEncrypter = new DebugEncrypter();
    private ICredentialsManager credentialsManager;
    private String trustPhrase = "changeit";
    private String keyPhrase = "changeit";
    private String pin = "changeit";

    public PassphraseManager(ICredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }

    public String getTrustStorePassphrase() {
        debug.enter("getTrustStorePassphrase");
        CredentialsConfiguration tscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.trustStorePassword");
        if (tscredential == null) {
            debug.event("getTrustStorePassphrase", debugEncrypter.encryptLogMessage("Node: javax.net.ssl.trustStorePassword does not exist. Setting password to default."));
            this.setTrustStorePassphrase("changeit");
            tscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.trustStorePassword");
        }
        if (tscredential != null) {
            this.trustPhrase = tscredential.getPassword();
        }
        if (this.trustPhrase == null || this.trustPhrase.equals("")) {
            debug.event("getTrustStorePassphrase", debugEncrypter.encryptLogMessage("Failed to read truststore password. Resetting password to the default value."));
            this.setTrustStorePassphrase("changeit");
            this.trustPhrase = "changeit";
        }
        debug.exit("getTrustStorePassphrase");
        return this.trustPhrase;
    }

    public String getKeyStorePassphrase() {
        debug.enter("getKeyStorePassphrase");
        CredentialsConfiguration kscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.keyStorePassword");
        if (kscredential == null) {
            debug.event("getKeyStorePassphrase", debugEncrypter.encryptLogMessage("Node: javax.net.ssl.keyStorePassword does not exist. Setting password to default."));
            this.setKeyStorePassphrase("changeit");
            kscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.keyStorePassword");
        }
        if (kscredential != null) {
            this.keyPhrase = kscredential.getPassword();
        }
        if (this.keyPhrase == null || this.keyPhrase.equals("")) {
            debug.event("getKeyStorePassphrase", debugEncrypter.encryptLogMessage("Failed to read keystore password. Resetting password to the default value."));
            this.setKeyStorePassphrase("changeit");
            this.keyPhrase = "changeit";
        }
        debug.exit("getKeyStorePassphrase");
        return this.keyPhrase;
    }

    public String getSmartcardPIN() {
        debug.enter("getSmartcardPIN");
        CredentialsConfiguration kscredential = this.credentialsManager.findCredentialsConfigurationByID("com.ibm.cics.core.comm.smartcardPIN");
        if (kscredential == null) {
            debug.event("getSmartcardPIN", debugEncrypter.encryptLogMessage("Node: com.ibm.cics.core.comm.smartcardPIN does not exist. Setting password to default."));
            this.setKeyStorePassphrase("changeit");
            kscredential = this.credentialsManager.findCredentialsConfigurationByID("com.ibm.cics.core.comm.smartcardPIN");
        }
        if (kscredential != null) {
            this.keyPhrase = kscredential.getPassword();
        }
        if (this.keyPhrase == null || this.keyPhrase.equals("")) {
            debug.event("getSmartcardPIN", debugEncrypter.encryptLogMessage("Failed to read smartcard PIN. Resetting password to the default value."));
            this.setKeyStorePassphrase("changeit");
            this.keyPhrase = "changeit";
        }
        debug.exit("getSmartcardPIN");
        return this.keyPhrase;
    }

    public void setTrustStorePassphrase(String phrase) {
        debug.enter("setTrustStorePassphrase");
        this.trustPhrase = phrase;
        CredentialsConfiguration tscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.trustStorePassword");
        if (tscredential == null) {
            tscredential = new CredentialsConfiguration("javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStorePassword", phrase, true);
        } else {
            tscredential.setPassword(phrase);
        }
        this.credentialsManager.update(tscredential);
        debug.exit("setTrustStorePassphrase");
    }

    public void setKeyStorePassphrase(String phrase) {
        debug.enter("setKeyStorePassphrase");
        this.keyPhrase = phrase;
        CredentialsConfiguration kscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.keyStorePassword");
        if (kscredential == null) {
            kscredential = new CredentialsConfiguration("javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStorePassword", phrase, true);
        } else {
            kscredential.setPassword(phrase);
        }
        this.credentialsManager.update(kscredential);
        debug.exit("setKeyStorePassphrase");
    }

    public void setSmartcardPin(String phrase) {
        debug.enter("setSmartcardPin");
        this.pin = phrase;
        CredentialsConfiguration sccredential = this.credentialsManager.findCredentialsConfigurationByID("com.ibm.cics.core.comm.smartcardPIN");
        if (sccredential == null) {
            sccredential = new CredentialsConfiguration("com.ibm.cics.core.comm.smartcardPIN", "com.ibm.cics.core.comm.smartcardPIN", "com.ibm.cics.core.comm.smartcardPIN", phrase, true);
        } else {
            sccredential.setPassword(phrase);
        }
        this.credentialsManager.update(sccredential);
        debug.exit("setSmartcardPin");
    }
}

