/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.internal.CachingConnectionProvider;
import com.ibm.cics.core.connections.internal.FileConnectionXMLDeserializer;
import com.ibm.cics.core.connections.internal.FileConnectionXMLSerializer;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.IConnectionSerializer;
import com.ibm.cics.core.connections.internal.ILocationConnectionProvider;
import com.ibm.cics.core.connections.internal.URLConnectionXMLDeserializer;
import java.net.URL;
import org.eclipse.core.runtime.IPath;

public class URLConnectionProvider
extends CachingConnectionProvider
implements ILocationConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private URL url;

    private URLConnectionProvider(String id, String description, URL url, IConnectionDeserializer cacheDeserializer, IConnectionSerializer cacheSerializer, ConnectionRegistry registry) {
        super(id, description, new URLConnectionXMLDeserializer(url), cacheDeserializer, cacheSerializer, registry);
        this.url = url;
    }

    public static URLConnectionProvider create(String id, URL url, IPath cacheLocation) {
        FileConnectionXMLDeserializer cacheDeserializer = new FileConnectionXMLDeserializer(cacheLocation);
        FileConnectionXMLSerializer cacheSerializer = new FileConnectionXMLSerializer(cacheLocation);
        String description = "URL=" + url;
        return new URLConnectionProvider(id, description, url, (IConnectionDeserializer)cacheDeserializer, (IConnectionSerializer)cacheSerializer, ConnectionRegistry.getConnectionRegistry());
    }

    @Override
    public String getLocation() {
        return this.url.toString();
    }
}

