/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.internal.BadLocationException;
import com.ibm.cics.core.connections.internal.ConnectionParameterImporter;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.FileConnectionXMLDeserializer;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.ILocationConnectionProvider;
import com.ibm.cics.core.connections.internal.URLConnectionXMLDeserializer;
import com.ibm.cics.core.connections.internal.WritableConnectionProvider;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddProviderDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionProviderRegistry connectionProviderRegistry;
    private ILocationConnectionProvider connectionProvider;
    Text locationText;
    Button importButton;
    Button loadButton;
    private ProgressMonitorPart progressMonitorPart;
    private Button browseFileButton;

    public AddProviderDialog(Shell parentShell) {
        this(parentShell, ConnectionProviderRegistry.getDefault());
    }

    public AddProviderDialog(Shell parentShell, ConnectionProviderRegistry connectionProviderRegistry) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.connectionProviderRegistry = connectionProviderRegistry;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddProviderDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.connectionProvider == null) {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AddProviderDialog_Title);
        this.setMessage(Messages.AddProviderDialog_Message);
        this.setTitleImage(ConnectionsImages.getImage("CONNECTIONS_IMPORT_WIZ_BAN"));
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        c.setLayout((Layout)gridLayout);
        c.setLayoutData((Object)new GridData(1808));
        c.setFont(parent.getFont());
        Label titleBarSeparator = new Label(c, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(4, 4, true, false);
        childArea.setLayoutData((Object)data);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginTop = 10;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        childArea.setLayout((Layout)gridLayout);
        this.createFileControls(childArea);
        this.loadButton = new Button(childArea, 16);
        this.loadButton.setText(Messages.AddProviderDialog_Dynamic_import_lbl);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 3;
        this.loadButton.setLayoutData((Object)data);
        this.loadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddProviderDialog.this.validateInterface();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label l = new Label(childArea, 64);
        l.setText(Messages.AddProviderDialog_DynamicImport_dsc);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 3;
        data.widthHint = 400;
        data.horizontalIndent = 10;
        l.setLayoutData((Object)data);
        this.importButton = new Button(childArea, 16);
        this.importButton.setText(Messages.AddProviderDialog_Static_import_lbl);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 3;
        this.importButton.setLayoutData((Object)data);
        l = new Label(childArea, 64);
        l.setText(Messages.AddProviderDialog_StaticImport_dsc);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 3;
        data.widthHint = 400;
        data.horizontalIndent = 10;
        l.setLayoutData((Object)data);
        if (this.connectionProvider != null) {
            this.importButton.setEnabled(false);
        }
        if (this.connectionProvider != null) {
            this.locationText.setText(this.connectionProvider.getLocation().toString());
            this.setTitle(Messages.AddProviderDialog_Edit_Title);
        } else {
            this.setTitle(Messages.AddProviderDialog_Add_Title);
        }
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddProviderDialog.this.validateInterface();
            }
        });
        if (this.loadButton != null) {
            this.loadButton.setSelection(true);
        }
        this.progressMonitorPart = new ProgressMonitorPart(childArea, null);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        this.progressMonitorPart.setLayoutData((Object)data);
        this.progressMonitorPart.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_import_dialog");
        c.pack();
        return c;
    }

    void validateInterface() {
        boolean validText = false;
        this.setErrorMessage(null);
        if (StringUtil.hasContent((String)this.locationText.getText())) {
            if (this.loadButton.getSelection()) {
                validText = true;
                for (IConnectionProvider provider : this.connectionProviderRegistry.getConnectionProviders()) {
                    if (!(provider instanceof ILocationConnectionProvider)) continue;
                    try {
                        String normalisedLocationText = new File(new Path(this.locationText.getText()).toOSString()).getCanonicalPath();
                        if (!normalisedLocationText.equals(new File(((ILocationConnectionProvider)provider).getLocation()).getCanonicalPath())) continue;
                        validText = false;
                        this.setErrorMessage(Messages.AddProviderDialog_file_already_registered);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                validText = true;
            }
        }
        if (validText && !Messages.AddProviderDialog_Message.equals(this.getMessage())) {
            this.setMessage(Messages.AddProviderDialog_Message);
        }
        this.getButton(0).setEnabled(validText);
    }

    private void createFileControls(Composite childArea) {
        Label l = new Label(childArea, 0);
        l.setText(Messages.AddProviderDialog_Location_lbl);
        GridData data = new GridData(4, 0x1000000, false, false);
        l.setLayoutData((Object)data);
        this.locationText = new Text(childArea, 2048);
        TextInput.setAccessibleLabel((Text)this.locationText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)data);
        this.locationText.setFocus();
        this.browseFileButton = new Button(childArea, 8);
        this.browseFileButton.setText(Messages.AddProviderDialog_Browse_btn);
        data = new GridData(4, 0x1000000, false, false);
        this.browseFileButton.setLayoutData((Object)data);
        this.createStyledExample(childArea, Messages.AddProviderDialog_How_to_enter_File_URL_msg, Messages.AddProviderDialog_How_to_enter_File_URL_example);
        this.createStyledExample(childArea, Messages.AddProviderDialog_How_to_enter_HTTP_URL_msg, Messages.AddProviderDialog_How_to_enter_HTTP_URL_example);
        this.browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(AddProviderDialog.this.getShell(), 0);
                fileDialog.setFilterExtensions(new String[]{"*.pref", "*.*"});
                fileDialog.setFileName(AddProviderDialog.this.locationText.getText());
                String fileName = fileDialog.open();
                if (fileName != null) {
                    AddProviderDialog.this.locationText.setText(fileName);
                }
            }
        });
    }

    private void createStyledExample(Composite childArea, String label, String example) {
        new Label(childArea, 0);
        StyledText styledText = new StyledText(childArea, 8);
        styledText.setBackground(childArea.getBackground());
        styledText.setText(String.valueOf(label) + " " + example);
        StyleRange style1 = new StyleRange();
        style1.start = label.length() + 1;
        style1.length = example.length();
        style1.fontStyle = 1;
        styledText.setStyleRange(style1);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 2;
        data.widthHint = 200;
        styledText.setLayoutData((Object)data);
    }

    protected void buttonPressed(int buttonId) {
        block17: {
            if (buttonId == 0) {
                if (this.connectionProvider != null) {
                    this.connectionProviderRegistry.removeConnectionProvider(this.connectionProvider);
                }
                if (this.loadButton != null && this.loadButton.getSelection()) {
                    try {
                        try {
                            this.setControlsEnabled(false);
                            this.connectionProviderRegistry.addConnectionProvider(this.locationText.getText());
                        }
                        catch (BadLocationException ex) {
                            this.setErrorMessage(NLS.bind((String)Messages.AddProviderDialog_providerCreationFailed, (Object)ex.getLocalizedMessage()));
                            this.setControlsEnabled(true);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.setControlsEnabled(true);
                        throw throwable;
                    }
                    this.setControlsEnabled(true);
                } else if (this.importButton == null || this.importButton.getSelection()) {
                    if (this.locationText.getText().startsWith("http://")) {
                        try {
                            URLConnectionXMLDeserializer reader = new URLConnectionXMLDeserializer(new URL(this.locationText.getText()));
                            this.importConnections(reader);
                        }
                        catch (MalformedURLException ex) {
                            this.setImportFailedMessage(ex);
                            return;
                        }
                        catch (IOException e) {
                            this.setImportFailedMessage(e);
                        }
                    } else {
                        FileConnectionXMLDeserializer reader = new FileConnectionXMLDeserializer((IPath)new Path(this.locationText.getText()));
                        try {
                            this.importConnections(reader);
                        }
                        catch (IOException e) {
                            this.setImportFailedMessage(e);
                            return;
                        }
                    }
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    private void importConnections(IConnectionDeserializer reader) throws IOException {
        try {
            this.setControlsEnabled(false);
            WritableConnectionProvider localConnectionProvider = this.connectionProviderRegistry.getLocalConnectionProvider();
            new ConnectionParameterImporter(ConnectionRegistry.getConnectionRegistry(), localConnectionProvider).importConnections(reader, true);
        }
        finally {
            this.setControlsEnabled(true);
        }
    }

    public void setImportFailedMessage(Exception e) {
        this.setErrorMessage(String.valueOf(Messages.Connection_import_failed_msg) + " " + e.getLocalizedMessage());
    }

    private void setControlsEnabled(boolean controlsEnabled) {
        this.locationText.setEnabled(controlsEnabled);
        this.importButton.setEnabled(controlsEnabled);
        this.loadButton.setEnabled(controlsEnabled);
        this.browseFileButton.setEnabled(controlsEnabled);
        this.getButton(0).setEnabled(controlsEnabled);
    }

    public void setConnectionProvider(ILocationConnectionProvider aConnectionProvider) {
        this.connectionProvider = aConnectionProvider;
    }

    protected Button getButton(int button) {
        return super.getButton(button);
    }
}

