/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConnectionsContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<IConnectionCategory, List<IConnectionDescriptor>> categoriesToDescriptors;
    private Map<IConnectionProvider, Map<IConnectionDescriptor, List<ConnectionProfile>>> providersToDescriptorsToProfiles;
    private boolean showProviders;
    private Viewer viewer;
    private IConnectionManager connectionManager;
    private List<IConnectionDescriptor> connectionDescriptors;
    private IConnectionProviderRegistry registry;

    public ConnectionsContentProvider(FilteredConnectionRegistry connectionRegistry, IConnectionProviderRegistry registry) {
        this.connectionDescriptors = Arrays.asList(connectionRegistry.getConnections());
        this.registry = registry;
        List<List<IConnectionDescriptor>> descriptorsGroupedByCategory = CollectionUtils.groupBy(this.connectionDescriptors, new Function<IConnectionDescriptor, IConnectionCategory>(){

            @Override
            public IConnectionCategory evaluate(IConnectionDescriptor v) {
                return v.getCategory();
            }
        });
        this.categoriesToDescriptors = CollectionUtils.map(descriptorsGroupedByCategory, new Function<List<IConnectionDescriptor>, IConnectionCategory>(){

            @Override
            public IConnectionCategory evaluate(List<IConnectionDescriptor> v) {
                return v.get(0).getCategory();
            }
        });
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (newInput != null) {
            this.connectionManager = (IConnectionManager)newInput;
            this.setConnectionConfigurations(this.connectionManager);
        }
    }

    private void setConnectionConfigurations(IConnectionManager newInput) {
        Object[] providers;
        List<ConnectionProfile> filteredConnections = CollectionUtils.filter(newInput.getConnectionProfiles(), new Function<ConnectionProfile, Boolean>(){

            @Override
            public Boolean evaluate(ConnectionProfile profile) {
                return ConnectionsContentProvider.this.connectionDescriptors.contains(profile.getConnectionDescriptor());
            }
        });
        List<List<ConnectionProfile>> profilesByProvider = CollectionUtils.groupBy(filteredConnections, new Function<ConnectionProfile, IConnectionProvider>(){

            @Override
            public IConnectionProvider evaluate(ConnectionProfile v) {
                return v.getConnectionProvider();
            }
        });
        List<Map<IConnectionDescriptor, List<ConnectionProfile>>> connectionProvidersMappedByConnectionDescriptor = CollectionUtils.transform(profilesByProvider, new Function<List<ConnectionProfile>, Map<IConnectionDescriptor, List<ConnectionProfile>>>(){

            @Override
            public Map<IConnectionDescriptor, List<ConnectionProfile>> evaluate(List<ConnectionProfile> v) {
                List<List<ConnectionProfile>> listOfConnectionsByDescriptor = CollectionUtils.groupBy(v, new Function<ConnectionProfile, IConnectionDescriptor>(){

                    @Override
                    public IConnectionDescriptor evaluate(ConnectionProfile v) {
                        return v.getConnectionDescriptor();
                    }
                });
                Map<IConnectionDescriptor, List<ConnectionProfile>> connectionsPerProvider = CollectionUtils.map(listOfConnectionsByDescriptor, new Function<List<ConnectionProfile>, IConnectionDescriptor>(){

                    @Override
                    public IConnectionDescriptor evaluate(List<ConnectionProfile> v) {
                        return v.get(0).getConnectionDescriptor();
                    }
                });
                return connectionsPerProvider;
            }
        });
        this.providersToDescriptorsToProfiles = CollectionUtils.map(connectionProvidersMappedByConnectionDescriptor, new Function<Map<IConnectionDescriptor, List<ConnectionProfile>>, IConnectionProvider>(){

            @Override
            public IConnectionProvider evaluate(Map<IConnectionDescriptor, List<ConnectionProfile>> v) {
                return v.values().iterator().next().get(0).getConnectionProvider();
            }
        });
        Object[] objectArray = providers = this.registry.getConnectionProviders().toArray();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IConnectionProvider provider = (IConnectionProvider)object;
            if (!this.providersToDescriptorsToProfiles.containsKey(provider)) {
                this.providersToDescriptorsToProfiles.put(provider, new HashMap());
            }
            ++n2;
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConnectionManager) {
            if (this.showProviders) {
                return this.providersToDescriptorsToProfiles.keySet().toArray();
            }
            return this.categoriesToDescriptors.keySet().toArray();
        }
        if (parentElement instanceof IConnectionCategory) {
            Collection descriptors = this.categoriesToDescriptors.get((IConnectionCategory)parentElement);
            if (descriptors == null) {
                return new Object[0];
            }
            if (descriptors.size() == 1) {
                return this.getConnectionsForDescriptor((IConnectionDescriptor)descriptors.iterator().next());
            }
            return this.filteredDescriptors(descriptors.toArray());
        }
        if (parentElement instanceof IConnectionDescriptor) {
            return this.getConnectionsForDescriptor((IConnectionDescriptor)parentElement);
        }
        if (parentElement instanceof IConnectionProvider) {
            final IConnectionProvider provider = (IConnectionProvider)parentElement;
            Map<IConnectionDescriptor, List<ConnectionProfile>> providerDescriptors = this.providersToDescriptorsToProfiles.get(provider);
            if (providerDescriptors != null) {
                Set<IConnectionDescriptor> descriptors = providerDescriptors.keySet();
                return CollectionUtils.transform(descriptors, new Function<IConnectionDescriptor, ConnectionProviderDescriptorNode>(){

                    @Override
                    public ConnectionProviderDescriptorNode evaluate(IConnectionDescriptor v) {
                        return new ConnectionProviderDescriptorNode(v, provider);
                    }
                }).toArray();
            }
            return new Object[0];
        }
        if (parentElement instanceof ConnectionProviderDescriptorNode) {
            List<ConnectionProfile> connectionProfiles = ((ConnectionProviderDescriptorNode)parentElement).getConnectionProfiles();
            if (connectionProfiles == null) {
                return new Object[0];
            }
            return connectionProfiles.toArray();
        }
        return new Object[0];
    }

    protected Object[] filteredDescriptors(Object[] array) {
        return array;
    }

    private Object[] getConnectionsForDescriptor(IConnectionDescriptor descriptor) {
        ArrayList<ConnectionProfile> connectionsForDescriptor = new ArrayList<ConnectionProfile>();
        for (Map<IConnectionDescriptor, List<ConnectionProfile>> map : this.providersToDescriptorsToProfiles.values()) {
            List<ConnectionProfile> profilesForDescriptor = map.get(descriptor);
            if (profilesForDescriptor == null) continue;
            connectionsForDescriptor.addAll(profilesForDescriptor);
        }
        return connectionsForDescriptor.toArray();
    }

    public Object getParent(Object element) {
        if (this.showProviders) {
            ConnectionProfile profile;
            if (element instanceof IConnectionProvider) {
                return this.connectionManager;
            }
            if (element instanceof ConnectionProviderDescriptorNode) {
                return ((ConnectionProviderDescriptorNode)element).getConnectionProvider();
            }
            if (element instanceof ConnectionProfile && this.providersToDescriptorsToProfiles.containsKey((profile = (ConnectionProfile)element).getConnectionProvider())) {
                return new ConnectionProviderDescriptorNode(profile.getConnectionDescriptor(), profile.getConnectionProvider());
            }
        } else {
            if (element instanceof IConnectionCategory) {
                return this.connectionManager;
            }
            if (element instanceof IConnectionDescriptor) {
                return ((IConnectionDescriptor)element).getCategory();
            }
            if (element instanceof ConnectionProfile) {
                IConnectionDescriptor connectionDescriptor = ((ConnectionProfile)element).getConnectionDescriptor();
                IConnectionCategory category = connectionDescriptor.getCategory();
                List<IConnectionDescriptor> descriptors = this.categoriesToDescriptors.get(category);
                if (descriptors == null) {
                    return null;
                }
                if (descriptors.size() == 1) {
                    return category;
                }
                return connectionDescriptor;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void setShowProviders(boolean showProviders) {
        this.showProviders = showProviders;
        this.viewer.refresh();
    }

    public ConnectionProviderDescriptorNode getConnectionProviderDescriptorNode(IConnectionProvider provider, IConnectionDescriptor connectionDescriptor) {
        return new ConnectionProviderDescriptorNode(connectionDescriptor, provider);
    }

    public class ConnectionProviderDescriptorNode {
        private IConnectionDescriptor connectionDescriptor;
        private IConnectionProvider connectionProvider;

        public ConnectionProviderDescriptorNode(IConnectionDescriptor aConnectionDescriptor, IConnectionProvider aConnectionProvider) {
            this.connectionDescriptor = aConnectionDescriptor;
            this.connectionProvider = aConnectionProvider;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.connectionDescriptor == null ? 0 : this.connectionDescriptor.hashCode());
            result = 31 * result + (this.connectionProvider == null ? 0 : this.connectionProvider.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionProviderDescriptorNode other = (ConnectionProviderDescriptorNode)obj;
            if (this.connectionDescriptor == null ? other.connectionDescriptor != null : !this.connectionDescriptor.equals(other.connectionDescriptor)) {
                return false;
            }
            return !(this.connectionProvider == null ? other.connectionProvider != null : !this.connectionProvider.equals(other.connectionProvider));
        }

        public List<ConnectionProfile> getConnectionProfiles() {
            return (List)((Map)ConnectionsContentProvider.this.providersToDescriptorsToProfiles.get(this.connectionProvider)).get(this.connectionDescriptor);
        }

        public String toString() {
            return this.connectionDescriptor.getName();
        }

        public IConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        public IConnectionDescriptor getConnectionDescriptor() {
            return this.connectionDescriptor;
        }
    }
}

