/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.internal.ConnectionCredentialsManager;
import com.ibm.cics.core.connections.internal.views.Messages;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class UpdateCredentialsOperation
extends AbstractOperation {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CredentialsConfiguration credentials;
    private Collection<ConnectionProfile> configurations;
    private ConnectionCredentialsManager connectionCredentialsManager;

    public UpdateCredentialsOperation(Collection<ConnectionProfile> configurations, CredentialsConfiguration credentials, ConnectionCredentialsManager connectionCredentialsManager) {
        super(NLS.bind((String)Messages.UpdateCredentialsOperation_changeCredentials, (Object)credentials.getName()));
        this.credentials = credentials;
        this.configurations = configurations;
        this.connectionCredentialsManager = connectionCredentialsManager;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (ConnectionProfile aConfiguration : this.configurations) {
            this.connectionCredentialsManager.associate(aConfiguration.getId(), this.credentials.getID());
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (ConnectionProfile configuration : this.configurations) {
            this.connectionCredentialsManager.associate(configuration.getId(), configuration.getCredentials() != null ? configuration.getCredentials().getID() : null);
        }
        return Status.OK_STATUS;
    }
}

