/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.connections.internal.IConnectionParameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionParameters
implements IConnectionParameters {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Map<String, String> attributes;
    private final String connectionTypeId;
    private final String id;
    private final String name;

    public ConnectionParameters(String id, String name, String connectionTypeId, AttributeValue ... avs) {
        this(id, name, connectionTypeId, AttributeValue.mapify(Arrays.asList(avs)));
    }

    public String toString() {
        return "ConnectionParameters [\n\tattributes=" + this.attributes + ",\n\tconnectionTypeId=" + this.connectionTypeId + ",\n\tid=" + this.id + ",\n\tname=" + this.name + "\n]";
    }

    public ConnectionParameters(String id, String name, String connectionTypeId, Map<String, String> avs) {
        this.id = id;
        this.connectionTypeId = connectionTypeId;
        this.name = name;
        HashMap<String, String> attributes = new HashMap<String, String>(avs);
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ConnectionParameters setId(String id) {
        return new ConnectionParameters(id, this.name, this.connectionTypeId, this.attributes);
    }

    public String getConnectionTypeId() {
        return this.connectionTypeId;
    }

    @Override
    public String getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public ConnectionParameters setAttribute(String attribute, String value) {
        HashMap<String, String> newAttributes = new HashMap<String, String>(this.attributes);
        newAttributes.put(attribute, value);
        return this.setAttributes(newAttributes);
    }

    public ConnectionParameters setAttributes(Map<String, String> attributes) {
        HashMap<String, String> newAttributes = new HashMap<String, String>(attributes);
        newAttributes.putAll(attributes);
        return new ConnectionParameters(this.id, this.name, this.connectionTypeId, newAttributes);
    }

    public ConnectionParameters setAttributes(AttributeValue ... avs) {
        return this.setAttributes(AttributeValue.mapify(Arrays.asList(avs)));
    }

    public static AttributeValue av(String attribute, String value) {
        return new AttributeValue(attribute, value);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.connectionTypeId == null ? 0 : this.connectionTypeId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionParameters other = (ConnectionParameters)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.connectionTypeId == null ? other.connectionTypeId != null : !this.connectionTypeId.equals(other.connectionTypeId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public ConnectionParameters setName(String name) {
        return new ConnectionParameters(this.id, name, this.connectionTypeId, this.attributes);
    }

    public static class AttributeValue {
        public String attribute;
        public String value;

        private AttributeValue(String attribute, String value) {
            this.attribute = attribute;
            this.value = value;
        }

        public static Map<String, String> mapify(List<AttributeValue> avs) {
            HashMap<String, String> avsMap = new HashMap<String, String>();
            for (AttributeValue av : avs) {
                avsMap.put(av.attribute, av.value);
            }
            return avsMap;
        }
    }
}

