/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionStateViewer;
import com.ibm.cics.core.connections.internal.DebugOptions;
import com.ibm.cics.core.connections.internal.IConnectionStatusController;
import com.ibm.cics.core.connections.internal.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ConnectionStatus
extends Composite
implements IConnectionStateViewer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Debug debug = new Debug(this.getClass());
    ToolBar toolBar;
    ToolItem imageToolItem;
    private Menu connectionsMenu;
    private Point toolBarSize;
    Hyperlink serverLabel;
    IConnectionStatusController controller;
    private int serverLabelMinimumWidth;
    private String connectionCategory;

    public ConnectionStatus(Composite parent, int style, IConnectionStatusController aController) {
        super(parent, style);
        assert (aController != null);
        this.controller = aController;
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.imageToolItem = new ToolItem(this.toolBar, 0x800004);
        this.imageToolItem.setImage(ConnectionsImages.getImage("IN_ACTIVE_CONNECTION"));
        this.connectionsMenu = new Menu((Decorations)this.getShell(), 8);
        this.toolBarSize = this.toolBar.computeSize(-1, -1);
        this.toolBar.setSize(this.toolBarSize);
        this.imageToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    ConnectionStatus.this.controller.fillConnectionsMenu(ConnectionStatus.this.connectionsMenu);
                    Point pt = ConnectionStatus.this.toolBar.toDisplay(event.x, 0);
                    ConnectionStatus.this.connectionsMenu.setLocation(pt);
                    ConnectionStatus.this.connectionsMenu.setVisible(true);
                } else {
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        ConnectionStatus.this.controller.toggleSelectionState();
                    }
                }
            }
        });
        this.serverLabel = new Hyperlink((Composite)this, 0);
        this.serverLabel.setText("                                         ");
        this.serverLabelMinimumWidth = this.serverLabel.computeSize((int)-1, (int)-1).x;
        this.serverLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String configurationId = (String)ConnectionStatus.this.serverLabel.getData(String.class.getName());
                if (configurationId != null) {
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionParameters(configurationId);
                } else {
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionCategory(ConnectionStatus.this.connectionCategory);
                }
            }
        });
        this.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point preferredSize = new Point(0, 0);
                Point toolBarSize = ConnectionStatus.this.toolBar.computeSize(wHint, hHint);
                preferredSize.x = toolBarSize.x;
                preferredSize.y = toolBarSize.y;
                Point hyperlinkSize = ConnectionStatus.this.serverLabel.computeSize(wHint, hHint);
                int minX = Math.max(hyperlinkSize.x, ConnectionStatus.this.serverLabelMinimumWidth);
                preferredSize.x += minX;
                return preferredSize;
            }

            protected void layout(Composite composite, boolean flushCache) {
                Point toolBarPreferredSize = ConnectionStatus.this.toolBar.computeSize(-1, -1);
                Point serverLabelPreferredSize = ConnectionStatus.this.serverLabel.computeSize(-1, -1);
                int minX = Math.max(serverLabelPreferredSize.x, ConnectionStatus.this.serverLabelMinimumWidth);
                ConnectionStatus.this.toolBar.setSize(toolBarPreferredSize);
                int y = (ConnectionStatus.this.computeSize((int)-1, (int)-1).y - serverLabelPreferredSize.y) / 2;
                ConnectionStatus.this.serverLabel.setLocation(toolBarPreferredSize.x, y);
                Point newServerLabelSize = new Point(serverLabelPreferredSize.x, minX);
                ConnectionStatus.this.serverLabel.setSize(newServerLabelSize);
            }
        });
        if (DebugOptions.DEBUG_CONNECTION) {
            this.debug.event("<init>", (Object)this);
        }
    }

    private void setText(String text) {
        if (!this.serverLabel.isDisposed()) {
            this.serverLabel.setText(text);
        }
    }

    private void setConnectionConfiguration(String configurationId) {
        if (!this.serverLabel.isDisposed()) {
            this.serverLabel.setData(String.class.getName(), (Object)configurationId);
        }
    }

    public void setToolTipText(String text) {
        if (!this.isDisposed()) {
            this.serverLabel.setToolTipText(text);
        }
    }

    @Override
    public void showState(final IConnectionState state) {
        if (!this.isDisposed()) {
            (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).syncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionStatus.this.setText(state.getName());
                    ConnectionStatus.this.setToolTipText(state.getMessage());
                    if (state.getID() == null || ConnectionStatus.this.connectionCategory == null) {
                        ConnectionStatus.this.setConnectionConfiguration(null);
                    } else {
                        String configurationId = state.getID();
                        ConnectionStatus.this.setConnectionConfiguration(configurationId);
                    }
                    ConnectionStatus.this.imageToolItem.setImage(state.getImage());
                    ConnectionStatus.this.imageToolItem.setToolTipText(state.getMenuMessage());
                    ConnectionStatus.this.layout(true);
                    ConnectionStatus.this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                        public void getName(AccessibleEvent e) {
                            e.result = Messages.bind((String)Messages.ConnectionStatus_connectionStatusLabel, (Object)state.getMessage());
                        }
                    });
                    ConnectionStatus.this.toolBar.getAccessible().setFocus(-1);
                }
            });
        }
    }

    @Override
    public void setConnectionCategory(String connectionCategory) {
        this.connectionCategory = connectionCategory;
    }
}

