/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionFactoryProvider;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionUserInterfaceService;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ChangePasswordDialog;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.CredentialsDialog;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.EditConnectionDialog;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.NoConnection;
import com.ibm.cics.core.connections.internal.views.ConnectionRequiredDialog;
import com.ibm.cics.core.connections.internal.views.HostConnectionsView;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ConnectionUserInterfaceService
implements IConnectionUserInterfaceService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static SelectionAdapter connectionMenuItemSelectionListener;
    private ConnectionManager connectionManager;
    private Debug debug = new Debug(ConnectionUserInterfaceService.class);

    public ConnectionUserInterfaceService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void editConnectionParameters(String configurationId) {
        if (configurationId == null) {
            this.manageConnections();
        } else {
            ConnectionProfile configuration = this.connectionManager.getConnectionProfile(configurationId);
            IConnectionState state = ConnectionsPlugin.getDefault().getConnectionService().getConnectionState(configuration);
            if (configuration != null) {
                IConnectionProvider connectionProvider = ConnectionProviderRegistry.getDefault().getConnectionProvider(configuration.getConnectionDescriptor());
                if (connectionProvider instanceof IConnectionFactoryProvider) {
                    ((IConnectionFactoryProvider)connectionProvider).editConnection(configuration);
                    return;
                }
                EditConnectionDialog connectionDialog = EditConnectionDialog.editExisting(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), configuration, state instanceof ConnectedState);
                connectionDialog.open();
            } else {
                this.manageConnections();
            }
        }
    }

    @Override
    public ConnectionParameters createConnectionConfiguration(String ... connectionDescriptorIds) {
        final FilteredConnectionRegistry filteredConnectionRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());
        List<IConnectionDescriptor> connectionDescriptors = CollectionUtils.transform(Arrays.asList(connectionDescriptorIds), new Function<String, IConnectionDescriptor>(){

            @Override
            public IConnectionDescriptor evaluate(String v) {
                return filteredConnectionRegistry.find(v);
            }
        });
        if ((connectionDescriptors = CollectionUtils.filter(connectionDescriptors, new Function<IConnectionDescriptor, Boolean>(){

            @Override
            public Boolean evaluate(IConnectionDescriptor v) {
                if (v != null) {
                    return true;
                }
                return false;
            }
        })).size() == 1) {
            IConnectionDescriptor descriptor = filteredConnectionRegistry.find(connectionDescriptorIds[0]);
            IConnectionProvider connectionProvider = ConnectionProviderRegistry.getDefault().getConnectionProvider(descriptor);
            if (connectionProvider instanceof IConnectionFactoryProvider) {
                ((IConnectionFactoryProvider)connectionProvider).createConnection(descriptor);
                return null;
            }
            EditConnectionDialog connectionDialog = EditConnectionDialog.createNew(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), descriptor);
            int open = connectionDialog.open();
            if (open == 0) {
                return connectionDialog.getConnectionConfiguration();
            }
            return null;
        }
        if (connectionDescriptors.size() == 0) {
            connectionDescriptors = Arrays.asList(filteredConnectionRegistry.getConnections());
        }
        ConnectionParameters[] configuration = new ConnectionParameters[1];
        this.selectAndCreateConnectionConfiguration(configuration, connectionDescriptors);
        return configuration[0];
    }

    private void selectAndCreateConnectionConfiguration(ConnectionParameters[] configuration, List<IConnectionDescriptor> descriptorsList) {
        Display display = Display.getDefault();
        Shell activeShell = display.getActiveShell();
        Menu menu = new Menu((Decorations)activeShell, 8);
        TreeSet<IConnectionDescriptor> descriptors = new TreeSet<IConnectionDescriptor>(new Comparator<IConnectionDescriptor>(){

            @Override
            public int compare(IConnectionDescriptor object1, IConnectionDescriptor object2) {
                return object1.getName().compareTo(object2.getName());
            }
        });
        descriptors.addAll(descriptorsList);
        for (IConnectionDescriptor aConnectionDescriptor : descriptors) {
            MenuItem menuItem = new MenuItem(menu, 0);
            menuItem.setText(aConnectionDescriptor.getName());
            menuItem.setData((Object)aConnectionDescriptor);
            menuItem.addSelectionListener(this.getCreateConnectionMenuItemSelectionListener(configuration));
            menuItem.setImage(ConnectionsImages.getCreateConnectionImage(aConnectionDescriptor.getCategory()));
        }
        activeShell.setMenu(menu);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private SelectionListener getCreateConnectionMenuItemSelectionListener(final ConnectionParameters[] configuration) {
        if (connectionMenuItemSelectionListener == null) {
            connectionMenuItemSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem selectedMenuItem = (MenuItem)e.widget;
                    IConnectionDescriptor selectedConnectionDescriptor = (IConnectionDescriptor)selectedMenuItem.getData();
                    configuration[0] = ConnectionUserInterfaceService.this.createConnectionConfiguration(selectedConnectionDescriptor.getId());
                }
            };
        }
        return connectionMenuItemSelectionListener;
    }

    @Override
    public void editConnectionCategory(String connectionCategory) {
        IConnectionState state = ConnectionsPlugin.getDefault().getConnectionService().getConnectionState(connectionCategory);
        if (state != null && !(state instanceof NoConnection)) {
            ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionParameters(state.getID());
        } else {
            try {
                HostConnectionsView connectionsviewPart = (HostConnectionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(HostConnectionsView.ID);
                connectionsviewPart.setFocus();
            }
            catch (PartInitException e) {
                this.debug.error("editConnectionCategory", (Throwable)e);
            }
        }
    }

    @Override
    public void manageConnections() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(HostConnectionsView.ID);
        }
        catch (PartInitException e) {
            this.debug.error("manageConnections", (Throwable)e);
        }
    }

    @Override
    public void editCredentialsConfiguration(CredentialsConfiguration credentialsConfiguration) {
        if (credentialsConfiguration == null) {
            this.manageConnections();
        } else {
            CredentialsDialog credentialDialog = new CredentialsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), credentialsConfiguration);
            credentialDialog.open();
        }
    }

    @Override
    public void createCredentialsConfiguration() {
        CredentialsDialog credentialDialog = new CredentialsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CredentialsMode.CREATE_NEW_CREDENTIAL);
        String userName = IDFactory.getUserid8().toUpperCase(Locale.getDefault());
        String newCredentialsName = ConnectionUtils.createNewNameAgainst(userName);
        credentialDialog.setInitialCreateDetails(userName, newCredentialsName);
        credentialDialog.open();
    }

    @Override
    public Control createConnectionWidget(Composite parent, String connectionCategoryId, boolean isInDialogMode) {
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        final ConnectionWidgetManager connectionWidgetManager = new ConnectionWidgetManager(connectionService, isInDialogMode);
        ConnectionStatus connectionStatus = new ConnectionStatus(parent, 0, connectionWidgetManager.getConnectionStatusController());
        connectionWidgetManager.setConnectionStateViewer(connectionStatus);
        connectionWidgetManager.setCurrentCategory(connectionCategoryId);
        connectionStatus.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                connectionWidgetManager.dispose();
            }
        });
        return connectionStatus;
    }

    @Override
    public void displayChangePasswordDialog(String credentialsID, IRunnableWithProgress changePasswordRunnable) {
        ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
        CredentialsConfiguration credentialsConfiguration = credentialsManager.findCredentialsConfigurationByID(credentialsID);
        ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        changePasswordDialog.setCredentialsConfiguration(credentialsConfiguration);
        changePasswordDialog.setChangePasswordRunnable(changePasswordRunnable);
        changePasswordDialog.open();
    }

    @Override
    public boolean requireConnection(String connectionCategoryID, String description) {
        ConnectionRequiredDialog zosConnectionDialog = new ConnectionRequiredDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), connectionCategoryID, description);
        return zosConnectionDialog.open() == 0;
    }
}

