/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CredentialsManager
implements ICredentialsManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CREDENTIALS_NODE_NAME = "credentials";
    private static final String ENCODING_TYPE = "UTF8";
    private static final Debug debug = new Debug(CredentialsManager.class);
    private Map<String, CredentialsConfiguration> authenticatedInThisSession = new HashMap<String, CredentialsConfiguration>();
    private EventManager<CredentialsManagerListener.CredentialsManagerEvent> eventManager = new EventManager();
    private final Preferences credentialsNode;
    private final IConnectionPasswordStorage passwordStorage;
    private final boolean canSavePasswords;

    public CredentialsManager(Preferences node, IConnectionPasswordStorage passwordStore, boolean passwordSaveable) {
        this.canSavePasswords = passwordSaveable;
        this.credentialsNode = node.node(CREDENTIALS_NODE_NAME);
        this.passwordStorage = passwordStore;
        for (CredentialsConfiguration credentialsConfiguration : this.getAllCredentials()) {
            if (!credentialsConfiguration.isSavePassword()) continue;
            this.authenticatedInThisSession.put(credentialsConfiguration.getID(), credentialsConfiguration);
        }
    }

    @Override
    public void addCredentialsManagerListener(CredentialsManagerListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }

    private String getSerializedConfig(String credentialsConfigurationId) {
        return this.credentialsNode.get(credentialsConfigurationId, null);
    }

    private CredentialsConfiguration read(String configurationID) {
        CredentialsConfiguration configuration;
        String serialized = this.getSerializedConfig(configurationID);
        if (serialized != null && (configuration = this.deserialize(configurationID, serialized)) != null) {
            if (configuration.isSavePassword()) {
                String passwd = this.passwordStorage.read(configuration.getID(), configuration.getUserID());
                configuration.setPassword(passwd);
            }
            return configuration;
        }
        return null;
    }

    public String serialize(CredentialsConfiguration credentialsConfiguration) {
        String name = credentialsConfiguration.getName();
        StringBuffer configSb = new StringBuffer();
        String name64 = this.encodeBase64(name);
        configSb.append(name64).append(",");
        String userid = credentialsConfiguration.getUserID();
        String userid64 = this.encodeBase64(userid);
        configSb.append(userid64).append(",");
        boolean savePassword = credentialsConfiguration.isSavePassword();
        configSb.append(String.valueOf(savePassword));
        CertificateDetails certificateAlias = credentialsConfiguration.getCertificate();
        if (certificateAlias != null) {
            String certificateSubject64 = this.encodeBase64(certificateAlias.getSubject());
            configSb.append(",").append(certificateSubject64);
            String certificateIssuer64 = this.encodeBase64(certificateAlias.getIssuer());
            configSb.append(",").append(certificateIssuer64);
            String certificateAlias64 = this.encodeBase64(certificateAlias.getAlias());
            configSb.append(",").append(certificateAlias64);
            String certificateSource64 = this.encodeBase64(certificateAlias.getSource());
            configSb.append(",").append(certificateSource64);
        } else {
            boolean oneTimePassword = credentialsConfiguration.isOneTimePassword();
            configSb.append(",").append(String.valueOf(oneTimePassword));
        }
        return configSb.toString();
    }

    private String encodeBase64(String decoded) {
        String encoded;
        try {
            encoded = new String(Base64.encodeBase64((byte[])decoded.getBytes(ENCODING_TYPE)));
        }
        catch (UnsupportedEncodingException e) {
            debug.error("save", (Throwable)e);
            encoded = new String(Base64.encodeBase64((byte[])decoded.getBytes()));
        }
        return encoded;
    }

    private String decodeBase64(String encoded) {
        String decoded;
        try {
            decoded = new String(Base64.decodeBase64((byte[])encoded.getBytes()), ENCODING_TYPE);
        }
        catch (UnsupportedEncodingException e) {
            debug.error("read", (Throwable)e);
            decoded = new String(Base64.decodeBase64((byte[])encoded.getBytes()));
        }
        return decoded;
    }

    public CredentialsConfiguration deserialize(String credentialsId, String credCSV64) {
        String certificateSource;
        String certificateAlias;
        String certificateIssuer;
        String certificateSubject;
        String[] tokenized = credCSV64.split(",");
        boolean savePassword = false;
        boolean oneTimePassword = false;
        if (tokenized.length <= 0) {
            return null;
        }
        String name64 = tokenized[0];
        String name = this.decodeBase64(name64);
        if (tokenized.length <= 1) {
            return null;
        }
        String userid64 = tokenized[1];
        String userid = this.decodeBase64(userid64);
        if (tokenized.length > 2) {
            String savePwdStr = tokenized[2];
            savePassword = Boolean.valueOf(savePwdStr);
        }
        if (tokenized.length == 4) {
            String oneTimePwdStr = tokenized[3];
            oneTimePassword = Boolean.valueOf(oneTimePwdStr);
        }
        if (tokenized.length > 6) {
            String certSubject64 = tokenized[3];
            certificateSubject = this.decodeBase64(certSubject64);
            String certIssuer64 = tokenized[4];
            certificateIssuer = this.decodeBase64(certIssuer64);
            String certAlias64 = tokenized[5];
            certificateAlias = this.decodeBase64(certAlias64);
            String certSource64 = tokenized[6];
            certificateSource = this.decodeBase64(certSource64);
        } else {
            certificateAlias = "";
            certificateSubject = "";
            certificateIssuer = "";
            certificateSource = "";
        }
        if (StringUtil.hasContent((String)certificateAlias) && StringUtil.hasContent((String)certificateSubject) && StringUtil.hasContent((String)certificateIssuer)) {
            return new CredentialsConfiguration(credentialsId, name, userid, new CertificateDetails(certificateSubject, certificateIssuer, certificateAlias, certificateSource, null));
        }
        if (oneTimePassword) {
            return CredentialsConfiguration.createOneTimePasswordCredential((String)credentialsId, (String)name, (String)userid);
        }
        return new CredentialsConfiguration(credentialsId, name, userid, "", savePassword);
    }

    @Override
    public void setAuthenticatedInThisSession(CredentialsConfiguration configuration, boolean success) {
        if (success) {
            this.authenticatedInThisSession.put(configuration.getID(), new CredentialsConfiguration(configuration));
        } else {
            this.authenticatedInThisSession.remove(configuration.getID());
        }
    }

    @Override
    public void clearAuthenticated() {
        this.authenticatedInThisSession.clear();
    }

    @Override
    public boolean isAuthenticatedInthisSession(String configurationID) {
        if (configurationID == null) {
            return false;
        }
        return this.authenticatedInThisSession.containsKey(configurationID);
    }

    @Override
    public Collection<CredentialsConfiguration> getAllCredentials() {
        try {
            HashSet<CredentialsConfiguration> result = new HashSet<CredentialsConfiguration>();
            String[] stringArray = this.credentialsNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String credentialsID = stringArray[n2];
                CredentialsConfiguration configuration = this.findCredentialsConfigurationByID(credentialsID);
                if (configuration != null) {
                    result.add(configuration);
                }
                ++n2;
            }
            return result;
        }
        catch (BackingStoreException backingStoreException) {
            return Collections.emptySet();
        }
    }

    @Override
    public CredentialsConfiguration findCredentialsConfigurationByID(String credentialsID) {
        if (credentialsID == null) {
            return null;
        }
        if (this.authenticatedInThisSession.containsKey(credentialsID)) {
            return this.authenticatedInThisSession.get(credentialsID);
        }
        try {
            String[] keys;
            String[] stringArray = keys = this.credentialsNode.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.equals(credentialsID)) {
                    return this.read(credentialsID);
                }
                ++n2;
            }
            return null;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    private void persist() {
        try {
            this.credentialsNode.flush();
        }
        catch (BackingStoreException ex) {
            debug.error("persist", "Error writing credentials", (Throwable)ex);
        }
    }

    private void notifyListeners(CredentialsManagerListener.CredentialsManagerEvent event) {
        this.persist();
        this.eventManager.notifyListeners((Object)event);
    }

    @Override
    public void update(CredentialsConfiguration configuration) {
        this.update(configuration, false);
    }

    @Override
    public void update(CredentialsConfiguration configuration, boolean authenticated) {
        CredentialsConfiguration existingConfig = this.read(configuration.getID());
        CredentialsManagerListener.CredentialsManagerEvent event = null;
        if (!configuration.equals((Object)existingConfig)) {
            if (configuration.isSavePassword()) {
                this.passwordStorage.save(configuration.getID(), configuration.getUserID(), configuration.getPassword());
            } else {
                this.passwordStorage.delete(configuration.getID());
            }
            String serializedConfig = this.serialize(configuration);
            this.credentialsNode.put(configuration.getID(), serializedConfig);
            if (existingConfig == null) {
                event = new CredentialsManagerListener.CredentialAddedEvent(configuration);
            } else {
                authenticated = authenticated || this.isAuthenticatedInthisSession(existingConfig.getID()) && !this.hasSignificantlyChanged(existingConfig, configuration);
                event = new CredentialsManagerListener.CredentialModifiedEvent(existingConfig, configuration);
            }
        } else {
            boolean bl = authenticated = authenticated || this.isAuthenticatedInthisSession(configuration.getID());
        }
        if (authenticated) {
            this.authenticatedInThisSession.put(configuration.getID(), configuration);
        } else {
            this.clearAuthenticated(configuration.getID());
        }
        if (event != null) {
            this.notifyListeners(event);
        }
    }

    private boolean hasSignificantlyChanged(CredentialsConfiguration existing, CredentialsConfiguration replacement) {
        return !replacement.getPassword().equals(existing.getPassword()) || !replacement.getUserID().equals(existing.getUserID()) || replacement.isSavePassword() != existing.isSavePassword();
    }

    @Override
    public void remove(String credentialsConfigurationID) {
        CredentialsConfiguration config = this.read(credentialsConfigurationID);
        this.credentialsNode.remove(credentialsConfigurationID);
        this.passwordStorage.delete(credentialsConfigurationID);
        if (config != null) {
            this.authenticatedInThisSession.remove(credentialsConfigurationID);
            this.notifyListeners(new CredentialsManagerListener.CredentialRemovedEvent(config));
        }
    }

    @Override
    public String createNewName() {
        Collection<CredentialsConfiguration> creds = this.getAllCredentials();
        HashSet<String> names = new HashSet<String>();
        for (CredentialsConfiguration cred : creds) {
            names.add(cred.getName());
        }
        return ConnectionUtils.createNewNamesAgainst(names, Messages.CredentialsManager_newCredentials);
    }

    @Override
    public boolean isPasswordSaveable() {
        return this.canSavePasswords;
    }

    @Override
    public void clearAuthenticated(String credentialsId) {
        this.authenticatedInThisSession.remove(credentialsId);
    }

    @Override
    public void invalidate(String credentialsID) {
        CredentialsConfiguration config = this.findCredentialsConfigurationByID(credentialsID);
        if (config != null) {
            config.setPassword("");
            config.setSavePassword(false);
            this.clearAuthenticated(credentialsID);
            this.update(config);
        }
    }
}

