/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.internal.ConnectionParameterImporter;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.osgi.service.prefs.Preferences;

public class OldCredentialsReader {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionParameterImporter.class);
    public static final String CREDENTIALS_PREFIX = "CREDENTIALS/";
    public static final String IDS_KEY = "CREDENTIALS/ids";
    public static final String ENCODING_TYPE = "UTF8";
    private final Preferences credentialsPreferences;
    private final IConnectionPasswordStorage passwordStorage;

    public OldCredentialsReader(Preferences preferences, IConnectionPasswordStorage passwordStorage) {
        this.credentialsPreferences = preferences;
        this.passwordStorage = passwordStorage;
    }

    public List<CredentialsConfiguration> getCredentialsConfigurations() {
        String idsString = this.credentialsPreferences.get(IDS_KEY, null);
        String[] ids = idsString != null ? idsString.split(",") : new String[]{};
        ArrayList<CredentialsConfiguration> credentials = new ArrayList<CredentialsConfiguration>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String credentialKey = CREDENTIALS_PREFIX + id;
            String serializedCredential = this.credentialsPreferences.get(credentialKey, null);
            if (serializedCredential != null) {
                CredentialsConfiguration configuration = this.deserialize(id, serializedCredential);
                if (configuration == null) {
                    debug.warning("migrate", (Object)"Couldn't deserialize credential", (Object)("credentialId=" + id));
                } else {
                    credentials.add(configuration);
                }
            }
            ++n2;
        }
        return credentials;
    }

    private CredentialsConfiguration deserialize(String credentialsId, String serializedCredential) {
        String userid;
        String name;
        StringTokenizer st = new StringTokenizer(serializedCredential, ",");
        if (!st.hasMoreElements()) {
            return null;
        }
        String name64 = (String)st.nextElement();
        try {
            name = new String(Base64.decodeBase64((byte[])name64.getBytes()), ENCODING_TYPE);
        }
        catch (UnsupportedEncodingException e) {
            debug.warning("read", (Object)e);
            return null;
        }
        if (name == null || "".equals(name)) {
            return null;
        }
        if (!st.hasMoreElements()) {
            return null;
        }
        String userid64 = (String)st.nextElement();
        try {
            userid = new String(Base64.decodeBase64((byte[])userid64.getBytes()), ENCODING_TYPE);
        }
        catch (UnsupportedEncodingException e) {
            debug.warning("read", (Object)e);
            return null;
        }
        if (userid == null || "".equals(userid)) {
            return null;
        }
        boolean savePwd = false;
        if (st.hasMoreElements()) {
            String savePwdStr = (String)st.nextElement();
            savePwd = Boolean.valueOf(savePwdStr);
        }
        String passwd = savePwd ? this.passwordStorage.read(credentialsId, userid) : "";
        CredentialsConfiguration config = new CredentialsConfiguration(credentialsId, name, userid, passwd, savePwd);
        return config;
    }

    public void clear() {
        String credentialsIds = this.credentialsPreferences.get(IDS_KEY, null);
        if (credentialsIds != null && !"".equals(credentialsIds)) {
            String[] ids;
            String[] stringArray = ids = credentialsIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.credentialsPreferences.remove(CREDENTIALS_PREFIX + id);
                this.passwordStorage.delete(id);
                ++n2;
            }
        }
    }
}

