/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.internal.AbstractCredentialsComposite;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UsernameAndPasswordComposite
extends AbstractCredentialsComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text passwordText;
    private Button savePasswordButton;
    private Text newPasswordOrPassPhrase;
    private Text confirmNewPasswordOrPassPhrase;

    public UsernameAndPasswordComposite(Composite parent, CredentialsMode credentialsMode, boolean passwordSaveable, String hostName, boolean addCredentialsTextbox, boolean allowPasswordEntry) {
        super(parent, hostName, addCredentialsTextbox);
        if (allowPasswordEntry) {
            this.createUserInterfaceForPassword(credentialsMode, passwordSaveable);
        }
    }

    private void createUserInterfaceForPassword(CredentialsMode credentialsMode, boolean passwordSaveable) {
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        new Label((Composite)this, 0);
        Label passwordLabel = new Label((Composite)this, 0);
        if (credentialsMode == CredentialsMode.CHANGE_PASSWORD) {
            passwordLabel.setText(Messages.PasswordComposite_existing_password);
        } else {
            passwordLabel.setText(Messages.PasswordComposite_password);
        }
        this.passwordText = new Text((Composite)this, 0x400800);
        TextInput.setAccessibleLabel((Text)this.passwordText, (Label)passwordLabel);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        this.passwordText.setLayoutData((Object)data);
        if (credentialsMode == CredentialsMode.CHANGE_PASSWORD) {
            this.createUserInterfaceForNewPassword();
        }
        new Label((Composite)this, 0);
        Composite passwordWarningComposite = new Composite((Composite)this, 0);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        passwordWarningComposite.setLayoutData((Object)data);
        passwordWarningComposite.setLayout((Layout)new GridLayout(3, false));
        if (credentialsMode != CredentialsMode.CHANGE_PASSWORD) {
            this.savePasswordButton = new Button(passwordWarningComposite, 32);
            this.savePasswordButton.setSelection(false);
            this.savePasswordButton.setText(Messages.PasswordComposite_savePassword);
            data = new GridData(16384, 0, false, false);
            data.horizontalSpan = 2;
            this.savePasswordButton.setLayoutData((Object)data);
            this.savePasswordButton.setVisible(true);
            Label savePasswordInfoIcon = new Label(passwordWarningComposite, 0);
            savePasswordInfoIcon.setImage(ConnectionsImages.getImage("WARNING"));
            savePasswordInfoIcon.setToolTipText(Messages.PasswordComposite_savePasswordDescription);
            data = new GridData(16384, 0x1000000, false, true);
            savePasswordInfoIcon.setLayoutData((Object)data);
            if (!passwordSaveable) {
                this.savePasswordButton.setEnabled(false);
            }
        }
    }

    private void createUserInterfaceForNewPassword() {
        new Label((Composite)this, 0);
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordDialog_New_Password);
        this.newPasswordOrPassPhrase = new Text((Composite)this, 0x400800);
        TextInput.setAccessibleLabel((Text)this.newPasswordOrPassPhrase, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.newPasswordOrPassPhrase.setLayoutData((Object)data);
        new Label((Composite)this, 0);
        l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordDialog_New_Password_confirm);
        this.confirmNewPasswordOrPassPhrase = new Text((Composite)this, 0x400800);
        TextInput.setAccessibleLabel((Text)this.confirmNewPasswordOrPassPhrase, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.confirmNewPasswordOrPassPhrase.setLayoutData((Object)data);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.passwordText != null) {
            this.passwordText.setEnabled(enabled);
        }
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void addListeners(ModifyListener controlModifyListener) {
        super.addListeners(controlModifyListener);
        this.getUserIdText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UsernameAndPasswordComposite.this.credentialsIsDefaultValue && UsernameAndPasswordComposite.this.getCredentialsText() != null) {
                    UsernameAndPasswordComposite.this.getCredentialsText().setText(ConnectionUtils.generateName(UsernameAndPasswordComposite.this.getHostName(), UsernameAndPasswordComposite.this.getUserID()));
                }
            }
        });
        if (this.getCredentialsText() != null) {
            this.getCredentialsText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String generatedName;
                    if (UsernameAndPasswordComposite.this.credentialsIsDefaultValue && !(generatedName = ConnectionUtils.generateName(UsernameAndPasswordComposite.this.getHostName(), UsernameAndPasswordComposite.this.getUserID())).toLowerCase().equals(UsernameAndPasswordComposite.this.getCredentialsName().toLowerCase())) {
                        UsernameAndPasswordComposite.this.credentialsIsDefaultValue = false;
                    }
                }
            });
        }
        if (this.passwordText != null) {
            this.passwordText.addModifyListener(controlModifyListener);
        }
        if (this.newPasswordOrPassPhrase != null) {
            this.newPasswordOrPassPhrase.addModifyListener(controlModifyListener);
        }
        if (this.confirmNewPasswordOrPassPhrase != null) {
            this.confirmNewPasswordOrPassPhrase.addModifyListener(controlModifyListener);
        }
    }

    public void setSavePassword(boolean savePassword) {
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setSelection(savePassword);
        }
    }

    public boolean isSavePassword() {
        return this.savePasswordButton != null ? this.savePasswordButton.getSelection() : false;
    }

    @Override
    public void setEditable(boolean aBoolean) {
        super.setEditable(aBoolean);
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setEnabled(aBoolean);
        }
        if (this.passwordText != null) {
            this.passwordText.setEditable(aBoolean);
        }
    }

    public void setPassword(String password) {
        if (this.passwordText != null && this.passwordText.isEnabled()) {
            this.passwordText.setText(password);
        }
    }

    public String getPassword() {
        if (this.passwordText != null && this.passwordText.isEnabled()) {
            return this.passwordText.getText();
        }
        return "";
    }

    public Text getPasswordText() {
        return this.passwordText;
    }

    public String getNewPassword() {
        if (this.newPasswordOrPassPhrase != null && this.newPasswordOrPassPhrase.isEnabled()) {
            return this.newPasswordOrPassPhrase.getText();
        }
        return "";
    }

    public Text getNewPasswordText() {
        return this.newPasswordOrPassPhrase;
    }

    public String getConfirmPassword() {
        return this.confirmNewPasswordOrPassPhrase.getText();
    }

    public Text getConfirmPasswordText() {
        return this.confirmNewPasswordOrPassPhrase;
    }

    public Button getSavePasswordButton() {
        return this.savePasswordButton;
    }

    public void setPasswordTextFocus() {
        if (this.passwordText != null) {
            this.passwordText.setFocus();
        }
    }

    public void selectAllPassword() {
        if (this.passwordText != null) {
            this.passwordText.selectAll();
        }
    }

    @Override
    public void dispose() {
        if (this.passwordText != null) {
            this.passwordText.dispose();
        }
        if (this.savePasswordButton != null) {
            this.savePasswordButton.dispose();
        }
        if (this.newPasswordOrPassPhrase != null) {
            this.newPasswordOrPassPhrase.dispose();
        }
        if (this.confirmNewPasswordOrPassPhrase != null) {
            this.confirmNewPasswordOrPassPhrase.dispose();
        }
        super.dispose();
    }

    @Override
    public String getTitleMessage() {
        return Messages.CredentialsDialog_specfy_host_msg;
    }
}

