/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.views.ConnectionConfigurationElementComparer;
import com.ibm.cics.core.connections.internal.views.ConnectionsContentProvider;
import com.ibm.cics.core.connections.internal.views.ConnectionsLabelDecorator;
import com.ibm.cics.core.connections.internal.views.ConnectionsLabelProvider;
import com.ibm.cics.core.connections.internal.views.ConnectionsViewFilter;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.core.connections.internal.views.ShowProvidersAction;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConnectionsTreeAndButtonsComposite
extends Composite {
    private static int BUTTON_WIDTH = 80;
    private TreeViewer treeViewer;
    private final ConnectionService connectionService;
    private final IConnectionManager connectionManager;
    private ConnectionServiceListener connectionServiceListener;
    private ConnectionManagerListener connectionManagerListener;
    private Action showProvidersAction;
    private Composite buttonAreaComposite;
    private DefaultConnectionService defaultConnectionService;
    private ConnectionsContentProvider connectionsContentProvider;
    private ConnectionProviderRegistry connectionProviderRegistry = ConnectionProviderRegistry.getDefault();
    private FilteredConnectionRegistry connectionRegistry;

    public ConnectionsTreeAndButtonsComposite(Composite parent, IObservableMap categoryActiveConnectionState, ConnectionService connectionService, Action showProvidersAction, FilteredConnectionRegistry filteredRegistry) {
        super(parent, 0);
        this.connectionService = connectionService;
        this.connectionRegistry = filteredRegistry;
        this.connectionManager = connectionService.getConnectionManager();
        this.showProvidersAction = showProvidersAction;
        this.defaultConnectionService = connectionService.getDefaultConnectionService();
        this.connectionsContentProvider = new ConnectionsContentProvider(filteredRegistry, ConnectionProviderRegistry.getDefault());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        this.setLayoutData(data);
        Composite treeComposite = new Composite((Composite)this, 0);
        this.createTree(treeComposite, categoryActiveConnectionState);
        this.buttonAreaComposite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        this.buttonAreaComposite.setLayout((Layout)gridLayout);
        this.buttonAreaComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).minSize(BUTTON_WIDTH, -1).create());
        this.createAddConnectionButton(this.buttonAreaComposite);
        this.createListeners();
    }

    private void createTree(Composite parent, IObservableMap categoryActiveConnectionState) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)data);
        ConnectionsViewFilter patternFilter = new ConnectionsViewFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filter = new FilteredTree(parent, 68354, (PatternFilter)patternFilter, true);
        this.treeViewer = filter.getViewer();
        this.treeViewer.setComparer((IElementComparer)new ConnectionConfigurationElementComparer());
        Tree tree = this.treeViewer.getTree();
        data = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)this.connectionsContentProvider);
        ConnectionsLabelProvider labelProvider = new ConnectionsLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionsDecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)labelProvider), new ConnectionsLabelDecorator(categoryActiveConnectionState, this.defaultConnectionService), null));
        this.treeViewer.setInput((Object)this.connectionManager);
        this.treeViewer.expandToLevel(2);
        this.treeViewer.setComparator(new ViewerComparator());
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private Button createAddConnectionButton(Composite parent) {
        Button button = this.createButton(Messages.ConnectionsViewPart_Add);
        final SelectionChangedListener listener = new SelectionChangedListener(button);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Object> availableDescriptorIds = new ArrayList();
                availableDescriptorIds = CollectionUtils.transform(listener.availableDescriptors, new Function<IConnectionDescriptor, String>(){

                    @Override
                    public String evaluate(IConnectionDescriptor v) {
                        return v.getId();
                    }
                });
                ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().createConnectionConfiguration(availableDescriptorIds.toArray(new String[0]));
            }
        });
        return button;
    }

    public Button createButton(String text) {
        Button button = new Button(this.buttonAreaComposite, 8);
        GridData buttonData = GridDataFactory.fillDefaults().minSize(BUTTON_WIDTH, -1).grab(true, false).create();
        button.setLayoutData((Object)buttonData);
        button.setText(text);
        return button;
    }

    public void createSeparator() {
        Label separator = new FormToolkit(this.getDisplay()).createSeparator(this.buttonAreaComposite, 256);
        GridData separatorData = new GridData(4, 0, false, false);
        separator.setLayoutData((Object)separatorData);
    }

    private void createListeners() {
        this.connectionServiceListener = new ConnectionServiceListener(){

            public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object parent;
                        if (!ConnectionsTreeAndButtonsComposite.this.treeViewer.getTree().isDisposed() && (parent = ConnectionsTreeAndButtonsComposite.this.connectionsContentProvider.getParent(event.getConnectionProfile())) != null) {
                            ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh(parent);
                        }
                    }
                });
            }
        };
        this.connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.connectionManagerListener = new ConnectionManagerListener(){

            public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                if (!ConnectionsTreeAndButtonsComposite.this.treeViewer.getTree().isDisposed()) {
                    (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).asyncExec((Runnable)new UpdateRunnable(event));
                }
            }
        };
        this.connectionManager.addListener(this.connectionManagerListener);
    }

    public void dispose() {
        this.connectionServiceListener.makeStale();
        this.connectionManagerListener.makeStale();
        super.dispose();
    }

    public Action createShowProvidersAction() {
        return new ShowProvidersAction(this.connectionsContentProvider){

            @Override
            public void run() {
                super.run();
                ConnectionsTreeAndButtonsComposite.this.treeViewer.expandToLevel(2);
            }
        };
    }

    private static class ConnectionsDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public ConnectionsDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
            super(labelProvider, decorator, decorationContext);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private final Button button;
        private IConnectionProvider provider = this.getConnectionProvider((ITreeSelection)TreeSelection.EMPTY);
        private IConnectionDescriptor descriptor;
        private IConnectionCategory category;
        private List<IConnectionDescriptor> availableDescriptors;

        public SelectionChangedListener(Button button) {
            this.availableDescriptors = new ArrayList<IConnectionDescriptor>(Arrays.asList(ConnectionsTreeAndButtonsComposite.this.connectionRegistry.getConnections()));
            this.button = button;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof ITreeSelection) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                if (selection.size() == 1) {
                    Object selected = selection.getFirstElement();
                    if (selected instanceof ConnectionProfile) {
                        this.descriptor = ((ConnectionProfile)selected).getConnectionDescriptor();
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selected instanceof IConnectionDescriptor) {
                        this.descriptor = (IConnectionDescriptor)selected;
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selected instanceof ConnectionsContentProvider.ConnectionProviderDescriptorNode) {
                        this.descriptor = ((ConnectionsContentProvider.ConnectionProviderDescriptorNode)selected).getConnectionDescriptor();
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selection instanceof IConnectionCategory) {
                        this.category = (IConnectionCategory)selection;
                        this.descriptor = null;
                        this.provider = this.getConnectionProvider(selection);
                    } else {
                        this.provider = this.getConnectionProvider(selection);
                        this.descriptor = null;
                        this.category = null;
                    }
                } else {
                    this.provider = this.getConnectionProvider((ITreeSelection)TreeSelection.EMPTY);
                    this.descriptor = null;
                    this.category = null;
                }
            }
            this.updateDescriptors();
            this.button.setEnabled(!this.availableDescriptors.isEmpty());
        }

        private IConnectionProvider getConnectionProvider(ITreeSelection selection) {
            if (ConnectionsTreeAndButtonsComposite.this.showProvidersAction != null && ConnectionsTreeAndButtonsComposite.this.showProvidersAction.isChecked()) {
                if (selection.isEmpty()) {
                    return null;
                }
                return (IConnectionProvider)selection.getPaths()[0].getFirstSegment();
            }
            return ConnectionsTreeAndButtonsComposite.this.connectionProviderRegistry.getLocalConnectionProvider();
        }

        private void updateDescriptors() {
            this.availableDescriptors.clear();
            if (this.provider instanceof IWritableConnectionProvider) {
                if (this.descriptor != null) {
                    if (!this.filterDescriptor(this.descriptor)) {
                        this.availableDescriptors.add(this.descriptor);
                    }
                } else {
                    IConnectionDescriptor[] iConnectionDescriptorArray = ConnectionsTreeAndButtonsComposite.this.connectionRegistry.getConnections();
                    int n = iConnectionDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConnectionDescriptor descriptor = iConnectionDescriptorArray[n2];
                        if (!this.filterDescriptor(descriptor)) {
                            this.availableDescriptors.add(descriptor);
                        }
                        ++n2;
                    }
                }
            }
        }

        private boolean filterDescriptor(IConnectionDescriptor descriptor) {
            return descriptor.isTransient() && !descriptor.isFactory() || this.category != null && this.category != descriptor.getCategory() || this.isFilteredConnectionType(descriptor);
        }

        private boolean isFilteredConnectionType(IConnectionDescriptor descriptor) {
            return ConnectionsTreeAndButtonsComposite.this.connectionRegistry.find(descriptor.getId()) == null;
        }
    }

    private class UpdateRunnable
    implements Runnable {
        private final ConnectionManagerListener.ConnectionManagerEvent event;

        public UpdateRunnable(ConnectionManagerListener.ConnectionManagerEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (!ConnectionsTreeAndButtonsComposite.this.treeViewer.getTree().isDisposed()) {
                if (this.event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.getContentProvider().inputChanged((Viewer)ConnectionsTreeAndButtonsComposite.this.treeViewer, null, (Object)ConnectionsTreeAndButtonsComposite.this.connectionManager);
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)((ConnectionManagerListener.ConnectionProfileUpdatedEvent)this.event).getConnectionProfile(), true);
                } else if (this.event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.getContentProvider().inputChanged((Viewer)ConnectionsTreeAndButtonsComposite.this.treeViewer, null, (Object)ConnectionsTreeAndButtonsComposite.this.connectionManager);
                    ConnectionProfile addedConfiguration = ((ConnectionManagerListener.ConnectionProfileAddedEvent)this.event).getConnectionProfile();
                    IConnectionDescriptor connectionDescriptor = addedConfiguration.getConnectionDescriptor();
                    IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(connectionDescriptor.getCategory().getId());
                    if (ConnectionsTreeAndButtonsComposite.this.showProvidersAction != null && ConnectionsTreeAndButtonsComposite.this.showProvidersAction.isChecked()) {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)addedConfiguration.getConnectionProvider(), true);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.expandToLevel((Object)addedConfiguration.getConnectionProvider(), 1);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.expandToLevel((Object)ConnectionsTreeAndButtonsComposite.this.connectionsContentProvider.getConnectionProviderDescriptorNode(addedConfiguration.getConnectionProvider(), connectionDescriptor), 1);
                    } else if (connectionCategory.getConnections().length == 1) {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionCategory, true);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.expandToLevel((Object)connectionCategory, 1);
                    } else {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionDescriptor, true);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.expandToLevel((Object)connectionDescriptor, 1);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionCategory, true);
                    }
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.reveal((Object)addedConfiguration);
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)addedConfiguration));
                } else if (this.event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.getContentProvider().inputChanged((Viewer)ConnectionsTreeAndButtonsComposite.this.treeViewer, null, (Object)ConnectionsTreeAndButtonsComposite.this.connectionManager);
                    ConnectionManagerListener.ConnectionProfileRemovedEvent configurationRemovedEvent = (ConnectionManagerListener.ConnectionProfileRemovedEvent)this.event;
                    ConnectionProfile removedConfiguration = configurationRemovedEvent.getConnectionProfile();
                    ConnectionsTreeAndButtonsComposite.this.treeViewer.remove((Object)removedConfiguration);
                    IConnectionDescriptor connectionDescriptor = removedConfiguration.getConnectionDescriptor();
                    IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(connectionDescriptor.getCategory().getId());
                    if (ConnectionsTreeAndButtonsComposite.this.showProvidersAction != null && ConnectionsTreeAndButtonsComposite.this.showProvidersAction.isChecked()) {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)removedConfiguration.getConnectionProvider(), true);
                    } else if (connectionCategory.getConnections().length == 1) {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionCategory, true);
                    } else {
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionDescriptor, true);
                        ConnectionsTreeAndButtonsComposite.this.treeViewer.refresh((Object)connectionCategory, true);
                    }
                }
            }
        }
    }
}

