/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.actions.AbstractPerformOperationActionDelegate;
import com.ibm.cics.core.ui.actions.Messages;
import com.ibm.cics.core.ui.adapters.IWorkloadTargetSource;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.eclipse.common.ops.DefaultOperationUIDelegate;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.eclipse.common.ops.IOperationUIDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.sm.comm.SystemManagerActions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ActivateWorkloadTargetAction
extends AbstractPerformOperationActionDelegate<IWorkloadTarget> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected IOperationUIDelegate<? super IWorkloadTarget> getOperationUIDelegate() throws AbstractPerformOperationActionDelegate.CICSObjectActionException {
        return new DefaultOperationUIDelegate((IOperationExecutionDelegate)new ActivateWorkloadTargetExecutionDelegate(), (ILabelProvider)new CICSObjectLabelProvider());
    }

    @Override
    protected List<? extends IWorkloadTarget> getTargets(ISelection selection) {
        if (((StructuredSelection)selection).getFirstElement() instanceof IWorkloadTargetSource) {
            return this.getTargetListFromSelection(selection);
        }
        return ((StructuredSelection)selection).toList();
    }

    private List<? extends IWorkloadTarget> getTargetListFromSelection(ISelection selection) {
        ArrayList<IWorkloadTarget> workloads = new ArrayList<IWorkloadTarget>();
        for (Object object : ((StructuredSelection)selection).toList()) {
            workloads.add(((IWorkloadTargetSource)object).getTarget());
        }
        return workloads;
    }

    @Override
    protected boolean singleSelectionOnly() {
        return false;
    }

    @Override
    protected Map<String, String> getEnablementTestVariables() {
        return this.generateEnablementTestVariables("perform", "Activate");
    }

    private class ActivateWorkloadTargetExecutionDelegate
    implements IOperationExecutionDelegate<IWorkloadTarget> {
        public void execute(IWorkloadTarget target) throws ExecutionFailedException {
            try {
                ((ICoreObject)target).getCPSM().perform(new ICICSObject[]{target}, SystemManagerActions.Activate);
            }
            catch (CICSSystemManagerException e) {
                IStatus errorMessage = ExceptionMessageHelper.getStatus((CICSActionException)((Object)e), target.getObjectType(), 2);
                throw new ExecutionFailedException(errorMessage);
            }
        }

        public String getOperationName() {
            return SystemManagerActions.Activate.getActionName();
        }

        public String getOperationDescription(IWorkloadTarget target) {
            return Messages.getString("operation.perform.description", this.getOperationName(), ExceptionMessageHelper.getObjectTypeDescription((ICICSObject)target), target.getName(), ExceptionMessageHelper.getContextOrScopeNameFor((ICoreObject)target));
        }

        public int getID() {
            return 611;
        }
    }
}

