/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import org.eclipse.core.runtime.IStatus;

public class ResolveReferenceExecutionDelegate<T extends ICICSObject>
implements IOperationExecutionDelegate<ICICSObjectReference<? extends T>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private T object;

    public void execute(ICICSObjectReference<? extends T> ref) throws ExecutionFailedException {
        try {
            this.object = ref.resolve();
        }
        catch (CICSActionException ex) {
            IStatus status = ExceptionMessageHelper.getStatus(ex, ref.getCICSType(), 2);
            throw new ExecutionFailedException(status);
        }
    }

    public T getCICSObject() {
        return this.object;
    }

    public String getOperationName() {
        return com.ibm.cics.core.ui.actions.Messages.getString("GetExecutionDelegate.get");
    }

    public String getOperationDescription(ICICSObjectReference<? extends T> ref) {
        String name = this.getTargetName(ref);
        String typeName = Messages.getTableDescription(ref.getCICSType().getResourceTableName());
        return com.ibm.cics.core.ui.actions.Messages.getString("operation.get.description", typeName, name, ref.getCICSContainer().getDescription());
    }

    private String getTargetName(ICICSObjectReference<?> ref) {
        String attributeValue;
        String nameAttribute = ref.getCICSType().getNameAttribute();
        ICICSAttribute attribute = ref.getCICSType().findAttributeByCicsName(nameAttribute);
        if (attribute != null && attribute.getType() == String.class && (attributeValue = (String)ref.getAttributeValue(attribute)) != null) {
            return attributeValue;
        }
        return "";
    }

    public int getID() {
        return 607;
    }
}

