/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IChild;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.core.model.RegionsModel;
import com.ibm.cics.core.model.extra.IWLMRoutersNode;
import com.ibm.cics.core.model.extra.IWLMTargetsNode;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.explorer.tables.ui.TablesUIPlugin;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CICSplexLabelDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CICSplexLabelDecorator.class.getPackage().getName());
    private static final String WORKLOAD_TARGET_DUMPING = " DUMPING";
    private static final String WORKLOAD_TARGET_SHORT_ON_STORAGE = " SOS";
    private static final String WORKLOAD_TARGET_AT_MAXTASKS = " MAXTASKS";
    private static final String WORKLOAD_TARGET_STALLED = " STALLED";

    public void decorate(Object element, IDecoration decoration) {
        Debug.enter((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)this, (Object)element, (Object)decoration);
        if (element instanceof ICICSplex) {
            ICICSplex cicsPlex = (ICICSplex)element;
            RegionsModel regions = (RegionsModel)ModelUtilities.getRegions((IParent)((IParent)cicsPlex));
            ICICSObject[] managedRegions = this.getManagedRegions((IParent)cicsPlex);
            String suffix = " (" + regions.size() + "/" + managedRegions.length + ")";
            Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)suffix);
            decoration.addSuffix(suffix);
        } else if (element instanceof IManagedRegion && element instanceof IChild) {
            IManagedRegion managedRegion = (IManagedRegion)element;
            ICICSplex cicsPlex = (ICICSplex)((IChild)element).getParent();
            IRegion region = ModelUtilities.findRegion((ICICSplex)cicsPlex, (String)managedRegion.getName());
            if (region != null) {
                String applid = region.getApplID();
                String suffix = " (" + applid + ")";
                Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)region, (Object)suffix);
                decoration.addSuffix(suffix);
                ICPSM cpsm = (ICPSM)((IChild)cicsPlex).getParent();
                if (applid.equals(cpsm.getName())) {
                    Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)applid);
                    decoration.addOverlay(UIPlugin.IMGD_WUI, 2);
                }
            }
        } else if (element instanceof IWorkload) {
            IWorkload activeWorkload = (IWorkload)element;
            IWorkload.WorkloadStatusValue status = activeWorkload.getWorkloadStatus();
            String suffix = " (" + status + ")";
            decoration.addSuffix(suffix);
            if (status == IWorkload.WorkloadStatusValue.FROZEN) {
                Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)activeWorkload);
                decoration.addOverlay(TablesUIPlugin.IMGD_ERROR_CONTENT_OVERLAY, 3);
            }
        } else if (element instanceof IWLMRoutersNode) {
            IWLMRoutersNode routersNode = (IWLMRoutersNode)element;
            String suffix = " (" + routersNode.getActiveRoutingRegions() + ")";
            decoration.addSuffix(suffix);
        } else if (element instanceof IWLMTargetsNode) {
            IWLMTargetsNode targetsNode = (IWLMTargetsNode)element;
            String suffix = " (" + targetsNode.getActiveTargetRegions() + ")";
            decoration.addSuffix(suffix);
        } else if (element instanceof IWorkloadTarget) {
            decoration.addSuffix(this.getWorkloadTargetDecorationSuffix((IWorkloadTarget)element));
        }
        Debug.exit((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate");
    }

    private String getWorkloadTargetDecorationSuffix(IWorkloadTarget workloadTarget) {
        StringBuilder sb = new StringBuilder(" (");
        sb.append(workloadTarget.getStatus());
        if (workloadTarget.getHealthDump() == IWorkloadTarget.HealthDumpValue.YES) {
            sb.append(WORKLOAD_TARGET_DUMPING);
        }
        if (workloadTarget.getHealthShortOnStorage() == IWorkloadTarget.HealthShortOnStorageValue.YES) {
            sb.append(WORKLOAD_TARGET_SHORT_ON_STORAGE);
        }
        if (workloadTarget.getHealthMaxtasks() == IWorkloadTarget.HealthMaxtasksValue.YES) {
            sb.append(WORKLOAD_TARGET_AT_MAXTASKS);
        }
        if (workloadTarget.getHealthStall() == IWorkloadTarget.HealthStallValue.YES) {
            sb.append(WORKLOAD_TARGET_STALLED);
        }
        sb.append(")");
        return sb.toString();
    }

    private ICICSObject[] getManagedRegions(IParent plex) {
        ICICSObject[] managedRegions = plex.getChildrenAsArray((ICICSType)ManagedRegionType.getInstance());
        return managedRegions;
    }

    public void addListener(ILabelProviderListener listener) {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"addListener", (Object)(" " + this + " listener=" + listener));
        }
    }

    public void dispose() {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"dispose");
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

