/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.comm.internal.ConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.IModelBasedConnectable;
import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.PreferenceInvocationHandler;
import com.ibm.cics.core.ui.internal.views.ColumnDataManager;
import com.ibm.cics.core.ui.views.FilterManager;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.PreferenceService;
import com.ibm.cics.core.ui.views.RefreshAction;
import com.ibm.cics.core.ui.views.ResetColumnsAction;
import com.ibm.cics.core.ui.views.ResetWidthsAction;
import com.ibm.cics.core.ui.views.SortManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.explorer.tables.ui.CommonMessages;
import com.ibm.cics.explorer.tables.ui.CopyCICSObjectHelper;
import com.ibm.cics.explorer.tables.ui.IBaseContextProvider;
import com.ibm.cics.explorer.tables.ui.ResourcesModelMessaging;
import com.ibm.cics.explorer.tables.ui.ResourcesTableContentProvider;
import com.ibm.cics.explorer.tables.ui.TableViewContentDescriber;
import com.ibm.cics.explorer.tables.ui.internal.BaseContextProvider;
import com.ibm.cics.explorer.tables.ui.internal.ConnectionStateContextProvider;
import com.ibm.cics.explorer.tables.ui.internal.ContextChangedContextProvider;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.sm.comm.ComplexFilteredContext;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SortOrder;
import com.ibm.cics.sm.comm.context.OrderedContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class ResourcesTable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(ResourcesTable.class);
    private static final int DEFAULT_MAX_SORT_DEPTH = 1;
    private final IElementTypeService elementTypeService;
    private final DelegateBaseContextProvider baseContextProvider = new DelegateBaseContextProvider();
    private IWorkbenchPartSite site;
    private IMenuManager menuManager;
    private IToolBarManager toolBarManager;
    private IStatusLineManager statusLineManager;
    private Composite resourcesAvailableComposite;
    private Composite resourcesTableComposite;
    private TableViewer tableViewer;
    private IModelBasedConnectable cpsm;
    private LegacyTableManager legacyTableManager;
    private ResourcesTableContentProvider contentProvider;
    private ResourcesModelMessaging modelMessaging;
    private TableViewContentDescriber contentDescriber;
    private SortManager sortManager;
    private PreferenceService preferenceService;
    private FilterManager filterManager;
    private final IDefaultColumnsProvider defaultColumnsProvider;
    private SortManager.SortListener sortListener;
    private ResourcesTableConnectionServiceListener connectionServiceListener;
    private IAction refreshAction;
    private IAction resetColumnsAction;
    private IAction resetWidthsAction;
    private Menu popupMenu;
    private final boolean multiSelect;
    private final String connectionCategoryId;
    private boolean visible;
    private boolean dirty;
    private boolean currentSelectionIsLoaded = true;
    private final FilterManager.FilterListener filterListener = new FilterManager.FilterListener(){

        public void event(FilterManager.FilterEvent event) {
            DEBUG.enter("FilterListener.event", (Object)event);
            if (event instanceof FilterManager.FilterChangedEvent) {
                ResourcesTable.this.setDirty();
                ResourcesTable.this.maybeSetInput();
            }
            DEBUG.exit("FilterListener.event");
        }
    };

    public ResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        this.elementTypeService = elementTypeService;
        this.defaultColumnsProvider = defaultColumnsProvider;
        this.connectionCategoryId = connectionCategoryId;
        this.multiSelect = multiSelect;
        this.getBaseContextProvider().addListener(new IBaseContextProvider.Listener(){

            public void event(IBaseContextProvider.ContextChangedEvent event) {
                ResourcesTable.this.setDirty();
                ResourcesTable.this.maybeSetInput();
            }
        });
    }

    public Composite getComposite() {
        return this.resourcesTableComposite;
    }

    public IElementTypeService getElementTypeService() {
        return this.elementTypeService;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public SortManager getSortManager() {
        return this.sortManager;
    }

    public LegacyTableManager getTableManager() {
        return this.legacyTableManager;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public PreferenceService getPreferenceService() {
        return this.preferenceService;
    }

    public void setBaseContextProvider(IBaseContextProvider baseContextProvider) {
        baseContextProvider = new ConnectionStateContextProvider(this.connectionCategoryId, ConnectionsPlugin.getDefault().getConnectionService(), baseContextProvider);
        baseContextProvider = new ContextChangedContextProvider(baseContextProvider);
        this.getBaseContextProvider().setDelegate(baseContextProvider);
    }

    public DelegateBaseContextProvider getBaseContextProvider() {
        return this.baseContextProvider;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    private void setDirty() {
        this.dirty = true;
    }

    public void setContentDescription(String description) {
        this.contentDescriber.setStatusMessage(description);
    }

    public void createControl(Composite parent) {
        this.resourcesTableComposite = new Composite(parent, 0);
        this.resourcesTableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(0, 0).create());
        this.resourcesTableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.contentDescriber = new TableViewContentDescriber(this.resourcesTableComposite);
        this.resourcesAvailableComposite = new Composite(this.resourcesTableComposite, 0);
        this.resourcesAvailableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
        this.createTableViewer();
        this.addListeners();
        this.createPopupMenu();
        this.makeActions();
        this.fillBars();
    }

    private void addListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    int tableSelectionSize;
                    int viewerSelectionSize = ((IStructuredSelection)selection).size();
                    if (viewerSelectionSize < (tableSelectionSize = ResourcesTable.this.tableViewer.getTable().getSelection().length)) {
                        DEBUG.event("selectionChanged", (Object)this, (Object)viewerSelectionSize, (Object)tableSelectionSize);
                        ResourcesTable.this.tableViewer.getControl().setMenu(null);
                        ResourcesTable.this.setWarningStatusMessage(NLS.bind((String)CommonMessages.ResourcesView_popupmenuDisabled, (Object)viewerSelectionSize, (Object)tableSelectionSize));
                        ResourcesTable.this.currentSelectionIsLoaded = false;
                    } else {
                        DEBUG.event("selectionChanged", (Object)this, (Object)viewerSelectionSize, (Object)ResourcesTable.this.popupMenu);
                        DEBUG.event("selectionChanged", (Object)event, ((IStructuredSelection)event.getSelection()).getFirstElement());
                        ResourcesTable.this.tableViewer.getControl().setMenu(ResourcesTable.this.popupMenu);
                        ResourcesTable.this.clearStatusMessage();
                        ResourcesTable.this.currentSelectionIsLoaded = true;
                    }
                }
            }
        });
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourcesTable.this.dispose();
            }
        });
    }

    public boolean isCurrentSelectionLoaded() {
        return this.currentSelectionIsLoaded;
    }

    public void init(IWorkbenchPartSite site, IToolBarManager toolBarManager, IMenuManager menuManager, IStatusLineManager statusLineManager, boolean savePreferences) {
        this.site = site;
        this.toolBarManager = toolBarManager;
        this.menuManager = menuManager;
        this.statusLineManager = statusLineManager;
        this.legacyTableManager = new LegacyTableManager(this.multiSelect){

            @Override
            public TableViewer createTableViewer(Composite parent) {
                return super.createTableViewer(parent, 2048);
            }
        };
        this.sortManager = new SortManager(this.legacyTableManager, 1);
        this.preferenceService = new PreferenceService(this.legacyTableManager, savePreferences, this.elementTypeService, this.defaultColumnsProvider);
        this.elementTypeService.addElementTypeServiceListener(new IElementTypeService.ElementTypeServiceListener(){

            public void event(IElementTypeService.Event event) {
                (Display.getCurrent() != null ? Display.getCurrent() : ResourcesTable.this.tableViewer.getTable().getDisplay()).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourcesTable.this.updateSortFiltersAndData();
                    }
                });
            }
        });
        this.filterManager = new FilterManager(this.legacyTableManager, this.elementTypeService, this.preferenceService, savePreferences, toolBarManager);
        this.filterManager.addListener(this.filterListener);
    }

    protected IPreferenceStore getPreferenceStore() {
        IConnection connection;
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        if (this.cpsm != null && (connection = this.cpsm.getConnection()) != null && connection.isConnected()) {
            IConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor(connection);
            String pluginId = ((ConnectionDescriptor)connectionDescriptor).getElement().getContributor().getName();
            PreferenceInvocationHandler handler = new PreferenceInvocationHandler(pluginId, store);
            store = (IPreferenceStore)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IPreferenceStore.class}, (InvocationHandler)handler);
        }
        return store;
    }

    private IConnectionDescriptor getConnectionDescriptor(IConnection connection) {
        IConnectionDescriptor descriptor = this.lookupDescriptorByConfigurationId(connection);
        if (descriptor == null) {
            descriptor = this.lookupDescriptorByConnectionClass(connection);
        }
        if (descriptor == null) {
            throw new RuntimeException("Could't determine connection descriptor for connection " + connection);
        }
        return descriptor;
    }

    private IConnectionDescriptor lookupDescriptorByConnectionClass(IConnection connection) {
        IConnectionCategory category = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(this.connectionCategoryId);
        if (category != null) {
            IConnectionDescriptor[] iConnectionDescriptorArray = category.getConnections();
            int n = iConnectionDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectionDescriptor descriptor = iConnectionDescriptorArray[n2];
                try {
                    IConnection testConnection = descriptor.createConnection();
                    if (testConnection.getClass().equals(connection.getClass())) {
                        return descriptor;
                    }
                }
                catch (ConnectionException ex) {
                    DEBUG.warning("lookupDescriptorByConnectionClass", "Couldn't load connection for descriptor: " + descriptor.getId(), (Throwable)ex);
                }
                ++n2;
            }
        }
        return null;
    }

    private IConnectionDescriptor lookupDescriptorByConfigurationId(IConnection connection) {
        ConnectionProfile profile = ConnectionsPlugin.getDefault().getConnectionManager().getConnectionProfile(connection.getConfiguration().getID());
        return profile != null ? profile.getConnectionDescriptor() : null;
    }

    public void connected(IConnectable cpsm) {
        DEBUG.enter("connected", (Object)this, (Object)cpsm);
        if (this.cpsm == null) {
            this.cpsm = (IModelBasedConnectable)cpsm;
            boolean resourceAvailable = this.cpsm.checkPermission(ICICSOperation.GET, this.elementTypeService.getElementType());
            boolean supportsComplexFilters = this.cpsm.checkPermission(ICICSOperation.GET, this.getElementTypeService().getElementType(), (IContext)new ComplexFilteredContext(this.getBaseContextProvider().getContext(), FilterExpression.NULL));
            if (!resourceAvailable) {
                this.setContentDescription(CommonMessages.ResourcesView_statusResourceUnavailable);
            } else {
                this.sortListener = new SortListener();
                this.sortManager.addListener(this.sortListener);
                this.filterManager.setComplexFiltersSupported(supportsComplexFilters);
            }
            this.maybeSetInput();
        }
        this.updateColumnDataManager();
        this.tableViewer.getTable().getParent().layout();
        DEBUG.exit("connected");
    }

    public void exception(IConnectable cpsm, Exception ex) {
    }

    public boolean disconnecting(IConnectable cpsm) {
        return false;
    }

    public void disconnected(IConnectable cpsm) {
        DEBUG.enter("disconnected", (Object)this, (Object)cpsm);
        this.updateColumnDataManager();
        if (cpsm != null && cpsm.equals(this.cpsm)) {
            this.filterManager.disableActions();
            this.tableViewer.setInput(null);
            this.cpsm = null;
            this.sortManager.removeListener(this.sortListener);
            this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        DEBUG.exit("disconnected");
    }

    public void connecting(IConnectable cpsm) {
    }

    private boolean isConnectedWithAccess(IContext context) {
        if (this.cpsm != null && this.cpsm.isConnected()) {
            return context != null ? this.cpsm.checkPermission(ICICSOperation.GET, this.elementTypeService.getElementType(), context) : this.cpsm.checkPermission(ICICSOperation.GET, this.elementTypeService.getElementType());
        }
        return false;
    }

    private void createTableViewer() {
        this.tableViewer = this.legacyTableManager.createTableViewer(this.resourcesAvailableComposite);
        this.updateColumnDataManager();
        this.contentProvider = new ResourcesTableContentProvider(this.tableViewer, this.site);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.modelMessaging = new ResourcesModelMessaging(this.tableViewer.getTable().getDisplay(), this.statusLineManager, this.contentDescriber);
        final CopyHandler copyHandler = new CopyHandler();
        final IHandlerService handlerService = (IHandlerService)this.site.getService(IHandlerService.class);
        this.tableViewer.getTable().addFocusListener(new FocusListener(){
            private IHandlerActivation handlerActivation;

            public void focusLost(FocusEvent e) {
                if (this.handlerActivation != null) {
                    handlerService.deactivateHandler(this.handlerActivation);
                    this.handlerActivation = null;
                }
            }

            public void focusGained(FocusEvent e) {
                this.handlerActivation = handlerService.activateHandler(ActionFactory.COPY.getCommandId(), (IHandler)copyHandler);
            }
        });
    }

    private void updateColumnDataManager() {
        this.preferenceService.setColumnDataManager(new ColumnDataManager(this.getPreferenceStore()));
    }

    protected IModelBasedConnectable getCPSM() {
        return this.cpsm;
    }

    public boolean setCPSM(IModelBasedConnectable cpsm) {
        if (!this.disconnecting((IConnectable)this.getCPSM())) {
            this.disconnected((IConnectable)this.getCPSM());
            this.connecting((IConnectable)cpsm);
            this.connected((IConnectable)cpsm);
            return true;
        }
        return false;
    }

    public void maybeSetInput() {
        if (this.tableViewer != null) {
            this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResourcesTable.this.cpsm != null && ResourcesTable.this.baseContextProvider.getContext() != null) {
                        Object oldInput;
                        if (ResourcesTable.this.visible && ((oldInput = ResourcesTable.this.tableViewer.getInput()) == null || ResourcesTable.this.dirty)) {
                            DEBUG.event("maybeSetInput", (Object)this);
                            ResourcesTable.this.clearStatusMessage();
                            ResourcesTable.this.setInput();
                            ResourcesTable.this.dirty = false;
                            ResourcesTable.this.filterManager.enableActions();
                        }
                    } else if (ResourcesTable.this.baseContextProvider.getDescription() != null) {
                        ResourcesTable.this.setContentDescription(ResourcesTable.this.baseContextProvider.getDescription());
                    }
                }
            });
        }
    }

    protected IContext applySort(List<SortManager.SortData> sortDatas, IContext baseContext) {
        if (baseContext == null) {
            return null;
        }
        if (sortDatas == null) {
            throw new IllegalArgumentException("Sort data is null");
        }
        ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
        if (!sortDatas.isEmpty()) {
            for (SortManager.SortData sortData : sortDatas) {
                if (!(sortData.getId() instanceof ICICSAttribute)) {
                    throw new IllegalArgumentException("ID not an instance of ICICSAttribute");
                }
                ICICSAttribute attribute = (ICICSAttribute)sortData.getId();
                sortOrders.add(new SortOrder(attribute.getCicsName(), sortData.getDirection()));
            }
            return new OrderedContext(baseContext, sortOrders);
        }
        return baseContext;
    }

    private void setInput() {
        IContext context = this.filterManager.applyFilters(this.baseContextProvider.getContext());
        String filterErrorMessage = this.filterManager.getIgnoredFiltersMessage();
        if (!filterErrorMessage.isEmpty()) {
            this.setWarningStatusMessage(filterErrorMessage);
            ViewHelper.log((IStatus)new Status(2, "com.ibm.cics.core.ui", filterErrorMessage));
        }
        IContext sortedContext = this.applySort(this.sortManager.getSortData(), context);
        if (this.cpsm.checkPermission(ICICSOperation.GET, this.elementTypeService.getElementType(), sortedContext)) {
            context = sortedContext;
        }
        if (context != null && this.isConnectedWithAccess(context)) {
            IResourcesModel model = this.getInput(this.cpsm, context);
            this.modelMessaging.attachTo(model, this.elementTypeService.getElementType());
            if (!this.tableViewer.getTable().isDisposed()) {
                this.tableViewer.setInput((Object)model);
            }
        }
    }

    protected IResourcesModel getInput(IModelBasedConnectable cpsm, IContext context) {
        return cpsm.getModel(this.elementTypeService.getElementType(), context);
    }

    protected void updateSortFiltersAndData() {
        DEBUG.enter("updateViewer", (Object)this);
        this.sortManager.clearSort();
        this.updateViewerFilterAndData();
        DEBUG.exit("updateViewer");
    }

    protected void updateViewerFilterAndData() {
        this.setDirty();
        this.maybeSetInput();
    }

    public void clearStatusMessage() {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(null);
            this.statusLineManager.setErrorMessage(null);
        }
    }

    protected void setStatusMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    protected void setWarningStatusMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(UIPlugin.getImage(UIPlugin.IMGD_WARNING), message);
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public void visible(boolean isVisible) {
        if (isVisible) {
            this.visible = true;
            this.maybeSetInput();
        } else {
            this.visible = false;
        }
    }

    public void opened() {
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        this.connectionServiceListener = new ResourcesTableConnectionServiceListener(this);
        connectionService.addConnectionServiceListener((ConnectionServiceListener)this.connectionServiceListener);
        IConnectable cpsm = connectionService.getConnectable(this.connectionCategoryId);
        if (cpsm != null && cpsm.isConnected()) {
            this.connected(cpsm);
        }
    }

    private void dispose() {
        this.connectionServiceListener.makeStale();
        this.baseContextProvider.dispose();
        this.modelMessaging.dispose();
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager(){

            protected void update(boolean force, boolean recursive) {
                ResourcesTable.this.menuAboutToUpdate((IMenuManager)this);
                super.update(force, recursive);
            }
        };
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourcesTable.this.menuAboutToShow(manager);
            }
        });
        this.popupMenu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(this.popupMenu);
        IWorkbenchPartSite site = this.getSite();
        if (site != null) {
            site.registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        }
    }

    protected void menuAboutToUpdate(IMenuManager menuManager) {
    }

    protected void menuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("new"));
        manager.add((IContributionItem)new Separator("open"));
        manager.add((IContributionItem)new Separator("actions"));
        manager.add((IContributionItem)new Separator("commonActions"));
        manager.appendToGroup("commonActions", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.site, null, ActionFactory.COPY.getCommandId(), 8)));
        manager.add((IContributionItem)new Separator("enableActions"));
        manager.add((IContributionItem)new Separator("availableActions"));
        manager.add((IContributionItem)new Separator("discardAction"));
        manager.add((IContributionItem)new Separator("clipboard"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void refresh() {
        this.refreshAction.run();
    }

    protected void makeActions() {
        this.refreshAction = new RefreshAction(this.contentProvider, (Viewer)this.tableViewer);
        this.resetColumnsAction = new ResetColumnsAction(this.preferenceService);
        this.resetWidthsAction = new ResetWidthsAction(this.getTableManager());
        final Table table = this.getTableViewer().getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (table.getSelectionCount() == 1 && table.getSelection()[0].getData() instanceof ICICSObject) {
                    ICICSObject aCICSObject = (ICICSObject)table.getSelection()[0].getData();
                    ResourcesTable.this.performDefaultViewAction(aCICSObject);
                }
            }
        });
    }

    protected void performDefaultViewAction(final ICICSObject aCICSObject) {
        BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                UIPlugin.performDefaultViewAction(aCICSObject);
            }
        });
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        String refreshGroupName = "refresh";
        toolBar.add((IContributionItem)new Separator("refresh"));
        ActionContributionItem customizeColumnsItem = new ActionContributionItem((IAction)this.preferenceService.getCustomizeColumnsAction());
        ActionContributionItem refreshItem = new ActionContributionItem(this.refreshAction);
        toolBar.appendToGroup("refresh", (IContributionItem)customizeColumnsItem);
        toolBar.appendToGroup("refresh", (IContributionItem)refreshItem);
        toolBar.appendToGroup("refresh", this.getSortManager().getClearSortAction());
        toolBar.add((IContributionItem)new Separator("additions"));
        toolBar.add((IContributionItem)new Separator("filter"));
        this.filterManager.refreshFilterToolBarContributionsFromPreferences();
        toolBar.add((IContributionItem)new GroupMarker("filterActions"));
        this.filterManager.fillToolBar(toolBar);
    }

    protected void fillMenu(IMenuManager menu) {
        menu.add(this.getSortManager().getClearSortAction());
        menu.add(this.refreshAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.resetColumnsAction);
        menu.add(this.resetWidthsAction);
        menu.add((IAction)this.preferenceService.getCustomizeColumnsAction());
        this.addExtraContributions(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)this.filterManager.createFilterMenu());
    }

    protected void addExtraContributions(IMenuManager menu) {
    }

    protected void fillBars() {
        this.fillMenu(this.menuManager);
        this.fillToolBar(this.toolBarManager);
    }

    private final class CopyHandler
    extends AbstractHandler {
        private final ISelectionChangedListener tableSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CopyHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)CopyHandler.this, true, false));
            }
        };

        public CopyHandler() {
            ResourcesTable.this.tableViewer.addSelectionChangedListener(this.tableSelectionListener);
        }

        public void dispose() {
            super.dispose();
            ResourcesTable.this.tableViewer.removeSelectionChangedListener(this.tableSelectionListener);
        }

        public boolean isEnabled() {
            return !ResourcesTable.this.tableViewer.getSelection().isEmpty() && ResourcesTable.this.isCurrentSelectionLoaded();
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IStructuredSelection selection = (IStructuredSelection)ResourcesTable.this.tableViewer.getSelection();
            String[][] data = ResourcesTable.this.legacyTableManager.getSelectionData();
            CopyCICSObjectHelper.setClipboardContent((String)ResourcesTable.this.getElementTypeService().getElementType().getResourceTableName(), (IStructuredSelection)selection, (String[][])data);
            return null;
        }
    }

    protected final class DelegateBaseContextProvider
    extends BaseContextProvider {
        private IBaseContextProvider delegate;
        private IBaseContextProvider.Listener listener;

        protected DelegateBaseContextProvider() {
        }

        public void setDelegate(IBaseContextProvider delegate) {
            if (this.listener != null) {
                this.listener.makeStale();
            }
            if (this.delegate != null) {
                this.delegate.dispose();
            }
            this.delegate = delegate;
            this.listener = new IBaseContextProvider.Listener(){

                public void event(IBaseContextProvider.ContextChangedEvent event) {
                    DelegateBaseContextProvider.this.notifyContextChanged(event.getContext(), event.getDescription());
                }
            };
            this.delegate.addListener(this.listener);
            this.notifyContextChanged(delegate.getContext(), delegate.getDescription());
        }

        public IContext getContext() {
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.getContext();
        }

        public String getDescription() {
            if (this.delegate == null) {
                return CommonMessages.ResourcesView_statusNoContext;
            }
            return this.delegate.getDescription();
        }

        public void dispose() {
            if (this.delegate != null) {
                this.delegate.dispose();
            }
            super.dispose();
        }
    }

    private static class ResourcesTableConnectionServiceListener
    extends ConnectionServiceListener {
        private ResourcesTable table;

        public ResourcesTableConnectionServiceListener(ResourcesTable table) {
            this.table = table;
        }

        public synchronized void makeStale() {
            super.makeStale();
            this.table = null;
        }

        public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
            if (this.table.connectionCategoryId.equals(event.getConnectionCategoryId())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (table != null) {
                            if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                table.connected(event.getConnectable());
                            } else if (event instanceof ConnectionServiceListener.ConnectingEvent) {
                                table.connecting(event.getConnectable());
                            } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                                table.disconnecting(event.getConnectable());
                            } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                table.disconnected(event.getConnectable());
                            } else if (event instanceof ConnectionServiceListener.ExceptionEvent && ((ConnectionServiceListener.ExceptionEvent)event).getException() != null) {
                                table.exception(event.getConnectable(), ((ConnectionServiceListener.ExceptionEvent)event).getException());
                            }
                        }
                    }
                });
            }
        }
    }

    final class SortListener
    implements SortManager.SortListener {
        SortListener() {
        }

        @Override
        public void preSort(List<SortManager.SortData> sortDatas) {
            boolean allowSort = false;
            IContext orderedContext = ResourcesTable.this.applySort(sortDatas, (IContext)new Context(null));
            if (ResourcesTable.this.getCPSM() != null) {
                allowSort = ResourcesTable.this.getCPSM().checkPermission(ICICSOperation.GET, ResourcesTable.this.getElementTypeService().getElementType(), orderedContext);
            }
            if (!allowSort) {
                ResourcesTable.this.getSortManager().vetoSort();
            }
        }

        @Override
        public void postSort(List<SortManager.SortData> sortDatas) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourcesTable.this.setDirty();
                    ResourcesTable.this.maybeSetInput();
                }
            });
        }
    }
}

