/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.ElementTypeServiceImpl;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.SortManager;
import com.ibm.cics.explorer.tables.ui.IBaseContextProvider;
import com.ibm.cics.explorer.tables.ui.internal.InternalTablesUIPlugin;
import com.ibm.cics.explorer.tables.ui.internal.SelectionContextProvider;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class ResourcesView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String IPROPERTY_DESCRIPTOR = "org.eclipse.ui.views.properties.IPropertyDescriptor";
    @Deprecated
    public static final Integer NO_WIDTH_SPECIFIED = new Integer(-1);
    protected ResourcesTable resourcesTable;
    private IHandler refreshCommandHandler;
    private IPartListener2 partListener;
    protected static final int COLUMN_WEIGHT = 1;
    protected static final int COLUMN_MIN_WIDTH = 75;
    private static final com.ibm.cics.common.util.Debug debug = new com.ibm.cics.common.util.Debug(ResourcesView.class);

    public ResourcesView(ICICSType<?> cicsType) {
        this(new ElementTypeServiceImpl(cicsType));
    }

    public ResourcesView(IElementTypeService elementTypeService) {
        IDefaultColumnsProvider defaultColumnsProvider = new IDefaultColumnsProvider(){

            @Override
            public List<ICICSAttribute<?>> getDefaultColumns() {
                return ResourcesView.this.getDefaultColumns();
            }
        };
        this.resourcesTable = this.createResourcesTable(elementTypeService, defaultColumnsProvider, this.isMultiSelect());
        elementTypeService.addElementTypeServiceListener(new IElementTypeService.ElementTypeServiceListener(){

            public void event(IElementTypeService.Event event) {
                ResourcesView.this.resourcesTable.setBaseContextProvider(ResourcesView.this.createBaseContextProvider());
            }
        });
    }

    private ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, boolean multiSelect) {
        return this.createResourcesTable(elementTypeService, defaultColumnsProvider, "com.ibm.cics.sm.connection", multiSelect);
    }

    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new ResourcesTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
    }

    protected IBaseContextProvider createBaseContextProvider() {
        return new SelectionContextProvider(InternalTablesUIPlugin.getDefault().getNavigationProvider(), this.resourcesTable.getElementTypeService().getElementType(), (IWorkbenchPart)this);
    }

    ICICSType<?> getElementType() {
        return this.resourcesTable.getElementTypeService().getElementType();
    }

    protected Class<? extends IContext> getContextType() {
        return IContext.class;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        debug.enter("init", (Object)this, (Object)site);
        this.resourcesTable.setBaseContextProvider(this.createBaseContextProvider());
        this.setTitleToolTip(this.getTitle());
        final IActionBars actionBars = this.getViewSite().getActionBars();
        final IToolBarManager actionBarsManager = actionBars.getToolBarManager();
        IToolBarManager toolBarManager = (IToolBarManager)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IToolBarManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method method, Object[] args) throws Throwable {
                Object toReturn = method.invoke((Object)actionBarsManager, args);
                if ("update".equals(method.getName())) {
                    actionBars.updateActionBars();
                }
                return toReturn;
            }
        });
        this.resourcesTable.init((IWorkbenchPartSite)site, toolBarManager, site.getActionBars().getMenuManager(), site.getActionBars().getStatusLineManager(), !this.isSecondaryView());
        this.refreshCommandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                ResourcesView.this.resourcesTable.refresh();
                return null;
            }
        };
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.refresh", this.refreshCommandHandler);
        debug.exit("init");
    }

    public ResourcesTable getResourcesTable() {
        return this.resourcesTable;
    }

    private boolean isSecondaryView() {
        return this.getViewSite().getSecondaryId() != null;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.resourcesTable.getElementTypeService().getElementType() + "]";
    }

    protected List<ICICSAttribute<?>> getDefaultColumns() {
        ICICSType<?> type = this.resourcesTable.getElementTypeService().getElementType();
        String cicsNameOfNameAttribute = type.getNameAttribute();
        ICICSAttribute attribute = type.findAttributeByCicsName(cicsNameOfNameAttribute);
        return Arrays.asList(attribute);
    }

    public List<ICICSObjectPropertyDescriptor> getCurrentColumnData() {
        TableColumn[] columns = this.resourcesTable.getTableViewer().getTable().getColumns();
        int[] order = this.resourcesTable.getTableViewer().getTable().getColumnOrder();
        ArrayList<ICICSObjectPropertyDescriptor> columnsString = new ArrayList<ICICSObjectPropertyDescriptor>(columns.length);
        int[] nArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            int columnNumber = nArray[n2];
            IPropertyDescriptor descriptor = (IPropertyDescriptor)columns[columnNumber].getData(IPROPERTY_DESCRIPTOR);
            if (descriptor instanceof ICICSObjectPropertyDescriptor) {
                columnsString.add((ICICSObjectPropertyDescriptor)descriptor);
            } else {
                debug.warning("getCurrentColumnData", (Object)("Column didn't contain IPropertyDescriptor data: " + columns[columnNumber]));
            }
            ++n2;
        }
        return columnsString;
    }

    public boolean requestSort(ICICSObjectPropertyDescriptor sortColumnDescriptor) {
        return this.resourcesTable.getSortManager().requestSort(sortColumnDescriptor.getId());
    }

    public List<SortManager.SortData> getSortData() {
        return this.resourcesTable.getSortManager().getSortData();
    }

    public void clearSort() {
        this.resourcesTable.getSortManager().clearSort();
    }

    public void setViewName(String title) {
        this.setPartName(title);
    }

    void setCurrentColumnData(List<ICICSAttribute<?>> attributes) {
        this.resourcesTable.getTableManager().setColumns(attributes);
    }

    public ICICSType<?> getCICSType() {
        return this.resourcesTable.getElementTypeService().getElementType();
    }

    public void createPartControl(Composite parent) {
        debug.enter("createPartControl", (Object)this, (Object)parent);
        this.resourcesTable.createControl(parent);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.resourcesTable.getTableViewer());
        this.addListeners((StructuredViewer)this.resourcesTable.getTableViewer());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        debug.exit("createPartControl");
    }

    public void setContentDescription(String description) {
        this.resourcesTable.setContentDescription(description);
    }

    protected abstract String getHelpContextId();

    public void setFocus() {
        this.resourcesTable.getTableViewer().getControl().setFocus();
    }

    protected boolean isMultiSelect() {
        return true;
    }

    protected void addListeners(StructuredViewer viewer) {
        debug.enter("addListeners", (Object)this, (Object)viewer);
        this.resourcesTable.opened();
        this.resourcesTable.visible(true);
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesView.this) {
                    debug.event("partActivated", (Object)ResourcesView.this, (Object)partRef.getPartName());
                    ResourcesView.this.resourcesTable.maybeSetInput();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesView.this) {
                    if (Debug.DEBUG_SELECTION) {
                        debug.event("partClosed()", "partRef=" + partRef.getPartName());
                    }
                    ResourcesView.this.closed();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesView.this) {
                    debug.event("partDeactivated", (Object)ResourcesView.this, (Object)partRef.getPartName());
                    ResourcesView.this.resourcesTable.clearStatusMessage();
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesView.this) {
                    debug.event("partHidden", (Object)ResourcesView.this, (Object)partRef.getPartName());
                    ResourcesView.this.resourcesTable.visible(false);
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesView.this) {
                    debug.event("partVisible", (Object)ResourcesView.this, (Object)partRef.getPartName());
                    ResourcesView.this.resourcesTable.visible(true);
                }
            }
        };
        this.getSite().getPage().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        debug.exit("addListeners");
    }

    protected void removeListeners() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
        }
    }

    protected void closed() {
        this.removeListeners();
    }

    protected void schedule(Job job) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    protected boolean forceDisableSortRequired() {
        String implName = ((Object)((Object)this)).getClass().getCanonicalName();
        return "com.ibm.ctg.ui.views.GatewaysView".equals(implName) || "com.ibm.ctg.ui.views.ConnectionsView".equals(implName);
    }

    public IContext getContext() {
        return this.resourcesTable.getBaseContextProvider().getContext();
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.sm.connection";
        }
        return super.getPartProperty(key);
    }

    protected void setSortColumn(Table table, Object id, boolean direction) {
        this.resourcesTable.getTableManager().setSortColumn(id, direction);
    }
}

