/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.flhsupport.FLHSupport;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptorComparator;
import com.ibm.cics.core.ui.properties.CICSTypePropertySource;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.ColumnDialog;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.PreferenceService;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResourcesViewColumnDialog
extends ColumnDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.core.ui.views.columns";
    private static final String NAME = "NAME";
    protected static ICICSType<?> currentType;
    private List<IPropertyDescriptor> currentlyUsedPropertyDescriptors = new ArrayList<IPropertyDescriptor>();
    private ArrayList<IPropertyDescriptor> availableColumnsPropertyDescriptors = new ArrayList();
    private CICSTypePropertySource propertySource;
    private LegacyTableManager legacyTableManager;
    private PreferenceService preferenceService;

    public ResourcesViewColumnDialog(Shell parentShell, CICSTypePropertySource propertySource, LegacyTableManager legacyTableManager, PreferenceService preferenceService) {
        super(parentShell);
        this.preferenceService = preferenceService;
        Debug.enter((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)parentShell, (Object)propertySource, (Object)legacyTableManager);
        this.legacyTableManager = legacyTableManager;
        this.propertySource = propertySource;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.initialize();
        HelpListener helpListener = new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
            }
        };
        this.availableColumnsTree.addHelpListener(helpListener);
        this.currentlyUsedColumnsTree.addHelpListener(helpListener);
        return c;
    }

    private void showHelpForTableItem(TypedEvent e) {
        if (e.widget instanceof FilteredTree) {
            FilteredTree tree = (FilteredTree)e.widget;
            if (tree.getViewer().getTree().getSelectionCount() > 0) {
                TreeItem ti = tree.getViewer().getTree().getSelection()[0];
                IPropertyDescriptor pd = (IPropertyDescriptor)ti.getData();
                FLHSupport.showHelp((String)pd.getHelpContextIds());
            } else {
                FLHSupport.showHelp("com.ibm.cics.core.ui.dialog_ResourcesViewColumnDialog");
            }
        }
    }

    private boolean hasColumnsToRemove() {
        if (this.currentlyUsedColumnsTreeViewer.getTree().getSelectionCount() >= 2) {
            return true;
        }
        if (this.currentlyUsedColumnsTreeViewer.getTree().getSelectionCount() == 1) {
            return !NAME.equalsIgnoreCase((String)((IPropertyDescriptor)this.currentlyUsedColumnsTreeViewer.getTree().getSelection()[0].getData()).getId());
        }
        return false;
    }

    void addSelectedColumn() {
        IStructuredSelection selectedItems = (IStructuredSelection)this.availableColumnsTreeViewer.getSelection();
        List propertyDescriptors = selectedItems.toList();
        for (IPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.addCurrentlyUsedDescriptor(propertyDescriptor);
            this.removeAvailableDescriptor(propertyDescriptor);
            ICICSAttribute attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
            this.legacyTableManager.addColumn(attribute);
        }
        this.addButton.setEnabled(false);
    }

    void removeSelectedColumn() {
        IStructuredSelection selectedItems = (IStructuredSelection)this.currentlyUsedColumnsTreeViewer.getSelection();
        List propertyDescriptors = selectedItems.toList();
        for (IPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (NAME.equalsIgnoreCase((String)propertyDescriptor.getId())) continue;
            this.removeCurrentlyUsedDescriptor(propertyDescriptor);
            ICICSAttribute attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
            this.legacyTableManager.removeColumn(attribute);
            this.addAvailableDescriptor(propertyDescriptor);
        }
        this.removeButton.setEnabled(false);
    }

    private void initialize() {
        List<LegacyTableManager.ColumnData> columns = this.legacyTableManager.getColumnData();
        this.currentlyUsedPropertyDescriptors.clear();
        for (LegacyTableManager.ColumnData column : columns) {
            IAttributePropertyDescriptor propertyDescriptor = this.propertySource.getPropertyDescriptor((Object)((ICICSAttribute)column.id).getPropertyId());
            this.addCurrentlyUsedDescriptor((IPropertyDescriptor)propertyDescriptor);
        }
        this.refreshAvailablePropertyDescriptors();
        this.currentlyUsedColumnsTreeViewer.refresh();
        this.availableColumnsTreeViewer.refresh();
    }

    private void refreshAvailablePropertyDescriptors() {
        IPropertyDescriptor[] propertyDescriptors = (IPropertyDescriptor[])this.propertySource.getPropertyDescriptors().clone();
        Arrays.sort(propertyDescriptors, new CICSObjectPropertyDescriptorComparator());
        IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
            if (!this.currentlyUsedPropertyDescriptors.contains(propertyDescriptor)) {
                this.availableColumnsPropertyDescriptors.add(propertyDescriptor);
            }
            ++n2;
        }
    }

    private void addCurrentlyUsedDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.currentlyUsedPropertyDescriptors.add(propertyDescriptor);
        this.currentlyUsedColumnsTreeViewer.refresh(true);
    }

    private void removeCurrentlyUsedDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.currentlyUsedPropertyDescriptors.remove(propertyDescriptor);
        this.currentlyUsedColumnsTreeViewer.refresh(true);
    }

    private void addAvailableDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.availableColumnsPropertyDescriptors.add(propertyDescriptor);
        Collections.sort(this.availableColumnsPropertyDescriptors, new CICSObjectPropertyDescriptorComparator());
        this.availableColumnsTreeViewer.refresh(true);
    }

    private void removeAvailableDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.availableColumnsPropertyDescriptors.remove(propertyDescriptor);
        this.availableColumnsTreeViewer.refresh(true);
    }

    @Override
    public void reset() {
        this.preferenceService.resetColumns();
        this.availableColumnsPropertyDescriptors.clear();
        this.currentlyUsedPropertyDescriptors.clear();
        this.initialize();
    }

    @Override
    public String getViewTitle() {
        return Messages.getString("ResourcesViewColumnDialog.customiseColumns", this.propertySource.getCICSType().getResourceTableName());
    }

    @Override
    public String getAvailableAttributesString() {
        return Messages.getString("ResourcesViewColumnDialog.availableAttributes", new Object[0]);
    }

    @Override
    public String getCurrentlyUsedAttributesString() {
        return Messages.getString("ResourcesViewColumnDialog.currentViewerColumns", new Object[0]);
    }

    @Override
    public ITreeContentProvider getAvailableTreeContentProvider() {
        return new ColumnDialog.FlatTreeContentProvider(this){

            public Object[] getElements(Object inputElement) {
                return ResourcesViewColumnDialog.this.availableColumnsPropertyDescriptors.toArray();
            }
        };
    }

    @Override
    public ITreeContentProvider getCurrentlyUsedTreeContentProvider() {
        return new ColumnDialog.FlatTreeContentProvider(this){

            public Object[] getElements(Object inputElement) {
                return ResourcesViewColumnDialog.this.currentlyUsedPropertyDescriptors.toArray();
            }
        };
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPropertyDescriptor) {
                    return ((IPropertyDescriptor)element).getDisplayName();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        };
    }

    @Override
    public Object getAvailableTreeInput() {
        return this.availableColumnsPropertyDescriptors;
    }

    @Override
    public Object getCurrentlyUsedTreeInput() {
        return this.currentlyUsedPropertyDescriptors;
    }

    @Override
    public String getAddButtonText() {
        return String.valueOf(Messages.getString("ResourcesViewColumnDialog.add", new Object[0])) + " -->";
    }

    @Override
    public String getRemoveButtonText() {
        return "<-- " + Messages.getString("ResourcesViewColumnDialog.remove", new Object[0]);
    }

    @Override
    public SelectionAdapter getAvailableSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addButton.setEnabled(!ResourcesViewColumnDialog.this.availableColumnsTreeViewer.getSelection().isEmpty());
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        };
    }

    @Override
    public SelectionAdapter getCurrentlyUsedSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeButton.setEnabled(ResourcesViewColumnDialog.this.hasColumnsToRemove());
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        };
    }

    @Override
    public SelectionAdapter getAddButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        };
    }

    @Override
    public SelectionAdapter getRemoveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        };
    }
}

