/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.Scheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class SortManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.core.ui.views");
    private static final boolean INITIAL_SORT_ORDER = true;
    private static final long SORT_DELAY = 500L;
    private final LegacyTableManager legacyTableManager;
    private final int maxSortDepth;
    private final IAction clearSortAction;
    private List<SortData> sortDatas = new ArrayList<SortData>();
    private final Set<SortListener> sortListeners = new HashSet<SortListener>();
    private boolean sortVeto = false;
    private final Scheduler sortUpdateScheduler = new Scheduler(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = SortManager.this.sortListeners;
            synchronized (set) {
                for (SortListener l : SortManager.this.sortListeners) {
                    l.postSort(SortManager.this.sortDatas);
                }
            }
        }
    }, 500L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addListener(SortListener l) {
        Set<SortListener> set = this.sortListeners;
        synchronized (set) {
            this.sortListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(SortListener l) {
        boolean ret = false;
        Set<SortListener> set = this.sortListeners;
        synchronized (set) {
            ret = this.sortListeners.remove(l);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPreSort(List<SortData> datas) {
        Set<SortListener> set = this.sortListeners;
        synchronized (set) {
            for (SortListener l : this.sortListeners) {
                l.preSort(datas);
            }
        }
    }

    private void notifyPostSort() {
        SortData sortData;
        SortData sortData2 = sortData = this.sortDatas.size() > 0 ? this.sortDatas.get(this.sortDatas.size() - 1) : null;
        if (sortData != null) {
            Object id = sortData.getId();
            this.legacyTableManager.setSortColumn(id, sortData.getDirection());
        } else {
            this.legacyTableManager.setSortColumn(null, true);
        }
        if (this.sortDatas.size() > 0) {
            this.clearSortAction.setEnabled(true);
        } else {
            this.clearSortAction.setEnabled(false);
        }
        this.sortUpdateScheduler.scheduleUpdate();
    }

    public SortManager(LegacyTableManager legacyTableManager, int maxSortDepth) {
        this.legacyTableManager = legacyTableManager;
        this.maxSortDepth = maxSortDepth;
        legacyTableManager.addListener(new LegacyTableManager.Listener(){

            public void event(LegacyTableManager.Event event) {
                if (event instanceof LegacyTableManager.ColumnRemovedEvent) {
                    SortManager.this.remove(((LegacyTableManager.ColumnRemovedEvent)event).getColumnId());
                } else if (event instanceof LegacyTableManager.SortRequestedEvent) {
                    SortManager.this.requestSort(((LegacyTableManager.SortRequestedEvent)event).getColumnId());
                }
            }
        });
        this.clearSortAction = new Action(Messages.getString("ResourcesView.clearSortAction.text", new Object[0])){

            public void run() {
                SortManager.this.clearSort();
            }
        };
        this.clearSortAction.setToolTipText(Messages.getString("ResourcesView.clearSortAction.tooltip", new Object[0]));
        this.clearSortAction.setImageDescriptor(UIPlugin.IMGD_DELETE_SORT);
        this.clearSortAction.setEnabled(false);
    }

    private SortData findSortDataInList(Object id, List<SortData> sortDatas) {
        for (SortData sd : sortDatas) {
            if (!sd.getId().equals(id)) continue;
            return sd;
        }
        return null;
    }

    public synchronized boolean requestSort(Object id) {
        Debug.enter((Logger)logger, (String)this.getClass().getSimpleName(), (String)"requestSort", (Object)id);
        ArrayList<SortData> proposedSortDatas = new ArrayList<SortData>();
        proposedSortDatas.addAll(this.sortDatas);
        SortData sd = this.findSortDataInList(id, proposedSortDatas);
        boolean isNewestSortAlready = proposedSortDatas.size() > 0 ? ((SortData)proposedSortDatas.get(proposedSortDatas.size() - 1)).equals(sd) : false;
        SortData newSd = null;
        if (sd == null || !isNewestSortAlready) {
            newSd = new SortData(id, true);
        } else if (isNewestSortAlready && sd.getDirection()) {
            newSd = new SortData(id, false);
        }
        Debug.event((Logger)logger, (String)this.getClass().getSimpleName(), (String)"requestSort", (Object)newSd);
        if (proposedSortDatas.size() >= this.maxSortDepth && sd == null) {
            proposedSortDatas.remove(0);
        }
        proposedSortDatas.remove(sd);
        if (newSd != null) {
            proposedSortDatas.add(newSd);
        }
        this.sortVeto = false;
        this.notifyPreSort(proposedSortDatas);
        if (!this.sortVeto) {
            this.sortDatas = new ArrayList<SortData>(proposedSortDatas);
            this.notifyPostSort();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getSimpleName(), (String)"requestSort", (Object)(!this.sortVeto ? 1 : 0));
        return !this.sortVeto;
    }

    public void clearSort() {
        ArrayList<SortData> empty = new ArrayList<SortData>();
        this.notifyPreSort(empty);
        if (!this.sortVeto) {
            this.sortDatas.clear();
        }
        this.notifyPostSort();
    }

    public List<SortData> getSortData() {
        this.sortUpdateScheduler.force();
        return this.sortDatas;
    }

    public synchronized void vetoSort() {
        this.sortVeto = true;
    }

    public void remove(Object id) {
        SortData sd = this.findSortDataInList(id, this.sortDatas);
        if (sd != null) {
            this.sortDatas.remove(sd);
        }
    }

    public IAction getClearSortAction() {
        return this.clearSortAction;
    }

    public static final class SortData {
        private final Object id;
        private final boolean direction;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.direction ? 1231 : 1237);
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortData other = (SortData)obj;
            if (this.direction != other.direction) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public SortData(Object id, boolean direction) {
            this.id = id;
            this.direction = direction;
        }

        public Object getId() {
            return this.id;
        }

        public boolean getDirection() {
            return this.direction;
        }

        public String toString() {
            return this.id + "," + this.direction;
        }
    }

    public static interface SortListener {
        public void preSort(List<SortData> var1);

        public void postSort(List<SortData> var1);
    }
}

