/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ExplorerTrustStore;
import com.ibm.cics.core.comm.Messages;
import com.ibm.cics.core.comm.SecureCertificateException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExplorerKeyStoreManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ExplorerKeyStoreManager.class);
    private static List<Provider> addedProviders = new ArrayList<Provider>();

    public static void removeAllSmartcardProviders() {
        for (Provider provider : addedProviders) {
            Security.removeProvider(provider.getName());
        }
        addedProviders.clear();
    }

    static Map<String, Provider> getWindowsSmartCardProvider() throws CertificateException {
        HashMap<String, Provider> p = new HashMap<String, Provider>();
        try {
            Class<?> ibmMSCAPI = ClassLoader.getSystemClassLoader().loadClass("com.ibm.security.capi.IBMCAC");
            Constructor<?> constructor = ibmMSCAPI.getConstructor(new Class[0]);
            p.put("Windows-MY", (Provider)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Throwable moreInfo = ExplorerKeyStoreManager.findRootCauseException(e);
            CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntConfigureIBMCAC, moreInfo);
            debug.error("getWindowsSmartCardProvider", (Throwable)ce);
            throw ce;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> sunMSCAPI = ClassLoader.getSystemClassLoader().loadClass("sun.security.mscapi.SunMSCAPI");
                Constructor<?> constructor = sunMSCAPI.getConstructor(new Class[0]);
                p.put("Windows-MY", (Provider)constructor.newInstance(new Object[0]));
            }
            catch (ClassNotFoundException cnfeSun) {
                CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntLoadCAC, cnfeSun);
                debug.error("getWindowsSmartCardProvider", (Throwable)ce);
                throw ce;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                Throwable moreInfo = ExplorerKeyStoreManager.findRootCauseException(e1);
                CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntConfigureSunCAC, moreInfo);
                debug.error("getWindowsSmartCardProvider", (Throwable)ce);
                throw ce;
            }
        }
        debug.event("getWindowsSmartCardProvider", p);
        return p;
    }

    static KeyStore getSmartcardKeyStore(Map<String, Provider> p, String pin) throws IOException, GeneralSecurityException {
        if (!p.isEmpty()) {
            Provider originalProvider;
            Map.Entry<String, Provider> provider = p.entrySet().iterator().next();
            Provider providerInstance = provider.getValue();
            if (!Arrays.asList(Security.getProviders()).contains(providerInstance)) {
                if (Security.addProvider(provider.getValue()) == -1) {
                    originalProvider = Security.getProvider(providerInstance.getName());
                    if (originalProvider != null) {
                        providerInstance = originalProvider;
                    }
                } else {
                    debug.event("getSmartcardKeyStore", (Object)provider.getKey(), (Object)provider.getValue());
                    addedProviders.add(provider.getValue());
                }
            } else {
                originalProvider = Security.getProvider(providerInstance.getName());
                if (originalProvider != null) {
                    providerInstance = originalProvider;
                }
            }
            KeyStore ks = KeyStore.getInstance(provider.getKey(), providerInstance);
            ks.load(null, pin != null ? pin.toCharArray() : null);
            return ks;
        }
        return null;
    }

    static Map<String, Provider> getPkcs11Provider(String pkcs11LibraryPath) throws CertificateException {
        HashMap<String, Provider> provider = new HashMap<String, Provider>();
        if (pkcs11LibraryPath.trim().isEmpty()) {
            CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_CouldntConfigureNoDriverPath);
            debug.error("getPkcs11Provider", (Throwable)ce);
            throw ce;
        }
        String config = "library = " + pkcs11LibraryPath + "\nname = Smartcard\n";
        try {
            Class<?> ibmPkcs11 = ClassLoader.getSystemClassLoader().loadClass("com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(config));
            Constructor<?> constructor = ibmPkcs11.getConstructor(BufferedReader.class);
            Provider p = (Provider)constructor.newInstance(bufferedReader);
            provider.put("PKCS11IMPLKS", p);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Throwable moreInfo = ExplorerKeyStoreManager.findRootCauseException(e);
            CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntConfigureIBMPKCS11, moreInfo);
            debug.error("getPkcs11Provider", (Throwable)ce);
            throw ce;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> sunPkcs11 = ClassLoader.getSystemClassLoader().loadClass("sun.security.pkcs11.SunPKCS11");
                ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
                Constructor<?> constructor = sunPkcs11.getConstructor(InputStream.class);
                Provider p = (Provider)constructor.newInstance(bais);
                provider.put("PKCS11", p);
            }
            catch (ClassNotFoundException cnfeSun) {
                CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntLoadPKCS11, cnfeSun);
                debug.error("getPkcs11Provider", (Throwable)ce);
                throw ce;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                Throwable moreInfo = ExplorerKeyStoreManager.findRootCauseException(e1);
                CertificateException ce = new CertificateException(Messages.ExplorerKeyStoreManager_couldntConfigureSunPKCS11, moreInfo);
                debug.error("getPkcs11Provider", (Throwable)ce);
                throw ce;
            }
        }
        debug.event("getPkcs11Provider", provider);
        return provider;
    }

    private static Throwable findRootCauseException(Throwable t) {
        Throwable moreInfo = t;
        if (t instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)t;
            if (ite.getTargetException() != null) {
                moreInfo = ite.getTargetException();
            }
        } else if (t.getCause() != null) {
            moreInfo = t.getCause();
        }
        if (moreInfo != t) {
            moreInfo = ExplorerKeyStoreManager.findRootCauseException(moreInfo);
        }
        return moreInfo;
    }

    public static String validateCanWriteTrustStore(String dbType, String tsfileString, String tspassPhrase) {
        String response;
        block7: {
            debug.enter("validateTrustStoreDetail");
            response = "";
            try {
                KeyStore ts1 = KeyStore.getInstance(dbType);
                ts1.load(new FileInputStream(tsfileString), tspassPhrase.toCharArray());
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                defaultTrustManagerFactory.init(ts1);
                File f = new File(tsfileString);
                if (!f.canWrite()) {
                    f.setWritable(true);
                    ts1.store(new FileOutputStream(tsfileString), tspassPhrase.toCharArray());
                    f.setWritable(false);
                } else {
                    ts1.store(new FileOutputStream(tsfileString), tspassPhrase.toCharArray());
                }
            }
            catch (GeneralSecurityException gsex) {
                response = gsex.getMessage();
            }
            catch (FileNotFoundException ex) {
                response = ex.getMessage();
                if (response.length() == 0) {
                    response = ex.toString();
                }
            }
            catch (IOException fnfe) {
                response = fnfe.getMessage();
                if (!response.startsWith("DerInputStream")) break block7;
                response = String.valueOf(response) + "- possible invalid DB type";
            }
        }
        debug.exit("validateTrustStoreDetail", (Object)response);
        return response;
    }

    public static String validateKeyAndTrustStore(String tsfileString, String tspassPhrase, String tsdbType, String ksfileString, String kspassPhrase, String ksdbType) {
        String response;
        block9: {
            debug.enter("validateStoreDetail");
            response = "";
            try {
                KeyStore ts1 = KeyStore.getInstance(tsdbType);
                ts1.load(new FileInputStream(tsfileString), tspassPhrase.toCharArray());
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                defaultTrustManagerFactory.init(ts1);
                if (ts1.size() == 0) {
                    throw new IOException("Invalid_store_format_message");
                }
            }
            catch (GeneralSecurityException gsex) {
                response = gsex.getMessage();
            }
            catch (FileNotFoundException ex) {
                response = ex.getMessage();
                if (response.length() == 0) {
                    response = ex.toString();
                }
            }
            catch (EOFException fnfe) {
                response = fnfe.getMessage();
                if (!StringUtil.hasContent((String)response)) {
                    response = fnfe.toString();
                }
            }
            catch (IOException ioe) {
                response = ioe.getMessage();
                if (response.length() != 0) break block9;
                response = ioe.toString();
            }
        }
        if (response.isEmpty() && !ksfileString.isEmpty()) {
            response = ExplorerKeyStoreManager.validateKeyStore(ksfileString, kspassPhrase, ksdbType);
        }
        debug.exit("validateStoreDetail", (Object)response);
        return response;
    }

    public static String validateKeyStore(String ksfileString, String kspassPhrase, String ksdbType) {
        String response;
        block8: {
            response = "";
            try {
                KeyStore ks1 = KeyStore.getInstance(ksdbType);
                ks1.load(new FileInputStream(ksfileString), kspassPhrase.toCharArray());
                KeyManagerFactory defaultKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                defaultKeyManagerFactory.init(ks1, kspassPhrase.toCharArray());
                if (ks1.size() == 0) {
                    throw new IOException("Invalid_store_format_message");
                }
            }
            catch (GeneralSecurityException gsex) {
                response = gsex.getMessage();
            }
            catch (FileNotFoundException ex) {
                response = ex.getMessage();
                if (response.length() == 0) {
                    response = ex.toString();
                }
            }
            catch (EOFException fnfe) {
                response = fnfe.getMessage();
                if (!StringUtil.hasContent((String)response)) {
                    response = fnfe.toString();
                }
            }
            catch (IOException ioe) {
                response = ioe.getMessage();
                if (response.length() != 0) break block8;
                response = ioe.toString();
            }
        }
        return response;
    }

    public static X509TrustManager getTrustManager(final String name, final String host, final ExplorerTrustStore trustStore) {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                debug.enter("checkClientTrusted", (Object)chain, (Object)authType);
                trustStore.getTrustManager().checkClientTrusted(chain, authType);
                debug.exit("checkClientTrusted");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                debug.enter("checkServerTrusted", (Object)chain, (Object)authType);
                try {
                    trustStore.getTrustManager().checkServerTrusted(chain, authType);
                }
                catch (CertificateException cex) {
                    throw new SecureCertificateException(cex, chain, name, host);
                }
                debug.exit("checkServerTrusted");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                debug.enter("getAcceptedIssuers");
                X509Certificate[] resp = new X509Certificate[]{};
                resp = trustStore.getTrustManager().getAcceptedIssuers();
                debug.exit("getAcceptedIssuers", (Object)resp);
                return resp;
            }
        };
    }
}

