/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm.internal;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ConnectionDescriptor
implements IConnectionDescriptor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_ATTRIBUTE = "attribute";
    private static final String ATT_ATTRIBUTE_KEY = "key";
    private static final String ATT_ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
    private static final String ATT_REFID = "refid";
    private static final String ATT_SSL_ENABLED = "ssl_enabled";
    private static final String ATT_CERTIFICATE_AUTH = "certificate_auth";
    private static final String ATT_MFA_AUTH = "mfa_auth";
    private static final String ATT_TYPE = "type";
    private static final String ATT_TRANSIENT = "transient";
    private static final String ATT_FACTORY = "factory";
    private static final String TAG_CHILD_CATEGORY = "child-category";
    private IConfigurationElement element;
    private String id;
    private String name;
    private IConnectionCategory category;
    private List<IConnectionDescriptor.ExtendedAttribute> extendedAttributes = Collections.emptyList();
    private List<String> childCategories = Collections.emptyList();
    private String contributor;
    private boolean ssl;
    private boolean certificate;
    private boolean mfa;
    private String categoryString;
    private boolean isTransient;
    private boolean isFactory;

    public void setConfigurationElement(IConfigurationElement configurationElement) {
        this.element = configurationElement;
        this.id = this.element.getAttribute(ATT_ID);
        this.name = this.element.getAttribute(ATT_NAME);
        this.categoryString = this.element.getAttribute(ATT_CATEGORY);
        this.ssl = Boolean.parseBoolean(this.element.getAttribute(ATT_SSL_ENABLED));
        this.certificate = Boolean.parseBoolean(this.element.getAttribute(ATT_CERTIFICATE_AUTH));
        this.mfa = Boolean.parseBoolean(this.element.getAttribute(ATT_MFA_AUTH));
        this.isTransient = Boolean.parseBoolean(this.element.getAttribute(ATT_TRANSIENT));
        this.isFactory = Boolean.parseBoolean(this.element.getAttribute(ATT_FACTORY));
        this.contributor = configurationElement.getContributor().getName();
        IConfigurationElement[] childrenAttributes = this.element.getChildren(ATT_ATTRIBUTE);
        int i = 0;
        while (i < childrenAttributes.length) {
            IConfigurationElement child = childrenAttributes[i];
            String typeString = child.getAttribute(ATT_TYPE);
            IConnectionDescriptor.ExtendedAttributeType type = "connectionId".equals(typeString) ? IConnectionDescriptor.ExtendedAttributeType.CONNECTION_ID : IConnectionDescriptor.ExtendedAttributeType.STRING;
            ExtendedAttributeImpl extendedAttribute = new ExtendedAttributeImpl(child.getAttribute(ATT_ATTRIBUTE_KEY), child.getAttribute(ATT_ATTRIBUTE_DEFAULT_VALUE), type);
            if (this.extendedAttributes.isEmpty()) {
                this.extendedAttributes = new ArrayList<IConnectionDescriptor.ExtendedAttribute>(2);
            }
            this.extendedAttributes.add(extendedAttribute);
            ++i;
        }
        IConfigurationElement[] childrenCategories = this.element.getChildren(TAG_CHILD_CATEGORY);
        int i2 = 0;
        while (i2 < childrenCategories.length) {
            String childCategoryId = childrenCategories[i2].getAttribute(ATT_REFID);
            if (this.childCategories.size() == 0) {
                this.childCategories = new ArrayList<String>(1);
            }
            this.childCategories.add(childCategoryId);
            ++i2;
        }
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IConnectionCategory getCategory() {
        if (this.category == null) {
            this.category = ConnectionRegistry.getConnectionRegistry().findCategory(this.categoryString);
            if (this.category == null) {
                throw new IllegalArgumentException("Unknown category: " + this.categoryString);
            }
        }
        return this.category;
    }

    @Override
    public boolean isSSLEnabled() {
        return this.ssl;
    }

    @Override
    public boolean isCertificateAuth() {
        return this.certificate;
    }

    @Override
    public boolean isMFAAuth() {
        return this.mfa;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.name + ", " + this.id + "]";
    }

    @Override
    public List<IConnectionDescriptor.ExtendedAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    @Override
    public IConnectionDescriptor.ExtendedAttribute getExtendedAttribute(String nameOfExtendedAttribute) {
        for (IConnectionDescriptor.ExtendedAttribute extendedAttribute : this.extendedAttributes) {
            if (!extendedAttribute.getKey().equals(nameOfExtendedAttribute)) continue;
            return extendedAttribute;
        }
        return null;
    }

    @Override
    public List<String> getChildCategories() {
        return this.childCategories;
    }

    @Override
    public IConnection createConnection() throws ConnectionException {
        try {
            return (IConnection)this.getElement().createExecutableExtension("class");
        }
        catch (CoreException ex) {
            throw new ConnectionException((Exception)((Object)ex));
        }
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isFactory() {
        return this.isFactory;
    }

    private static class ExtendedAttributeImpl
    implements IConnectionDescriptor.ExtendedAttribute {
        private String key;
        private String defaultValue;
        private IConnectionDescriptor.ExtendedAttributeType type;

        ExtendedAttributeImpl(String key, String defaultValue, IConnectionDescriptor.ExtendedAttributeType type) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }

        @Override
        public IConnectionDescriptor.ExtendedAttributeType getType() {
            return this.type;
        }
    }
}

