/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.FieldReflectionUtility;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSObjectPrimaryKey;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMConfigurationDefinition;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.ICSDDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCICSType<T extends ICICSObject>
implements ICICSType<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Class<T> interfaceType;
    private final Class<? extends T> implementationType;
    private final String tableName;
    private final Class<? extends T> mutableImplementation;
    private final Class<? extends T> mutableInterface;
    private Class<? extends ICICSObjectReference<T>> referenceType;
    private final String nameAttribute;
    private final CICSRelease validFrom;
    private final CICSRelease validTo;
    private final LinkedHashSet<ICICSAttribute<?>> keyAttributes;

    AbstractCICSType(Class<? extends T> implementationType, Class<T> interfaceType, Class<? extends ICICSObjectReference<T>> referenceType, String tableName, String nameAttribute, ICICSAttribute<?>[] keyAttributes, CICSRelease validFrom, CICSRelease validTo) {
        this(implementationType, interfaceType, referenceType, tableName, null, null, nameAttribute, keyAttributes, validFrom, validTo);
    }

    @Deprecated
    protected AbstractCICSType(Class<? extends T> implementationType, Class<T> interfaceType, String tableName, Class<? extends T> mutableImplementation, Class<? extends T> mutableInterface, String nameAttribute, ICICSAttribute<?>[] keyAttributes, CICSRelease validFrom, CICSRelease validTo) {
        this(implementationType, interfaceType, null, tableName, mutableImplementation, mutableInterface, nameAttribute, keyAttributes, validFrom, validTo);
    }

    protected AbstractCICSType(Class<? extends T> implementationType, Class<T> interfaceType, Class<? extends ICICSObjectReference<T>> referenceType, String tableName, Class<? extends T> mutableImplementation, Class<? extends T> mutableInterface, String nameAttribute, ICICSAttribute<?>[] keyAttributes, CICSRelease validFrom, CICSRelease validTo) {
        this.implementationType = implementationType;
        if (implementationType.isInterface()) {
            throw new IllegalArgumentException("Is an interface: " + implementationType);
        }
        this.interfaceType = interfaceType;
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException("not an interface: " + interfaceType);
        }
        this.referenceType = referenceType;
        if (referenceType != null && !referenceType.isInterface()) {
            throw new IllegalArgumentException("not an interface: " + referenceType);
        }
        this.tableName = tableName;
        this.mutableImplementation = mutableImplementation;
        this.mutableInterface = mutableInterface;
        if (mutableInterface != null && !mutableInterface.isInterface()) {
            throw new IllegalArgumentException("not an interface" + mutableInterface);
        }
        this.nameAttribute = nameAttribute;
        LinkedHashSet keyAttributesSet = new LinkedHashSet();
        ICICSAttribute<?>[] iCICSAttributeArray = keyAttributes;
        int n = keyAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSAttribute<?> attribute = iCICSAttributeArray[n2];
            keyAttributesSet.add(attribute);
            ++n2;
        }
        this.keyAttributes = keyAttributesSet;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    public Class<? extends T> getImplementationType() {
        return this.implementationType;
    }

    public Class<T> getInterfaceType() {
        return this.interfaceType;
    }

    public Class<? extends ICICSObjectReference<T>> getReferenceType() {
        return this.referenceType;
    }

    public String getResourceTableName() {
        return this.tableName;
    }

    public Class<? extends T> getMutableImplementation() {
        return this.mutableImplementation;
    }

    public Class<? extends T> getMutableInterface() {
        return this.mutableInterface;
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public boolean isDefinition() {
        return ICICSDefinition.class.isAssignableFrom(this.getInterfaceType()) || ICPSMDefinition.class.isAssignableFrom(this.getInterfaceType()) || ICSDDefinition.class.isAssignableFrom(this.getInterfaceType()) || ICPSMConfigurationDefinition.class.isAssignableFrom(this.getInterfaceType());
    }

    public boolean isResource() {
        return ICICSResource.class.isAssignableFrom(this.getInterfaceType());
    }

    public boolean isCPSM() {
        return ICPSMManager.class.isAssignableFrom(this.getInterfaceType());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.implementationType.getName() + "," + this.tableName + "]";
    }

    public synchronized ICICSAttribute<?>[] attributes() {
        List attributesList = FieldReflectionUtility.getBetaAwareFieldValuesList(this.getClass(), ICICSAttribute.class);
        ICICSAttribute[] attributes = attributesList.toArray(new CICSAttribute[attributesList.size()]);
        return attributes;
    }

    public ICICSAttribute<?> findAttributeByID(String anAttibuteID) {
        ICICSAttribute<?>[] attributes = this.attributes();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getPropertyId().equals(anAttibuteID)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public ICICSAttribute<?> findAttributeByCicsName(String attributeName) {
        ICICSAttribute<?>[] attributes = this.attributes();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getCicsName().equals(attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    protected IPrimaryKey constructPrimaryKey(IContext context, Object[] values) {
        return new CICSObjectPrimaryKey(context, this.createKeyMap(values));
    }

    private Map<ICICSAttribute<?>, Object> createKeyMap(Object[] values) {
        if (this.keyAttributes.size() != values.length) {
            throw new IllegalArgumentException("Different array lengths for keys and values");
        }
        HashMap keyMap = new HashMap(this.keyAttributes.size());
        int i = 0;
        for (ICICSAttribute iCICSAttribute : this.keyAttributes) {
            keyMap.put(iCICSAttribute, values[i++]);
        }
        return keyMap;
    }

    public Set<ICICSAttribute<?>> getKeyAttributes() {
        return Collections.unmodifiableSet(this.keyAttributes);
    }

    public final CICSRelease getValidFrom() {
        return this.validFrom;
    }

    public final CICSRelease getValidTo() {
        return this.validTo;
    }

    public int compareTo(ICICSType<?> o) {
        return this.getResourceTableName().compareTo(o.getResourceTableName());
    }

    @Deprecated
    public T createBlind(ICICSObjectContainer<?> container, AttributeValueMap avm) {
        throw new UnsupportedOperationException();
    }

    public ICICSObjectReference<T> toReference(T cicsObject) {
        return null;
    }
}

