/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.AggregatedResourcesModel;
import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.model.ModelStatus;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.sm.comm.IContext;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractResourcesModel
implements IResourcesModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger(AbstractResourcesModel.class.getPackage().getName());
    private Set listeners = new HashSet();

    @Override
    public ModelStatus getStatus() {
        return ModelStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IModelListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IModelListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSizeChanged(int newSize, int newTotalSize) {
        IModelListener[] modelListeners;
        Set set = this.listeners;
        synchronized (set) {
            modelListeners = new IModelListener[this.listeners.size()];
            this.listeners.toArray(modelListeners);
        }
        int i = 0;
        while (i < modelListeners.length) {
            modelListeners[i].sizeChanged(newSize, newTotalSize);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentsChanged(int firstIndex, int lastIndex) {
        IModelListener[] modelListeners;
        Set set = this.listeners;
        synchronized (set) {
            modelListeners = new IModelListener[this.listeners.size()];
            this.listeners.toArray(modelListeners);
        }
        int i = 0;
        while (i < modelListeners.length) {
            modelListeners[i].contentsChanged(firstIndex, lastIndex);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentsInvalid() {
        IModelListener[] modelListeners;
        Set set = this.listeners;
        synchronized (set) {
            modelListeners = new IModelListener[this.listeners.size()];
            this.listeners.toArray(modelListeners);
        }
        int i = 0;
        while (i < modelListeners.length) {
            modelListeners[i].contentsInvalid();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentsRemoved(ICICSObject element) {
        IModelListener[] modelListeners;
        Set set = this.listeners;
        synchronized (set) {
            modelListeners = new IModelListener[this.listeners.size()];
            this.listeners.toArray(modelListeners);
        }
        int i = 0;
        while (i < modelListeners.length) {
            modelListeners[i].contentsRemoved(element);
            ++i;
        }
    }

    protected void fireExceptionOccured(final Exception exception) {
        IModelListenerVisitor visitor = new IModelListenerVisitor(){

            @Override
            public void visit(IModelListener listener) {
                listener.exceptionOccured(exception);
            }
        };
        this.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(IModelListenerVisitor visitor) {
        IModelListener[] modelListeners;
        Set set = this.listeners;
        synchronized (set) {
            modelListeners = new IModelListener[this.listeners.size()];
            this.listeners.toArray(modelListeners);
        }
        IModelListener[] iModelListenerArray = modelListeners;
        int n = modelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IModelListener listener = iModelListenerArray[n2];
            Debug.event((Logger)logger, (String)AbstractResourcesModel.class.getName(), (String)"accept", (Object)visitor, (Object)listener);
            visitor.visit(listener);
            ++n2;
        }
    }

    @Override
    public IContext getContext() {
        return null;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public int getDefaultWarningCount() {
        return -1;
    }

    @Override
    public boolean isOverrideable() {
        return false;
    }

    @Override
    public void group() {
    }

    @Override
    public boolean isSummarized() {
        return false;
    }

    @Override
    public AggregatedResourcesModel getGroup(int index) {
        return null;
    }

    private static interface IModelListenerVisitor {
        public void visit(IModelListener var1);
    }
}

