/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectableListener;
import com.ibm.cics.core.comm.IConnectableListener2;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.model.AggregatedModelSortProperties;
import com.ibm.cics.core.model.AggregatedResourcesModel;
import com.ibm.cics.core.model.AggregatedResourcesModelComparator;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSTypesRegistry;
import com.ibm.cics.core.model.CICSplexDefinitionType;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IDefinitionBuilder;
import com.ibm.cics.core.model.IModelVersionChecker;
import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.model.ISystemGroupRoot;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.RegionsModel;
import com.ibm.cics.core.model.ResourcesModel;
import com.ibm.cics.core.model.UnsupportedTypeException;
import com.ibm.cics.core.model.internal.CICSplex;
import com.ibm.cics.core.model.internal.ManagedRegion;
import com.ibm.cics.core.model.internal.Region;
import com.ibm.cics.core.model.mutable.IMutableCoreObject;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.CICSRegionDefinitionInstallTarget;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ICICSplexDefinition;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.query.Request;
import com.ibm.cics.sm.comm.AbstractCICSAction;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnectionDecorator;
import com.ibm.cics.sm.comm.CSDRepository;
import com.ibm.cics.sm.comm.DREPRepository;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSGetAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SMUpdateException;
import com.ibm.cics.sm.comm.SortOrder;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.sm.comm.SystemManagerAuthenticationException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.context.OrderedContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ListenerList;

public class CPSM
implements ICPSM,
ICoreObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ISystemManagerConnection2 connection;
    private TopologyCPSMImpl topologyCPSM = new TopologyCPSMImpl();
    private final Object connectionLock = new Object();
    private final Object connectionAssignLock = new Object();
    private final ListenerList listeners = new ListenerList();
    private String defaultContext;
    private final CopyOnWriteArrayList<ResourcesModel> models = new CopyOnWriteArrayList();
    private Exception lastException;
    private final Logger logger = Logger.getLogger("com.ibm.cics.core.model");
    private static final Debug debug = new Debug(CPSM.class);

    @Override
    public ICPSM getCPSM() {
        return this;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(IConnection connection) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"setConnection", (Object)connection);
        Object object = this.connectionLock;
        synchronized (object) {
            Object object2 = this.connectionAssignLock;
            synchronized (object2) {
                this.defaultContext = null;
                for (ResourcesModel model : this.models) {
                    model.dispose();
                }
                if (connection instanceof ISystemManagerConnection2) {
                    this.connection = (ISystemManagerConnection2)connection;
                } else if (connection instanceof ISystemManagerConnection) {
                    this.connection = new SystemManagerConnection2Decorator((ISystemManagerConnection)connection);
                }
            }
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"setConnection", (Object)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.connectionAssignLock;
        synchronized (object) {
            if (this.isConnected()) {
                return this.connection.getServerApplID();
            }
            return "";
        }
    }

    @Override
    public ICICSplex[] getCICSplexes() {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getCICSplexes", (Object)this);
        ICICSplex[] cicsPlexes = (ICICSplex[])this.getDefinitions(CICSplexType.getInstance(), this.getDefaultCMASContext());
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getCICSplexes", Arrays.asList(cicsPlexes));
        return cicsPlexes;
    }

    @Override
    public ICICSplexDefinition[] getCICSplexDefinitions() {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getCICSplexDefinitions", (Object)this);
        ICICSplexDefinition[] definitions = (ICICSplexDefinition[])this.getDefinitions(CICSplexDefinitionType.getInstance(), this.getDefaultCMASContext());
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getCICSplexDefinitions", (Object)definitions);
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IManagedRegion[] getManagedRegions(ICICSplex plex) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getManagedRegions", (Object)this, (Object)plex);
        IManagedRegion[] regions = new ManagedRegion[]{};
        ConnectionException e = null;
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.isConnected()) {
                    Context context = new Context(plex.getName());
                    SMConnectionResponse response = this.connection.getResources(ManagedRegionType.getInstance().getResourceTableName(), (IContext)context);
                    regions = new ManagedRegion[response.getRecordCount()];
                    int i = 0;
                    while (i < response.getRecordCount()) {
                        regions[i] = new ManagedRegion(this, context, plex, response.getRecord(i));
                        ++i;
                    }
                    this.setException(null);
                }
            }
        }
        catch (ConnectionException ex) {
            e = ex;
        }
        this.setException((Exception)((Object)e));
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getManagedRegions", (Object)regions);
        return regions;
    }

    @Override
    public RegionsModel getRegions(String context) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getRegions", (Object)this, (Object)context);
        RegionsModel model = new RegionsModel(this, context, context, null);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getRegions", (Object)model);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<List<AggregatedResourcesModel>> getAggregation(ICICSType<?> resourceType, IContext context, List<ICICSAttribute<?>> groupByAttributes, AggregatedModelSortProperties sortProperties) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getAggregation", (Object)this, resourceType, (Object)context, (Object)this.attributeListToString(groupByAttributes));
        ArrayList<AggregatedResourcesModel> aggregatedModels = null;
        try {
            CICSSystemManagerException exception;
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.isConnected()) {
                    List<ICICSAttribute> allAttributes = Collections.unmodifiableList(Arrays.asList(resourceType.attributes()));
                    Optional aggregateRecords = this.connection.getAggregateRecord(resourceType, context, groupByAttributes, allAttributes);
                    if (aggregateRecords.isPresent()) {
                        aggregatedModels = new ArrayList<AggregatedResourcesModel>();
                        for (CICSObjectAggregateRecord aggregateRecord : (List)aggregateRecords.get()) {
                            AggregatedResourcesModel aggregatedResourcesModel = new AggregatedResourcesModel((ICPSM)this, resourceType, context, groupByAttributes, aggregateRecord);
                            Debug.event((Logger)this.logger, (String)AggregatedResourcesModel.class.getName(), (String)"getAggregation", (Object)aggregatedResourcesModel);
                            aggregatedModels.add(aggregatedResourcesModel);
                            if (sortProperties == null) continue;
                            aggregatedModels.sort(new AggregatedResourcesModelComparator(sortProperties));
                        }
                        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getAggregation", aggregatedModels);
                    }
                    exception = null;
                } else {
                    exception = new CICSSystemManagerException("Not connected");
                }
            }
            this.setException((Exception)((Object)exception));
        }
        catch (ConnectionException e) {
            this.setException((Exception)((Object)e));
            throw new CICSSystemManagerException(e.getMessage(), (Exception)((Object)e));
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getAggregation", aggregatedModels);
        if (aggregatedModels != null) {
            return Optional.of(aggregatedModels);
        }
        return Optional.empty();
    }

    private String attributeListToString(List<ICICSAttribute<?>> attributes) {
        String description = "List<ICICSAttribute<?> [";
        for (ICICSAttribute<?> icicsAttribute : attributes) {
            description = String.valueOf(description) + icicsAttribute.getCicsName() + ",";
        }
        description = String.valueOf(description) + "]";
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SMConnectionResponse get(String resourceName, IContext context) throws CICSSystemManagerException {
        SMConnectionResponse response;
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", (Object)this, (Object)resourceName, (Object)context);
        try {
            Exception exception;
            Object object = this.connectionLock;
            synchronized (object) {
                if (context == null || context.getContext() == null) {
                    final String defaultContext = this.getDefaultContext();
                    context = new IScopedContext(){

                        public String getContext() {
                            return defaultContext;
                        }

                        public String getScope() {
                            return this.getContext();
                        }
                    };
                }
                if (!this.isConnected()) {
                    Object response2 = null;
                    CICSSystemManagerException exception2 = new CICSSystemManagerException("Not connected");
                    this.setException((Exception)((Object)exception2));
                    throw exception2;
                }
                response = this.connection.get(resourceName, context);
                exception = null;
            }
            this.setException(exception);
        }
        catch (TypeNotFoundException ex) {
            ICICSType<?> type = CICSTypesRegistry.findForResourceTableName(resourceName);
            this.setException(null);
            throw new UnsupportedTypeException(resourceName, type);
        }
        catch (ConnectionException ex) {
            this.setException((Exception)((Object)ex));
            throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", (Object)response);
        return response;
    }

    protected IContext getDefaultCMASContext() {
        return new Context(null);
    }

    protected String getDefaultContext() throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefaultContext", (Object)this, (Object)this.defaultContext);
        if (this.defaultContext == null) {
            ICICSplex[] cicsPlexes = this.getCICSplexes();
            if (cicsPlexes.length == 0) {
                throw new CICSSystemManagerException("Couldn't determine default context because no CICSplexes were found");
            }
            this.defaultContext = cicsPlexes[0].getName();
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefaultContext", (Object)this.defaultContext);
        return this.defaultContext;
    }

    @Override
    public SMConnectionResponse fetch(SMConnectionResponse request, int position, int count) throws ConnectionException {
        return this.doFetch(request.getStub(), position, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMConnectionResponse doFetch(String stub, int position, int count) throws ConnectionException {
        SMConnectionResponse response;
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"fetch", (Object)this, (Object)stub, (Object)position, (Object)count);
        try {
            Exception exception;
            Object object = this.connectionLock;
            synchronized (object) {
                if (!this.isConnected()) {
                    Object response2 = null;
                    CICSSystemManagerException exception2 = new CICSSystemManagerException("Not connected");
                    this.setException((Exception)((Object)exception2));
                    throw new ConnectionException((Exception)((Object)exception2));
                }
                response = this.connection.fetch(stub, position, count);
                exception = null;
            }
            this.setException(exception);
        }
        catch (ConnectionException ex) {
            this.setException((Exception)((Object)ex));
            throw ex;
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"fetch", (Object)response);
        return response;
    }

    @Override
    public SMConnectionResponse fetch(String stub, int position, int count) throws CICSSystemManagerException {
        try {
            return this.doFetch(stub, position, count);
        }
        catch (ConnectionException e) {
            throw new CICSSystemManagerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(String stub) {
        block10: {
            Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (Object)this, (Object)stub);
            Object exception = null;
            try {
                try {
                    Object object = this.connectionLock;
                    synchronized (object) {
                        if (this.isConnected()) {
                            this.connection.discard(stub);
                            exception = null;
                        } else {
                            exception = new CICSSystemManagerException("Not connected");
                        }
                    }
                }
                catch (ConnectionException ex) {
                    Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (String)stub, (Throwable)ex);
                    exception = ex;
                    this.setException((Exception)exception);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.setException((Exception)exception);
                throw throwable;
            }
            this.setException((Exception)exception);
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard2(String stub) throws CICSSystemManagerException {
        Object exception = null;
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.isConnected()) {
                    try {
                        this.connection.discard(stub);
                    }
                    catch (ConnectionException ex) {
                        exception = ex;
                        throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
                    }
                } else {
                    CICSSystemManagerException ex = new CICSSystemManagerException("Not connected");
                    exception = ex;
                    throw ex;
                }
            }
        }
        catch (Throwable throwable) {
            this.setException((Exception)exception);
            throw throwable;
        }
        this.setException((Exception)exception);
    }

    public String toString() {
        String host = this.connection != null ? this.connection.getHost() : "";
        return "CPSM[host=" + host + "]";
    }

    public void addListener(IConnectableListener2 listener) {
        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"addListener", (Object)this, (Object)listener);
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(IConnectableListener2 listener) {
        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"removeListener", (Object)this, (Object)listener);
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    private void setException(Exception ex) {
        Exception newException = null;
        if (ex != null) {
            if (ex instanceof SystemManagerConnectionException && ((SystemManagerConnectionException)ex).getResponseCode() != 200) {
                newException = ex;
            }
            if (ex instanceof AuthenticationException) {
                newException = ex;
            }
            if (newException == null) {
                newException = (Exception)ex.getCause();
            }
            if (newException == null) {
                return;
            }
        }
        Exception previousException = this.lastException;
        this.lastException = newException;
        if (previousException != null || newException != null) {
            this.fireException(newException);
        }
    }

    private void fireException(Exception ex) {
        Object[] listenerArray;
        Object[] objectArray = listenerArray = this.listeners.getListeners();
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IConnectableListener2 listener = (IConnectableListener2)element;
            Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"fireException", (Object)this, (Object)listener, (Object)ex);
            listener.exception((IConnectable)this, ex);
            ++n2;
        }
    }

    @Override
    public boolean isReadOnly() {
        return Boolean.getBoolean("com.ibm.cics.cpsm.readonly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkUpdate(ICICSType<?> type) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkUpdate", (Object)this, type);
        boolean update = false;
        Object object = this.connectionAssignLock;
        synchronized (object) {
            if (this.isConnected()) {
                String resourceType = type.getResourceTableName();
                IContext context = null;
                try {
                    final String defaultContext = this.getDefaultContext();
                    context = new IContext(){

                        public String getContext() {
                            return defaultContext;
                        }
                    };
                    String actions = this.connection.getActions(resourceType, context);
                    update = actions.indexOf("update") != -1;
                }
                catch (CICSSystemManagerException e) {
                    Debug.warning((Logger)this.logger, (String)"checkUpdate", (String)"Failed to get default context", (Object)((Object)e));
                }
            }
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkUpdate", (Object)update);
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean checkPermission(String action, ICICSObject object) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)this, (Object)action, (Object)object);
        boolean permitted = false;
        Object object2 = this.connectionAssignLock;
        synchronized (object2) {
            if (this.isConnected()) {
                ICICSOperation operation;
                if (action.equals("create")) {
                    operation = ICICSOperation.CREATE;
                } else if (action.equals("read")) {
                    operation = ICICSOperation.GET;
                } else if (action.equals("update")) {
                    operation = ICICSOperation.UPDATE;
                } else if (action.equals("delete")) {
                    operation = ICICSOperation.DELETE;
                } else if (action.equals("perform")) {
                    operation = ICICSOperation.PERFORM;
                } else if (action.equals("install")) {
                    operation = SystemManagerActions.Install;
                } else if (action.equals("remove")) {
                    operation = SystemManagerActions.Remove;
                } else {
                    throw new IllegalArgumentException("action: " + action);
                }
                permitted = this.checkPermission(operation, object);
            }
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)permitted);
        return permitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPermission(ICICSOperation operation, ICICSObject object) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)this, (Object)operation, (Object)object);
        boolean permitted = false;
        Object object2 = this.connectionAssignLock;
        synchronized (object2) {
            if (this.isConnected()) {
                ICICSType type = object.getObjectType();
                IContext context = (IContext)((ICoreObject)object).getAdapter(IPrimaryKey.class);
                permitted = this.checkPermission(operation, type, context);
                if (operation instanceof ICICSAction && object instanceof ICICSResource) {
                    permitted = permitted && this.checkPermissionCICSRelease((ICICSAction)operation, (ICICSResource)object);
                }
            }
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)permitted);
        return permitted;
    }

    private boolean checkPermissionCICSRelease(ICICSAction action, ICICSResource cicsResource) {
        boolean permitted = true;
        try {
            CICSRelease resourceOriginRelease = CICSRelease.valueOf((String)cicsResource.getCICSRelease().toLowerCase());
            if (action.getValidFrom() != null) {
                boolean bl = permitted = permitted && action.getValidFrom().compareTo((Enum)resourceOriginRelease) <= 0;
            }
            if (permitted && action.getValidTo() != null) {
                permitted = permitted && action.getValidTo().compareTo((Enum)resourceOriginRelease) >= 0;
            }
            return permitted;
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
    }

    @Override
    public boolean checkPermission(ICICSOperation operation, ICICSType<?> type) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)this, (Object)operation, type);
        boolean permitted = this.checkPermission(operation, type, IContext.ANY_CONTEXT);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)permitted);
        return permitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPermission(ICICSOperation operation, ICICSType<?> type, IContext context) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)this, (Object)operation, type, (Object)context);
        boolean permitted = false;
        Object object = this.connectionAssignLock;
        synchronized (object) {
            permitted = this.checkOperationForModelVersion(operation, type);
            if (permitted && this.isConnected() && context instanceof OrderedContext) {
                permitted = this.checkSortAttributes(operation, type, (OrderedContext)context);
            }
            if (permitted && this.isConnected()) {
                String resourceType = type.getResourceTableName();
                permitted = this.connection.checkOperation(resourceType, context, operation);
            }
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"checkPermission", (Object)permitted);
        return permitted;
    }

    private boolean checkSortAttributes(ICICSOperation operation, ICICSType<?> type, OrderedContext context) {
        for (SortOrder sortOrder : context.getSortOrders()) {
            ICICSAttribute attribute = type.findAttributeByCicsName(sortOrder.getAttribute());
            String version = this.connection.getVersion();
            if (attribute.getValidFrom() == null || !attribute.getValidFrom().laterThan(version)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOperationForModelVersion(ICICSOperation operation, ICICSType<?> type) {
        boolean result = true;
        Object object = this.connectionAssignLock;
        synchronized (object) {
            if (this.isConnected()) {
                if (this.connection instanceof IModelVersionChecker) {
                    return ((IModelVersionChecker)this.connection).checkOperationForModelVersion(operation, type);
                }
                if (operation instanceof ICICSGetAction && type.isDefinition()) {
                    ICICSGetAction action = (ICICSGetAction)operation;
                    String attributeName = action.getAttributeName();
                    ICICSAttribute attribute = type.findAttributeByCicsName(attributeName);
                    String version = this.connection.getVersion();
                    if (attribute.getValidFrom() != null && attribute.getValidFrom().laterThan(version)) {
                        result = false;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean checkUpdate(ICICSObject object) {
        return this.checkPermission(ICICSOperation.UPDATE, object);
    }

    @Override
    public ISystemGroupRoot getSystemGroupRoot() {
        return new ISystemGroupRoot(){

            public ICICSObjectReference<?> getCICSObjectReference() {
                return null;
            }

            @Override
            public ICPSM getCPSM() {
                return CPSM.this;
            }

            @Override
            public Object getAdapter(Class adapter) {
                return null;
            }

            public String getName() {
                return CPSM.this.connection != null ? CPSM.this.connection.getServerApplID() : "";
            }

            @Override
            public ICICSplexDefinition[] getPlexDefinitions() {
                return CPSM.this.getCICSplexDefinitions();
            }

            @Deprecated
            public ICICSType<?> getCICSType() {
                return null;
            }

            public ICICSType<?> getObjectType() {
                return this.getCICSType();
            }

            @Override
            public ICICSplex[] getCICSplexes() {
                return CPSM.this.getCICSplexes();
            }

            public <T> T getAttributeValue(IAttribute<T> attribute) {
                return null;
            }

            public ICICSObjectContainer<? extends ICICSObject> getCICSContainer() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ICICSObject[] getDefinitions(ICICSType<?> resourceType, IContext context) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefinitions", (Object)this, resourceType, (Object)context);
        ICICSObject[] definitions = null;
        try {
            definitions = this.getDefinitions2(resourceType, context);
        }
        catch (Exception ex) {
            this.setException(ex);
            definitions = (ICICSObject[])Array.newInstance(resourceType.getImplementationType(), 0);
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefinitions", (Object)definitions);
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICICSObject[] getDefinitions2(ICICSType<?> resourceType, IContext context) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefinitions2", (Object)this, resourceType, (Object)context);
        Class implementationType = resourceType.getImplementationType();
        ICICSObject[] definitions = (ICICSObject[])Array.newInstance(resourceType.getImplementationType(), 0);
        try {
            CICSSystemManagerException e;
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.isConnected()) {
                    SMConnectionResponse response = this.connection.getResources(resourceType.getResourceTableName(), context);
                    definitions = (ICICSObject[])Array.newInstance(implementationType, response.getRecordCount());
                    int i = 0;
                    while (i < response.getRecordCount()) {
                        definitions[i] = CICSCore.create(this, response.getRecord(i), resourceType);
                        ++i;
                    }
                    e = null;
                } else {
                    e = new CICSSystemManagerException("Not connected");
                }
            }
            this.setException((Exception)((Object)e));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (TypeNotFoundException ex) {
            this.setException(null);
            throw new UnsupportedTypeException(resourceType.getResourceTableName(), resourceType);
        }
        catch (ConnectionException e) {
            throw new CICSSystemManagerException(e.getMessage(), (Exception)((Object)e));
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getDefinitions2", (Object)definitions);
        return definitions;
    }

    public Class<? extends IConnection> getConnectionType() {
        return ISystemManagerConnection.class;
    }

    @Override
    public ResourcesModel getModel(ICICSType<?> resourceType, IContext context) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)this, resourceType, (Object)context);
        ResourcesModel model = new ResourcesModel(this, resourceType, context);
        boolean added = this.models.add(model);
        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)this.models.size(), (Object)added);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)model);
        return model;
    }

    public void disposeModel(ResourcesModel resourcesModel) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"disposeModel", (Object)this, (Object)resourcesModel.getResourceName(), (Object)resourcesModel);
        boolean removed = this.models.remove(resourcesModel);
        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"disposeModel", (Object)this.models.size(), (Object)removed);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"disposeModel");
    }

    @Deprecated
    public ICICSType<?> getCICSType() {
        return null;
    }

    public ICICSType<?> getObjectType() {
        return this.getCICSType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMutableCoreObject create(IContext context, IDefinitionBuilder builder) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)this, (Object)context, (Object)builder);
        IMutableCoreObject mutableDefinition = null;
        Exception exception = null;
        SMConnectionResponse response = null;
        String typeName = builder.getResourceName();
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        SMConnectionRecord record = builder.getRecord();
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)typeName, (Object)context);
                        response = this.connection.create(typeName, context, record);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)response);
                        if (response.getRecordTotal() < 1) {
                            throw new ConnectionException("Create succeeded, but no record was returned");
                        }
                    }
                }
                Object cicsObject = CICSCore.create(this, response.getRecord(0), builder.getObjectType());
                Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)response, cicsObject);
                this.addToModels((ICICSObject)cicsObject, typeName);
                mutableDefinition = this.getMutableObject(response, context, builder.getObjectType());
            }
            catch (SMUpdateException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)context, (Object)builder, (Object)((Object)ex));
                exception = null;
                throw ex;
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)context, (Object)builder, (Object)((Object)ex));
                exception = null;
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"create", (Object)mutableDefinition);
        return mutableDefinition;
    }

    private void addToModels(final ICICSObject cicsObject, String typeName) {
        String resourceType = cicsObject.getObjectType().getResourceTableName();
        IResourcesModelVisitor visitor = new IResourcesModelVisitor(){

            @Override
            public void visit(ResourcesModel resourcesModel) {
                resourcesModel.added(cicsObject);
            }
        };
        this.accept(visitor, resourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDefinition install(IDefinition cicsDefinition, IScopedContext target) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"install", (Object)this, (Object)cicsDefinition, (Object)target);
        IDefinition installedDefinition = null;
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        ICICSType definitionType = cicsDefinition.getObjectType();
                        String resourceType = definitionType.getResourceTableName();
                        IPrimaryKey primaryKey = this.getPrimaryKeyFor(cicsDefinition);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"install", (Object)resourceType, (Object)primaryKey, (Object)target);
                        SMConnectionResponse response = this.connection.install(resourceType, (IFilteredContext)primaryKey, target);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"install", (Object)response);
                        installedDefinition = (IDefinition)CICSCore.create(this, response.getRecord(0), cicsDefinition.getObjectType());
                    }
                }
            }
            catch (ConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"install", (Object)cicsDefinition, (Object)target, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"install", installedDefinition);
        return installedDefinition;
    }

    @Override
    public ICICSObject get2(ICICSType<?> cicsType, IPrimaryKey key) throws CICSSystemManagerException {
        try {
            return this.get(cicsType, key);
        }
        catch (CICSSystemManagerException ex) {
            if ("0".equals(ex.getMessage())) {
                return null;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICICSObject get(ICICSType<?> resourceType, IPrimaryKey primaryKey) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", (Object)this, resourceType, (Object)primaryKey);
        SMConnectionResponse response = null;
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        String tableName = resourceType.getResourceTableName();
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", (Object)tableName, (Object)primaryKey);
                        response = this.connection.getResources(tableName, (IContext)primaryKey);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", (Object)response);
                    }
                }
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", resourceType, (Object)primaryKey, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        if (response == null || response.getRecordCount() != 1) {
            throw new CICSSystemManagerException(String.valueOf(response.getRecordCount()));
        }
        Object cicsObject = CICSCore.create(this, response.getRecord(0), resourceType);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"get", cicsObject);
        return cicsObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMutableCoreObject update(IMutableCoreObject mutableCICSObject) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"update", (Object)this, (Object)mutableCICSObject);
        IMutableCoreObject updatedMutableDefinition = null;
        Exception exception = null;
        try {
            try {
                SMConnectionResponse response = null;
                ICICSType objectType = ((ICICSObject)mutableCICSObject).getObjectType();
                String typeName = objectType.getResourceTableName();
                IContext context = this.getPrimaryKeyFor(mutableCICSObject);
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        SMConnectionRecord record = mutableCICSObject.getRecord();
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"update", (Object)typeName, (Object)context, (Object)record);
                        response = this.connection.update(typeName, context, record);
                    }
                }
                if (response != null) {
                    Object cicsObject = CICSCore.create(this, response.getRecord(0), objectType);
                    Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)response, cicsObject);
                    IResourcesModelVisitor visitor = new IResourcesModelVisitor((ICICSObject)cicsObject){
                        private final /* synthetic */ ICICSObject val$cicsObject;
                        {
                            this.val$cicsObject = iCICSObject;
                        }

                        @Override
                        public void visit(ResourcesModel resourcesModel) {
                            resourcesModel.updated(this.val$cicsObject);
                        }
                    };
                    this.accept(visitor, typeName);
                    updatedMutableDefinition = this.getMutableObject(response, context, objectType);
                }
            }
            catch (Exception ex) {
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        finally {
            this.setException(exception);
        }
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"update", updatedMutableDefinition);
        return updatedMutableDefinition;
    }

    private IPrimaryKey getPrimaryKeyFor(IDefinition cicsDefintion) {
        IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)cicsDefintion).getAdapter(IPrimaryKey.class);
        return primaryKey;
    }

    private IContext getPrimaryKeyFor(IMutableCoreObject mutableCICSObject) {
        IContext context = (IContext)mutableCICSObject.getAdapter(IPrimaryKey.class);
        return context;
    }

    @Override
    public void perform(ICICSObject[] cicsObjects, ICICSAction cicsAction) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)this, (Object)cicsObjects, (Object)cicsAction);
        ICICSType objectType = cicsObjects[0].getObjectType();
        ICompoundFilteredContext context = this.getCompoundFilteredContextFor(cicsObjects);
        this.perform((IContext)context, objectType, cicsAction);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(IContext context, ICICSType<?> objectType, ICICSAction cicsAction) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)this, (Object)context, (Object)cicsAction, objectType);
        String resourceType = objectType.getResourceTableName();
        Exception exception = null;
        try {
            try {
                Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)resourceType, (Object)context, (Object)cicsAction);
                SMConnectionResponse response = null;
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        response = this.connection.perform(resourceType, context, cicsAction);
                    }
                }
                if (response != null && response.getRecordCount() > 0) {
                    Object cicsObject = CICSCore.create(this, response.getRecord(0), objectType);
                    Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)response, cicsObject);
                    this.accept(new IResourcesModelVisitor((ICICSObject)cicsObject){
                        private final /* synthetic */ ICICSObject val$cicsObject;
                        {
                            this.val$cicsObject = iCICSObject;
                        }

                        @Override
                        public void visit(ResourcesModel resourcesModel) {
                            resourcesModel.updated(this.val$cicsObject);
                        }
                    }, resourceType);
                    if (this.isDestructive(cicsAction)) {
                        this.removeFromModels((ICICSObject)cicsObject, resourceType);
                    }
                    if (this.isConstructive(cicsAction)) {
                        this.addToModels((ICICSObject)cicsObject, resourceType);
                    }
                } else {
                    Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)"Zero record count returned from perform", (Object)response);
                }
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform", (Object)resourceType, (Object)context, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"perform");
    }

    private boolean isDestructive(ICICSAction cicsAction) {
        return cicsAction == SystemManagerActions.PurgeTask || cicsAction == SystemManagerActions.ForcePurgeTask || cicsAction == SystemManagerActions.KillTask || cicsAction == SystemManagerActions.Delete;
    }

    private boolean isConstructive(ICICSAction cicsAction) {
        return cicsAction instanceof SystemManagerActions.SystemDumpCodeAddAction || cicsAction instanceof SystemManagerActions.TranDumpCodeAddAction;
    }

    private void accept(IResourcesModelVisitor visitor, String resourceType) {
        Object[] objectArray = this.models.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ResourcesModel model = (ResourcesModel)object;
            if (model.getResourceName().equals(resourceType)) {
                visitor.visit(model);
            }
            ++n2;
        }
    }

    private ICompoundFilteredContext getCompoundFilteredContextFor(ICICSObject[] cicsObjects) {
        IFilteredContext[] filteredContexts = new IFilteredContext[cicsObjects.length];
        int i = 0;
        while (i < cicsObjects.length) {
            ICoreObject coreObject = (ICoreObject)cicsObjects[i];
            IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
            filteredContexts[i] = primaryKey;
            ++i;
        }
        CompoundFilteredContext compoundFilteredContext = new CompoundFilteredContext(filteredContexts);
        return compoundFilteredContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(IResourceGroupDefinition group, ICICSDefinition definition) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)this, (Object)group, (Object)definition);
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        String resourceType = definition.getObjectType().getResourceTableName();
                        IPrimaryKey definitionContext = (IPrimaryKey)((ICoreObject)definition).getAdapter(IPrimaryKey.class);
                        IPrimaryKey groupContext = (IPrimaryKey)((ICoreObject)group).getAdapter(IPrimaryKey.class);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)resourceType, (Object)definitionContext, (Object)groupContext);
                        SMConnectionResponse response = this.connection.add(resourceType, (IFilteredContext)definitionContext, (IFilteredContext)groupContext);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)response);
                    }
                }
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)definition, (Object)group, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)this.getClass().getName(), (String)"add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IResourceDescriptionDefinition description, IResourceGroupDefinition group) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)this, (Object)description, (Object)group);
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        String groupType = group.getObjectType().getResourceTableName();
                        IPrimaryKey groupContext = (IPrimaryKey)((ICoreObject)group).getAdapter(IPrimaryKey.class);
                        SystemManagerActions.AddToResourceDescriptionAction action = new SystemManagerActions.AddToResourceDescriptionAction();
                        action.setTargetResourceDescription(description.getName());
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)groupType, (Object)groupContext, (Object)action);
                        SMConnectionResponse response = this.connection.perform(groupType, (IContext)groupContext, (ICICSAction)action);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)response);
                    }
                }
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)description, (Object)group, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)this.getClass().getName(), (String)"add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ICICSRegionGroupDefinition regionGroup, ICICSRegionDefinition region) throws CICSSystemManagerException {
        debug.enter("add", (Object)this, (Object)regionGroup, (Object)region);
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        String resourceType = region.getObjectType().getResourceTableName();
                        IPrimaryKey definitionContext = (IPrimaryKey)((ICoreObject)region).getAdapter(IPrimaryKey.class);
                        AbstractCICSAction addToGroupAction = new AbstractCICSAction("ADDTOGRP", new String[][]{{"TOGROUP", regionGroup.getName()}}){};
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)resourceType, (Object)definitionContext, (Object)addToGroupAction);
                        SMConnectionResponse response = this.connection.perform(resourceType, (IContext)definitionContext, (ICICSAction)addToGroupAction);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)response);
                    }
                }
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"add", (Object)regionGroup, (Object)region, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        debug.exit("add");
    }

    @Override
    public void remove(ICSDListDefinition list, ICSDGroupDefinition group) throws CICSSystemManagerException {
        this.remove((IDefinition)list, (IDefinition)group);
        if (this.lastException == null) {
            this.removeFromModels((IDefinition)group);
        }
    }

    @Override
    public void remove(IResourceDescriptionDefinition list, IResourceGroupDefinition group) throws CICSSystemManagerException {
        this.remove((IDefinition)list, (IDefinition)group);
        if (this.lastException == null) {
            this.removeFromModels((IDefinition)group);
        }
    }

    @Override
    public void remove(IResourceGroupDefinition group, ICICSDefinition definition) throws CICSSystemManagerException {
        this.remove((IDefinition)group, (IDefinition)definition);
        if (this.lastException == null) {
            this.removeFromModels((IDefinition)definition);
        }
    }

    @Override
    public void remove(ICICSRegionGroupDefinition regionGroup, ICICSRegionDefinition region) throws CICSSystemManagerException {
        this.remove((IDefinition)regionGroup, (IDefinition)region);
    }

    @Override
    public void remove(ICICSRegionGroupDefinition parentRegionGroup, ICICSRegionGroupDefinition regionGroup) throws CICSSystemManagerException {
        this.remove((IDefinition)parentRegionGroup, (IDefinition)regionGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(IDefinition container, IDefinition containee) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)this.getClass().getName(), (String)"remove", (Object)this, (Object)container, (Object)containee);
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        String resourceType = containee.getObjectType().getResourceTableName();
                        IPrimaryKey definitionContext = (IPrimaryKey)((ICoreObject)containee).getAdapter(IPrimaryKey.class);
                        IPrimaryKey groupContext = (IPrimaryKey)((ICoreObject)container).getAdapter(IPrimaryKey.class);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"remove", (Object)resourceType, (Object)definitionContext, (Object)groupContext);
                        SMConnectionResponse response = this.connection.remove(resourceType, (IFilteredContext)definitionContext, (IFilteredContext)groupContext);
                        Debug.event((Logger)this.logger, (String)this.getClass().getName(), (String)"remove", (Object)response);
                    }
                }
            }
            catch (SystemManagerAuthenticationException e) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"remove", (Object)containee, (Object)container, (Object)((Object)e));
                exception = e.getCause();
                throw new CICSSystemManagerException(exception.getMessage(), exception);
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"remove", (Object)containee, (Object)container, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)this.getClass().getName(), (String)"remove");
    }

    @Override
    public void discardResource(ICICSResource[] resources) throws CICSSystemManagerException {
        this.discard((ICICSObject)resources[0]);
    }

    @Override
    public void discard(ICICSObject object) throws CICSSystemManagerException {
        ICoreObject coreObject = (ICoreObject)object;
        ICICSType type = object.getObjectType();
        IPrimaryKey reference = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        this.discard(type, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(ICICSType<?> resourceType, IPrimaryKey context) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (Object)this, (Object)context);
        Exception exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (Object)context);
                        SMConnectionResponse response = this.connection.delete(resourceType.getResourceTableName(), (IContext)context);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (Object)response);
                    }
                }
                this.removeFromModels(context, resourceType.getResourceTableName());
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard", (Object)context, (Object)((Object)ex));
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException(exception);
            throw throwable;
        }
        this.setException(exception);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"discard");
    }

    private void removeFromModels(IDefinition definition) {
        String resourceType = definition.getObjectType().getResourceTableName();
        this.removeFromModels((ICICSObject)definition, resourceType);
    }

    private void removeFromModels(final IPrimaryKey key, String typeName) {
        IResourcesModelVisitor visitor = new IResourcesModelVisitor(){

            @Override
            public void visit(ResourcesModel resourcesModel) {
                resourcesModel.removed(key);
            }
        };
        this.accept(visitor, typeName);
    }

    private void removeFromModels(final ICICSObject cicsObject, String typeName) {
        IResourcesModelVisitor visitor = new IResourcesModelVisitor(){

            @Override
            public void visit(ResourcesModel resourcesModel) {
                resourcesModel.removed(cicsObject);
            }
        };
        this.accept(visitor, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ICICSType<?> type, IContext context) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", type, (Object)context);
        SystemManagerConnectionException exception = null;
        try {
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        this.connection.delete(type.getResourceTableName(), context);
                    }
                }
            }
            catch (SystemManagerAuthenticationException e) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", type, (Object)context, (Object)((Object)e));
                exception = e.getCause();
                throw new CICSSystemManagerException(exception.getMessage(), (Exception)((Object)exception));
            }
            catch (SystemManagerConnectionException e) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", type, (Object)context, (Object)((Object)e));
                exception = e;
                throw new CICSSystemManagerException(e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            this.setException((Exception)((Object)exception));
            throw throwable;
        }
        this.setException((Exception)((Object)exception));
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(IDefinition definition) throws CICSSystemManagerException {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", (Object)this, (Object)definition);
        Throwable exception = null;
        try {
            try {
                String typeName = definition.getObjectType().getResourceTableName();
                Object object = this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        IContext context = (IContext)((ICoreObject)definition).getAdapter(IPrimaryKey.class);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", (Object)typeName, (Object)context);
                        SMConnectionResponse response = this.connection.delete(typeName, context);
                        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", (Object)response);
                    }
                }
                this.removeFromModels((ICICSObject)definition, typeName);
            }
            catch (SystemManagerConnectionException ex) {
                Debug.warning((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete", (Object)definition, (Object)((Object)ex));
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.toString(), ex);
                exception = ex;
                throw new CICSSystemManagerException(ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            this.setException((Exception)exception);
            throw throwable;
        }
        this.setException((Exception)exception);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"delete");
    }

    private IMutableCoreObject getMutableObject(SMConnectionResponse response, IContext context, ICICSType<?> objectType) {
        Object cicsObject = CICSCore.create(this, response.getRecord(0), objectType);
        IMutableCoreObject updatedMutableDefinition = (IMutableCoreObject)((ICoreObject)cicsObject).getAdapter(IMutableCoreObject.class);
        return updatedMutableDefinition;
    }

    public <T> T getAttributeValue(IAttribute<T> attribute) {
        return null;
    }

    public ICICSObjectReference<?> getCICSObjectReference() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRepository> getRepositories() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connection != null ? this.connection.getRepositories() : Collections.emptyList();
        }
    }

    public ICICSObjectContainer<? extends ICICSObject> getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    public ISystemManagerConnection2 getConnection() {
        return this.connection;
    }

    @Override
    public CICSRelease getVersion() {
        if (this.isConnected()) {
            ISystemManagerConnection2 smConn = this.getConnection();
            String version = smConn.getVersion();
            try {
                CICSRelease release = CICSRelease.fromVersion((String)version);
                return release;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.connectionAssignLock;
        synchronized (object) {
            return this.connection != null && this.connection.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws ConnectionException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    public void addListener(IConnectableListener listener) {
    }

    @Override
    public void removeListener(IConnectableListener listener) {
    }

    @Override
    public boolean isAggregatable(ICICSType<?> type, ICICSAttribute<?> attribute) {
        return this.connection.isAggregatable(type.getResourceTableName(), attribute);
    }

    @Override
    public boolean isAggregatable(ICICSType<?> type) {
        return this.connection.isAggregatable(type);
    }

    @Override
    public IResourcesModel getModel(ICICSType<?> resourceType, IContext context, List<ICICSAttribute<?>> groupByAttributes, boolean aggregate, AggregatedModelSortProperties sortProperties) {
        Debug.enter((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)this, resourceType, (Object)context, groupByAttributes, (Object)aggregate);
        ResourcesModel model = new ResourcesModel(this, resourceType, context, groupByAttributes, aggregate, sortProperties);
        boolean added = this.models.add(model);
        Debug.event((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)this.models.size(), (Object)added);
        Debug.exit((Logger)this.logger, (String)CPSM.class.getName(), (String)"getModel", (Object)model);
        return model;
    }

    @Override
    public com.ibm.cics.model.topology.CPSM getTopology() {
        return this.topologyCPSM;
    }

    public class CompoundFilteredContext
    implements ICompoundFilteredContext {
        private final IContext parentContext;
        private final IFilteredContext[] contexts;

        public CompoundFilteredContext(IFilteredContext[] filteredContexts) {
            this.parentContext = filteredContexts[0].getParentContext();
            this.contexts = filteredContexts;
        }

        public String getContext() {
            return this.parentContext.getContext();
        }

        public IContext getParentContext() {
            return this.parentContext;
        }

        public Iterator<IFilteredContext> iterator() {
            return Arrays.asList(this.contexts).iterator();
        }
    }

    private static interface IResourcesModelVisitor {
        public void visit(ResourcesModel var1);
    }

    private class SystemManagerConnection2Decorator
    extends AbstractSystemManagerConnectionDecorator
    implements ISystemManagerConnection2 {
        private final ISystemManagerConnection connection;

        public SystemManagerConnection2Decorator(ISystemManagerConnection connection) {
            super(connection);
            this.connection = connection;
        }

        public List<IRepository> getRepositories() {
            ICICSplex[] cicsPlexes;
            ArrayList<IRepository> repoList = new ArrayList<IRepository>();
            ICICSplex[] iCICSplexArray = cicsPlexes = this.getCICSplexes();
            int n = cicsPlexes.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSplex cicsplex = iCICSplexArray[n2];
                if (cicsplex.getMPStatus() == ICICSEnums.YesNoValue.YES) {
                    ArrayList<CICSRegionDefinitionInstallTarget> regTargets = new ArrayList<CICSRegionDefinitionInstallTarget>();
                    IRegion[] iRegionArray = this.getRegions(cicsplex);
                    int n3 = iRegionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IRegion region = iRegionArray[n4];
                        String regionName = region.getRegionName();
                        CICSRegionDefinitionInstallTarget target = new CICSRegionDefinitionInstallTarget(cicsplex.getName(), regionName);
                        repoList.add((IRepository)new CSDRepository(regionName, Arrays.asList(target)));
                        regTargets.add(target);
                        ++n4;
                    }
                    repoList.add((IRepository)new DREPRepository(cicsplex.getName(), regTargets));
                }
                ++n2;
            }
            return repoList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ICICSplex[] getCICSplexes() {
            ICICSplex[] cicsPlexes = new ICICSplex[]{};
            try {
                Object object = CPSM.this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        SMConnectionResponse response = this.connection.getResources(CICSplexType.getInstance().getResourceTableName(), CPSM.this.getDefaultCMASContext());
                        cicsPlexes = new ICICSplex[response.getRecordCount()];
                        int i = 0;
                        while (i < response.getRecordCount()) {
                            cicsPlexes[i] = new CICSplex(CPSM.this, CPSM.this.getDefaultCMASContext(), response.getRecord(i));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception ex) {
                debug.event("getCICSplexes", (Object)ex);
            }
            return cicsPlexes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRegion[] getRegions(ICICSplex cicsplex) {
            IRegion[] regions = new IRegion[]{};
            try {
                Object object = CPSM.this.connectionLock;
                synchronized (object) {
                    if (this.isConnected()) {
                        Context context = new Context(cicsplex.getName());
                        SMConnectionResponse response = this.connection.getResources(RegionType.getInstance().getResourceTableName(), (IContext)context);
                        regions = new IRegion[response.getRecordCount()];
                        int i = 0;
                        while (i < response.getRecordCount()) {
                            regions[i] = new Region(CPSM.this, context, response.getRecord(i));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception ex) {
                debug.event("getRegions", (Object)ex);
            }
            return regions;
        }
    }

    private class TopologyCPSMImpl
    implements com.ibm.cics.model.topology.CPSM {
        private TopologyCPSMImpl() {
        }

        public Map<String, ? extends com.ibm.cics.model.topology.CICSplex> getCICSplexes() throws CICSActionException {
            return Collections.emptyMap();
        }

        public Optional<? extends com.ibm.cics.model.topology.CICSplex> getCICSplex(String name) throws CICSActionException {
            return Optional.empty();
        }

        public com.ibm.cics.model.topology.CPSM graphQuery(Consumer<Request> request) throws CICSActionException {
            try {
                Object object = CPSM.this.connectionLock;
                synchronized (object) {
                    if (CPSM.this.isConnected()) {
                        return CPSM.this.connection.graphQuery(request);
                    }
                    throw new CICSSystemManagerException("Not connected");
                }
            }
            catch (ConnectionException e) {
                throw new CICSSystemManagerException(e.getMessage(), (Exception)((Object)e));
            }
        }

        public boolean isGraphQuerySupported() {
            return CPSM.this.connection.isGraphQuerySupported();
        }
    }
}

