/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.internal.CICSDefinitionContainer;
import com.ibm.cics.core.model.internal.CICSResourceContainer;
import com.ibm.cics.core.model.internal.CPSMDefinitionContainer;
import com.ibm.cics.core.model.internal.GenericContainer;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.topology.BASRepository;
import com.ibm.cics.model.topology.CICSplex;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ScopedContext;

public class ContainerUtilities {
    public static <E extends ICICSObject> ICICSObjectContainer<E> toOnline(ICICSObjectContainer<E> container) {
        ICPSM cpsm;
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        if (connectionService != null && (cpsm = (ICPSM)connectionService.getConnectable("com.ibm.cics.sm.connection")) != null) {
            if (container instanceof GenericContainer) {
                return container;
            }
            if (container instanceof BASRepository) {
                CICSplex cicsplex = ((BASRepository)container).getCICSplex();
                return new CICSDefinitionContainer(cpsm, (IContext)new Context(cicsplex.getName()));
            }
            if (container instanceof ICICSResourceContainer) {
                ICICSResourceContainer existingContainer = (ICICSResourceContainer)container;
                ScopedContext context = new ScopedContext((IContext)new Context(existingContainer.getCICSplex().getName()), existingContainer.getName());
                return new CICSResourceContainer(cpsm, (IContext)context);
            }
            if (container instanceof ICPSMDefinitionContainer) {
                ICPSMDefinitionContainer existingContainer = (ICPSMDefinitionContainer)container;
                CICSplex cicsplex = existingContainer.getCICSplex();
                return new CPSMDefinitionContainer(cpsm, (IContext)new Context(cicsplex.getName()));
            }
            throw new UnsupportedOperationException("Container conversion not supported for " + container.getClass());
        }
        throw new IllegalStateException("Not connected");
    }

    public static boolean isOffline(ICICSObject object) {
        return ((ICoreObject)object).getCPSM() == null;
    }
}

