/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IResourceAssignmentDefinition;
import com.ibm.cics.model.IResourceAssignmentInResourceDescription;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.IResourceInDescriptionEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableResourceGroupDefinition;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class ResourceGroupDefinitionBuilder
extends DefinitionBuilder
implements IMutableResourceGroupDefinition {
    private MutableSMRecord record = new MutableSMRecord("RESGROUP");

    public ResourceGroupDefinitionBuilder(String _name) {
        this.setName(_name);
    }

    public ResourceGroupDefinitionBuilder(String _name, IResourceGroupDefinition anotherDef) throws Exception {
        this(_name);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICPSMDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setName(String _name) {
        String connectionSpecificExternalValue = null;
        if (_name != null && _name != ResourceGroupDefinitionType.NAME.getUnsupportedValue()) {
            ResourceGroupDefinitionType.NAME.validate((Object)_name);
            connectionSpecificExternalValue = ((CICSAttribute)ResourceGroupDefinitionType.NAME).set(_name, this.record.getNormalizers());
        }
        this.record.set("RESGROUP", connectionSpecificExternalValue);
    }

    public void setDescription(String _description) {
        String connectionSpecificExternalValue = null;
        if (_description != null && _description != ResourceGroupDefinitionType.DESCRIPTION.getUnsupportedValue()) {
            ResourceGroupDefinitionType.DESCRIPTION.validate((Object)_description);
            connectionSpecificExternalValue = ((CICSAttribute)ResourceGroupDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
        }
        this.record.set("DESCRIPTION", connectionSpecificExternalValue);
    }

    @Override
    public String getName() {
        String result = this.record.get("RESGROUP");
        return result == null ? null : (String)((CICSAttribute)ResourceGroupDefinitionType.NAME).get(result, this.record.getNormalizers());
    }

    @Override
    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        return result == null ? null : (String)((CICSAttribute)ResourceGroupDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceGroupDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ResourceGroupDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + ResourceGroupDefinitionType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == ResourceGroupDefinitionType.NAME) {
            this.setName((String)ResourceGroupDefinitionType.NAME.getType().cast(value));
        } else if (attribute == ResourceGroupDefinitionType.DESCRIPTION) {
            this.setDescription((String)ResourceGroupDefinitionType.DESCRIPTION.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + ResourceGroupDefinitionType.getInstance());
        }
    }

    public ResourceGroupDefinitionType getObjectType() {
        return ResourceGroupDefinitionType.getInstance();
    }

    public IResourceGroupDefinitionReference getCICSObjectReference() {
        return null;
    }

    public ICICSObjectSet<IResourceAssignmentDefinition> getFromResourceAssignments() {
        throw new UnsupportedOperationException();
    }

    public ICICSObjectSet<IResourceAssignmentInResourceDescription> getFromAssignmentsInDescriptions() {
        throw new UnsupportedOperationException();
    }

    public ICICSObjectSet<IResourceInDescriptionEntry> getGroupsInDescriptions() {
        throw new UnsupportedOperationException();
    }

    public ICICSObjectSet<IResourceGroupEntry> getResourcesInGroup() {
        throw new UnsupportedOperationException();
    }
}

