/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.BundlePartReference;
import com.ibm.cics.core.model.BundlePartType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.IBundlePart;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class BundlePart
extends CICSResource
implements IBundlePart {
    private String _bundle;
    private String _bundlepart;
    private IBundlePart.EnableStatusValue _enablestatus;
    private IBundlePart.PartClassValue _partclass;
    private String _metadatafile;
    private String _parttype;
    private Long _seqnumber;
    private IBundlePart.AvailabilityValue _availstatus;
    private String _operation;

    public BundlePart(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._bundle = (String)avm.getAttributeValue(BundlePartType.BUNDLE);
        this._bundlepart = (String)avm.getAttributeValue(BundlePartType.BUNDLE_PART);
        this._enablestatus = (IBundlePart.EnableStatusValue)avm.getAttributeValue(BundlePartType.ENABLE_STATUS, true);
        this._partclass = (IBundlePart.PartClassValue)avm.getAttributeValue(BundlePartType.PART_CLASS, true);
        this._metadatafile = (String)avm.getAttributeValue(BundlePartType.META_DATA_FILE, true);
        this._parttype = (String)avm.getAttributeValue(BundlePartType.PART_TYPE, true);
        this._seqnumber = (Long)avm.getAttributeValue(BundlePartType.SEQNUMBER);
        this._availstatus = (IBundlePart.AvailabilityValue)avm.getAttributeValue(BundlePartType.AVAILABILITY, true);
        this._operation = (String)avm.getAttributeValue(BundlePartType.OPERATION_NAME, true);
    }

    public BundlePart(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("BUNDLE");
        this._bundle = (String)((CICSAttribute)BundlePartType.BUNDLE).get(stringValue, normalizers);
        stringValue = record.get("BUNDLEPART");
        this._bundlepart = (String)((CICSAttribute)BundlePartType.BUNDLE_PART).get(stringValue, normalizers);
        stringValue = record.get("ENABLESTATUS");
        this._enablestatus = (IBundlePart.EnableStatusValue)((CICSAttribute)BundlePartType.ENABLE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PARTCLASS");
        this._partclass = (IBundlePart.PartClassValue)((CICSAttribute)BundlePartType.PART_CLASS).get(stringValue, normalizers);
        stringValue = record.get("METADATAFILE");
        this._metadatafile = (String)((CICSAttribute)BundlePartType.META_DATA_FILE).get(stringValue, normalizers);
        stringValue = record.get("PARTTYPE");
        this._parttype = (String)((CICSAttribute)BundlePartType.PART_TYPE).get(stringValue, normalizers);
        stringValue = record.get("SEQNUMBER");
        this._seqnumber = (Long)((CICSAttribute)BundlePartType.SEQNUMBER).get(stringValue, normalizers);
        stringValue = record.get("AVAILSTATUS");
        this._availstatus = (IBundlePart.AvailabilityValue)((CICSAttribute)BundlePartType.AVAILABILITY).get(stringValue, normalizers);
        stringValue = record.get("OPERATION");
        this._operation = (String)((CICSAttribute)BundlePartType.OPERATION_NAME).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return BundlePartType.BUNDLE_PART.internalToExternal((Object)this.getBundlePart());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getBundle() {
        return this._bundle;
    }

    public String getBundlePart() {
        return this._bundlepart;
    }

    public IBundlePart.EnableStatusValue getEnableStatus() {
        return this._enablestatus;
    }

    public IBundlePart.PartClassValue getPartClass() {
        return this._partclass;
    }

    public String getMetaDataFile() {
        return this._metadatafile;
    }

    public String getPartType() {
        return this._parttype;
    }

    public Long getSeqnumber() {
        return this._seqnumber;
    }

    public IBundlePart.AvailabilityValue getAvailability() {
        return this._availstatus;
    }

    public String getOperationName() {
        return this._operation;
    }

    public BundlePartType getObjectType() {
        return BundlePartType.getInstance();
    }

    @Override
    public BundlePartReference getCICSObjectReference() {
        return new BundlePartReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == BundlePartType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == BundlePartType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == BundlePartType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        if (attribute == BundlePartType.PART_CLASS) {
            return (V)this.getPartClass();
        }
        if (attribute == BundlePartType.META_DATA_FILE) {
            return (V)this.getMetaDataFile();
        }
        if (attribute == BundlePartType.PART_TYPE) {
            return (V)this.getPartType();
        }
        if (attribute == BundlePartType.SEQNUMBER) {
            return (V)this.getSeqnumber();
        }
        if (attribute == BundlePartType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        if (attribute == BundlePartType.OPERATION_NAME) {
            return (V)this.getOperationName();
        }
        return super.getAttributeValue(attribute);
    }
}

