/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CMASListReference;
import com.ibm.cics.core.model.CMASListType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICMASList;
import com.ibm.cics.model.ICPSMManagerContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class CMASList
extends CPSMManager
implements ICMASList {
    private String _cmasname;
    private String _transitcmas;
    private String _sysid;
    private String _cpsmver;
    private ICMASList.StatusValue _status;
    private ICMASList.AccesstypeValue _accesstype;
    private Long _transitcnt;
    private String _jobname;
    private String _jobid;

    public CMASList(ICPSMManagerContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._cmasname = (String)avm.getAttributeValue(CMASListType.NAME);
        this._transitcmas = (String)avm.getAttributeValue(CMASListType.TRANSITCMAS, true);
        this._sysid = (String)avm.getAttributeValue(CMASListType.SYSID, true);
        this._cpsmver = (String)avm.getAttributeValue(CMASListType.CPSMVER, true);
        this._status = (ICMASList.StatusValue)avm.getAttributeValue(CMASListType.STATUS, true);
        this._accesstype = (ICMASList.AccesstypeValue)avm.getAttributeValue(CMASListType.ACCESSTYPE, true);
        this._transitcnt = (Long)avm.getAttributeValue(CMASListType.TRANSITCNT, true);
        this._jobname = (String)avm.getAttributeValue(CMASListType.JOBNAME, true);
        this._jobid = (String)avm.getAttributeValue(CMASListType.JOBID, true);
    }

    public CMASList(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CMASNAME");
        this._cmasname = (String)((CICSAttribute)CMASListType.NAME).get(stringValue, normalizers);
        stringValue = record.get("TRANSITCMAS");
        this._transitcmas = (String)((CICSAttribute)CMASListType.TRANSITCMAS).get(stringValue, normalizers);
        stringValue = record.get("SYSID");
        this._sysid = (String)((CICSAttribute)CMASListType.SYSID).get(stringValue, normalizers);
        stringValue = record.get("CPSMVER");
        this._cpsmver = (String)((CICSAttribute)CMASListType.CPSMVER).get(stringValue, normalizers);
        stringValue = record.get("STATUS");
        this._status = (ICMASList.StatusValue)((CICSAttribute)CMASListType.STATUS).get(stringValue, normalizers);
        stringValue = record.get("ACCESSTYPE");
        this._accesstype = (ICMASList.AccesstypeValue)((CICSAttribute)CMASListType.ACCESSTYPE).get(stringValue, normalizers);
        stringValue = record.get("TRANSITCNT");
        this._transitcnt = (Long)((CICSAttribute)CMASListType.TRANSITCNT).get(stringValue, normalizers);
        stringValue = record.get("JOBNAME");
        this._jobname = (String)((CICSAttribute)CMASListType.JOBNAME).get(stringValue, normalizers);
        stringValue = record.get("JOBID");
        this._jobid = (String)((CICSAttribute)CMASListType.JOBID).get(stringValue, normalizers);
    }

    public String getName() {
        return this._cmasname;
    }

    public String getTransitcmas() {
        return this._transitcmas;
    }

    public String getSysid() {
        return this._sysid;
    }

    public String getCpsmver() {
        return this._cpsmver;
    }

    public ICMASList.StatusValue getStatus() {
        return this._status;
    }

    public ICMASList.AccesstypeValue getAccesstype() {
        return this._accesstype;
    }

    public Long getTransitcnt() {
        return this._transitcnt;
    }

    public String getJobname() {
        return this._jobname;
    }

    public String getJobid() {
        return this._jobid;
    }

    public CMASListType getObjectType() {
        return CMASListType.getInstance();
    }

    @Override
    public CMASListReference getCICSObjectReference() {
        return new CMASListReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CMASListType.NAME) {
            return (V)this.getName();
        }
        if (attribute == CMASListType.TRANSITCMAS) {
            return (V)this.getTransitcmas();
        }
        if (attribute == CMASListType.SYSID) {
            return (V)this.getSysid();
        }
        if (attribute == CMASListType.CPSMVER) {
            return (V)this.getCpsmver();
        }
        if (attribute == CMASListType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == CMASListType.ACCESSTYPE) {
            return (V)this.getAccesstype();
        }
        if (attribute == CMASListType.TRANSITCNT) {
            return (V)this.getTransitcnt();
        }
        if (attribute == CMASListType.JOBNAME) {
            return (V)this.getJobname();
        }
        if (attribute == CMASListType.JOBID) {
            return (V)this.getJobid();
        }
        return super.getAttributeValue(attribute);
    }
}

