/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.AbstractCPSMDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.internal.CICSObject;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public abstract class CPSMAbstractDefinition
extends CICSObject
implements ICoreObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date createTime;
    private Date changeTime;
    private ICICSEnums.ChangeagentDefinitionValue _changeagent;
    private String _changeusrid;
    private String _changeagrel;

    public CPSMAbstractDefinition(ICICSObjectContainer<?> container, AttributeValueMap avm) {
        super(container);
        this.createTime = (Date)avm.getAttributeValue(AbstractCPSMDefinitionType.CREATE_TIME, true);
        this.changeTime = (Date)avm.getAttributeValue(AbstractCPSMDefinitionType.CHANGE_TIME, true);
        this._changeagent = (ICICSEnums.ChangeagentDefinitionValue)avm.getAttributeValue(AbstractCPSMDefinitionType.CHANGE_AGENT, true);
        this._changeusrid = (String)avm.getAttributeValue(AbstractCPSMDefinitionType.CHANGE_USER_ID, true);
        this._changeagrel = (String)avm.getAttributeValue(AbstractCPSMDefinitionType.CHANGE_AGENT_RELEASE, true);
    }

    public CPSMAbstractDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get(AbstractCPSMDefinitionType.CHANGE_TIME.getCicsName());
        this.changeTime = (Date)((CICSAttribute)AbstractCPSMDefinitionType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get(AbstractCPSMDefinitionType.CREATE_TIME.getCicsName());
        this.createTime = (Date)((CICSAttribute)AbstractCPSMDefinitionType.CREATE_TIME).get(stringValue, normalizers);
        stringValue = record.get(AbstractCPSMDefinitionType.CHANGE_AGENT.getCicsName());
        this._changeagent = (ICICSEnums.ChangeagentDefinitionValue)((CICSAttribute)AbstractCPSMDefinitionType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get(AbstractCPSMDefinitionType.CHANGE_USER_ID.getCicsName());
        this._changeusrid = (String)((CICSAttribute)AbstractCPSMDefinitionType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get(AbstractCPSMDefinitionType.CHANGE_AGENT_RELEASE.getCicsName());
        this._changeagrel = (String)((CICSAttribute)AbstractCPSMDefinitionType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
    }

    public abstract String getName();

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public ICICSEnums.ChangeagentDefinitionValue getChangeAgent() {
        return this._changeagent;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    @Override
    public <T> T getAttributeValue(IAttribute<T> attribute) {
        if (AbstractCPSMDefinitionType.CHANGE_AGENT == attribute) {
            return (T)this.getChangeAgent();
        }
        if (AbstractCPSMDefinitionType.CHANGE_AGENT_RELEASE == attribute) {
            return (T)this.getChangeAgentRelease();
        }
        if (AbstractCPSMDefinitionType.CHANGE_TIME == attribute) {
            return (T)this.getChangeTime();
        }
        if (AbstractCPSMDefinitionType.CHANGE_USER_ID == attribute) {
            return (T)this.getChangeUserID();
        }
        if (AbstractCPSMDefinitionType.CREATE_TIME == attribute) {
            return (T)this.getCreateTime();
        }
        return super.getAttributeValue(attribute);
    }
}

