/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CaptureSpecificationDataReference;
import com.ibm.cics.core.model.CaptureSpecificationDataType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ICaptureSpecificationData;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class CaptureSpecificationData
extends CICSResource
implements ICaptureSpecificationData {
    private String _capturespec;
    private String _eventbinding;
    private String _container;
    private Long _fieldlength;
    private Long _fieldoffset;
    private String _filename;
    private String _location;
    private String _structname;
    private String _variablename;
    private ICaptureSpecificationData.OperatorValue _operator;
    private Long _seqnumber;
    private String _filtervalue;

    public CaptureSpecificationData(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._capturespec = (String)avm.getAttributeValue(CaptureSpecificationDataType.CAPTURESPEC);
        this._eventbinding = (String)avm.getAttributeValue(CaptureSpecificationDataType.EVENTBINDING);
        this._container = (String)avm.getAttributeValue(CaptureSpecificationDataType.CONTAINER, true);
        this._fieldlength = (Long)avm.getAttributeValue(CaptureSpecificationDataType.FIELDLENGTH, true);
        this._fieldoffset = (Long)avm.getAttributeValue(CaptureSpecificationDataType.FIELDOFFSET, true);
        this._filename = (String)avm.getAttributeValue(CaptureSpecificationDataType.FILENAME, true);
        this._location = (String)avm.getAttributeValue(CaptureSpecificationDataType.LOCATION, true);
        this._structname = (String)avm.getAttributeValue(CaptureSpecificationDataType.STRUCTNAME, true);
        this._variablename = (String)avm.getAttributeValue(CaptureSpecificationDataType.VARIABLENAME, true);
        this._operator = (ICaptureSpecificationData.OperatorValue)avm.getAttributeValue(CaptureSpecificationDataType.OPERATOR, true);
        this._seqnumber = (Long)avm.getAttributeValue(CaptureSpecificationDataType.SEQNUMBER);
        this._filtervalue = (String)avm.getAttributeValue(CaptureSpecificationDataType.FILTERVALUE, true);
    }

    public CaptureSpecificationData(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CAPTURESPEC");
        this._capturespec = (String)((CICSAttribute)CaptureSpecificationDataType.CAPTURESPEC).get(stringValue, normalizers);
        stringValue = record.get("EVENTBINDING");
        this._eventbinding = (String)((CICSAttribute)CaptureSpecificationDataType.EVENTBINDING).get(stringValue, normalizers);
        stringValue = record.get("CONTAINER");
        this._container = (String)((CICSAttribute)CaptureSpecificationDataType.CONTAINER).get(stringValue, normalizers);
        stringValue = record.get("FIELDLENGTH");
        this._fieldlength = (Long)((CICSAttribute)CaptureSpecificationDataType.FIELDLENGTH).get(stringValue, normalizers);
        stringValue = record.get("FIELDOFFSET");
        this._fieldoffset = (Long)((CICSAttribute)CaptureSpecificationDataType.FIELDOFFSET).get(stringValue, normalizers);
        stringValue = record.get("FILENAME");
        this._filename = (String)((CICSAttribute)CaptureSpecificationDataType.FILENAME).get(stringValue, normalizers);
        stringValue = record.get("LOCATION");
        this._location = (String)((CICSAttribute)CaptureSpecificationDataType.LOCATION).get(stringValue, normalizers);
        stringValue = record.get("STRUCTNAME");
        this._structname = (String)((CICSAttribute)CaptureSpecificationDataType.STRUCTNAME).get(stringValue, normalizers);
        stringValue = record.get("VARIABLENAME");
        this._variablename = (String)((CICSAttribute)CaptureSpecificationDataType.VARIABLENAME).get(stringValue, normalizers);
        stringValue = record.get("OPERATOR");
        this._operator = (ICaptureSpecificationData.OperatorValue)((CICSAttribute)CaptureSpecificationDataType.OPERATOR).get(stringValue, normalizers);
        stringValue = record.get("SEQNUMBER");
        this._seqnumber = (Long)((CICSAttribute)CaptureSpecificationDataType.SEQNUMBER).get(stringValue, normalizers);
        stringValue = record.get("FILTERVALUE");
        this._filtervalue = (String)((CICSAttribute)CaptureSpecificationDataType.FILTERVALUE).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return CaptureSpecificationDataType.CAPTURESPEC.internalToExternal((Object)this.getCapturespec());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getCapturespec() {
        return this._capturespec;
    }

    public String getEventbinding() {
        return this._eventbinding;
    }

    public String getContainer() {
        return this._container;
    }

    public Long getFieldlength() {
        return this._fieldlength;
    }

    public Long getFieldoffset() {
        return this._fieldoffset;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getLocation() {
        return this._location;
    }

    public String getStructname() {
        return this._structname;
    }

    public String getVariablename() {
        return this._variablename;
    }

    public ICaptureSpecificationData.OperatorValue getOperator() {
        return this._operator;
    }

    public Long getSeqnumber() {
        return this._seqnumber;
    }

    public String getFiltervalue() {
        return this._filtervalue;
    }

    public CaptureSpecificationDataType getObjectType() {
        return CaptureSpecificationDataType.getInstance();
    }

    @Override
    public CaptureSpecificationDataReference getCICSObjectReference() {
        return new CaptureSpecificationDataReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CaptureSpecificationDataType.CAPTURESPEC) {
            return (V)this.getCapturespec();
        }
        if (attribute == CaptureSpecificationDataType.EVENTBINDING) {
            return (V)this.getEventbinding();
        }
        if (attribute == CaptureSpecificationDataType.CONTAINER) {
            return (V)this.getContainer();
        }
        if (attribute == CaptureSpecificationDataType.FIELDLENGTH) {
            return (V)this.getFieldlength();
        }
        if (attribute == CaptureSpecificationDataType.FIELDOFFSET) {
            return (V)this.getFieldoffset();
        }
        if (attribute == CaptureSpecificationDataType.FILENAME) {
            return (V)this.getFilename();
        }
        if (attribute == CaptureSpecificationDataType.LOCATION) {
            return (V)this.getLocation();
        }
        if (attribute == CaptureSpecificationDataType.STRUCTNAME) {
            return (V)this.getStructname();
        }
        if (attribute == CaptureSpecificationDataType.VARIABLENAME) {
            return (V)this.getVariablename();
        }
        if (attribute == CaptureSpecificationDataType.OPERATOR) {
            return (V)this.getOperator();
        }
        if (attribute == CaptureSpecificationDataType.SEQNUMBER) {
            return (V)this.getSeqnumber();
        }
        if (attribute == CaptureSpecificationDataType.FILTERVALUE) {
            return (V)this.getFiltervalue();
        }
        return super.getAttributeValue(attribute);
    }
}

