/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPITargetDefinitionReference;
import com.ibm.cics.core.model.FEPITargetDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.IFEPITargetDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class FEPITargetDefinition
extends CICSDefinition
implements IFEPITargetDefinition {
    private String _userdata1;
    private String _userdata2;
    private String _userdata3;
    private IFEPITargetDefinition.ServiceStatusValue _servstatus;
    private String _appllist;
    private String _targetlist;

    public FEPITargetDefinition(ICICSDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._userdata1 = (String)avm.getAttributeValue(FEPITargetDefinitionType.USER_DATA_AREA_1, true);
        this._userdata2 = (String)avm.getAttributeValue(FEPITargetDefinitionType.USER_DATA_AREA_2, true);
        this._userdata3 = (String)avm.getAttributeValue(FEPITargetDefinitionType.USER_DATA_AREA_3, true);
        this._servstatus = (IFEPITargetDefinition.ServiceStatusValue)avm.getAttributeValue(FEPITargetDefinitionType.SERVICE_STATUS, true);
        this._appllist = (String)avm.getAttributeValue(FEPITargetDefinitionType.VTAM_APPLICATION_I_DS, true);
        this._targetlist = (String)avm.getAttributeValue(FEPITargetDefinitionType.TARGET_LIST, true);
    }

    public FEPITargetDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("USERDATA1");
        this._userdata1 = (String)((CICSAttribute)FEPITargetDefinitionType.USER_DATA_AREA_1).get(stringValue, normalizers);
        stringValue = record.get("USERDATA2");
        this._userdata2 = (String)((CICSAttribute)FEPITargetDefinitionType.USER_DATA_AREA_2).get(stringValue, normalizers);
        stringValue = record.get("USERDATA3");
        this._userdata3 = (String)((CICSAttribute)FEPITargetDefinitionType.USER_DATA_AREA_3).get(stringValue, normalizers);
        stringValue = record.get("SERVSTATUS");
        this._servstatus = (IFEPITargetDefinition.ServiceStatusValue)((CICSAttribute)FEPITargetDefinitionType.SERVICE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("APPLLIST");
        this._appllist = (String)((CICSAttribute)FEPITargetDefinitionType.VTAM_APPLICATION_I_DS).get(stringValue, normalizers);
        stringValue = record.get("TARGETLIST");
        this._targetlist = (String)((CICSAttribute)FEPITargetDefinitionType.TARGET_LIST).get(stringValue, normalizers);
    }

    public String getUserDataArea1() {
        return this._userdata1;
    }

    public String getUserDataArea2() {
        return this._userdata2;
    }

    public String getUserDataArea3() {
        return this._userdata3;
    }

    public IFEPITargetDefinition.ServiceStatusValue getServiceStatus() {
        return this._servstatus;
    }

    public String getVTAMApplicationIDs() {
        return this._appllist;
    }

    public String getTargetList() {
        return this._targetlist;
    }

    public FEPITargetDefinitionType getObjectType() {
        return FEPITargetDefinitionType.getInstance();
    }

    @Override
    public FEPITargetDefinitionReference getCICSObjectReference() {
        return new FEPITargetDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPITargetDefinitionType.USER_DATA_AREA_1) {
            return (V)this.getUserDataArea1();
        }
        if (attribute == FEPITargetDefinitionType.USER_DATA_AREA_2) {
            return (V)this.getUserDataArea2();
        }
        if (attribute == FEPITargetDefinitionType.USER_DATA_AREA_3) {
            return (V)this.getUserDataArea3();
        }
        if (attribute == FEPITargetDefinitionType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == FEPITargetDefinitionType.VTAM_APPLICATION_I_DS) {
            return (V)this.getVTAMApplicationIDs();
        }
        if (attribute == FEPITargetDefinitionType.TARGET_LIST) {
            return (V)this.getTargetList();
        }
        return super.getAttributeValue(attribute);
    }
}

