/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMServerDefinitionReference;
import com.ibm.cics.core.model.JVMServerDefinitionType;
import com.ibm.cics.core.model.internal.CICSDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.IJVMServerDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class JVMServerDefinition
extends CICSDefinition
implements IJVMServerDefinition {
    private String _userdata1;
    private String _userdata2;
    private String _userdata3;
    private String _jvmprofile;
    private ICICSEnums.EnablementValue _status;
    private String _lerunopts;
    private Long _threadlimit;

    public JVMServerDefinition(ICICSDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._userdata1 = (String)avm.getAttributeValue(JVMServerDefinitionType.USERDATA_1, true);
        this._userdata2 = (String)avm.getAttributeValue(JVMServerDefinitionType.USERDATA_2, true);
        this._userdata3 = (String)avm.getAttributeValue(JVMServerDefinitionType.USERDATA_3, true);
        this._jvmprofile = (String)avm.getAttributeValue(JVMServerDefinitionType.JVM_PROFILE, true);
        this._status = (ICICSEnums.EnablementValue)avm.getAttributeValue(JVMServerDefinitionType.ENABLED_STATUS, true);
        this._lerunopts = (String)avm.getAttributeValue(JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM, true);
        this._threadlimit = (Long)avm.getAttributeValue(JVMServerDefinitionType.THREADLIMIT, true);
    }

    public JVMServerDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("USERDATA1");
        this._userdata1 = (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_1).get(stringValue, normalizers);
        stringValue = record.get("USERDATA2");
        this._userdata2 = (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_2).get(stringValue, normalizers);
        stringValue = record.get("USERDATA3");
        this._userdata3 = (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_3).get(stringValue, normalizers);
        stringValue = record.get("JVMPROFILE");
        this._jvmprofile = (String)((CICSAttribute)JVMServerDefinitionType.JVM_PROFILE).get(stringValue, normalizers);
        stringValue = record.get("STATUS");
        this._status = (ICICSEnums.EnablementValue)((CICSAttribute)JVMServerDefinitionType.ENABLED_STATUS).get(stringValue, normalizers);
        stringValue = record.get("LERUNOPTS");
        this._lerunopts = (String)((CICSAttribute)JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM).get(stringValue, normalizers);
        stringValue = record.get("THREADLIMIT");
        this._threadlimit = (Long)((CICSAttribute)JVMServerDefinitionType.THREADLIMIT).get(stringValue, normalizers);
    }

    public String getUserdata1() {
        return this._userdata1;
    }

    public String getUserdata2() {
        return this._userdata2;
    }

    public String getUserdata3() {
        return this._userdata3;
    }

    public String getJvmProfile() {
        return this._jvmprofile;
    }

    public ICICSEnums.EnablementValue getEnabledStatus() {
        return this._status;
    }

    public String getLeRuntimeOptionsProgram() {
        return this._lerunopts;
    }

    public Long getThreadlimit() {
        return this._threadlimit;
    }

    public JVMServerDefinitionType getObjectType() {
        return JVMServerDefinitionType.getInstance();
    }

    @Override
    public JVMServerDefinitionReference getCICSObjectReference() {
        return new JVMServerDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMServerDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == JVMServerDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == JVMServerDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        if (attribute == JVMServerDefinitionType.JVM_PROFILE) {
            return (V)this.getJvmProfile();
        }
        if (attribute == JVMServerDefinitionType.ENABLED_STATUS) {
            return (V)this.getEnabledStatus();
        }
        if (attribute == JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM) {
            return (V)this.getLeRuntimeOptionsProgram();
        }
        if (attribute == JVMServerDefinitionType.THREADLIMIT) {
            return (V)this.getThreadlimit();
        }
        return super.getAttributeValue(attribute);
    }
}

