/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.MonitorDefinitionReference;
import com.ibm.cics.core.model.MonitorDefinitionType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IMonitorDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class MonitorDefinition
extends CPSMDefinition
implements IMonitorDefinition {
    private String _name;
    private String _resname;
    private IMonitorDefinition.ResourceClassValue _resclass;
    private IMonitorDefinition.IncludeValue _include;
    private String _desc;
    private IMonitorDefinition.ResourceStatusPopulationValue _rodmpop;

    public MonitorDefinition(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(MonitorDefinitionType.NAME);
        this._resname = (String)avm.getAttributeValue(MonitorDefinitionType.RESOURCE_NAME, true);
        this._resclass = (IMonitorDefinition.ResourceClassValue)avm.getAttributeValue(MonitorDefinitionType.RESOURCE_CLASS, true);
        this._include = (IMonitorDefinition.IncludeValue)avm.getAttributeValue(MonitorDefinitionType.INCLUDE, true);
        this._desc = (String)avm.getAttributeValue(MonitorDefinitionType.DESCRIPTION, true);
        this._rodmpop = (IMonitorDefinition.ResourceStatusPopulationValue)avm.getAttributeValue(MonitorDefinitionType.RESOURCE_STATUS_POPULATION, true);
    }

    public MonitorDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)MonitorDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("RESNAME");
        this._resname = (String)((CICSAttribute)MonitorDefinitionType.RESOURCE_NAME).get(stringValue, normalizers);
        stringValue = record.get("RESCLASS");
        this._resclass = (IMonitorDefinition.ResourceClassValue)((CICSAttribute)MonitorDefinitionType.RESOURCE_CLASS).get(stringValue, normalizers);
        stringValue = record.get("INCLUDE");
        this._include = (IMonitorDefinition.IncludeValue)((CICSAttribute)MonitorDefinitionType.INCLUDE).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)MonitorDefinitionType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("RODMPOP");
        this._rodmpop = (IMonitorDefinition.ResourceStatusPopulationValue)((CICSAttribute)MonitorDefinitionType.RESOURCE_STATUS_POPULATION).get(stringValue, normalizers);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getResourceName() {
        return this._resname;
    }

    public IMonitorDefinition.ResourceClassValue getResourceClass() {
        return this._resclass;
    }

    public IMonitorDefinition.IncludeValue getInclude() {
        return this._include;
    }

    public String getDescription() {
        return this._desc;
    }

    public IMonitorDefinition.ResourceStatusPopulationValue getResourceStatusPopulation() {
        return this._rodmpop;
    }

    public MonitorDefinitionType getObjectType() {
        return MonitorDefinitionType.getInstance();
    }

    @Override
    public MonitorDefinitionReference getCICSObjectReference() {
        return new MonitorDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == MonitorDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_NAME) {
            return (V)this.getResourceName();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_CLASS) {
            return (V)this.getResourceClass();
        }
        if (attribute == MonitorDefinitionType.INCLUDE) {
            return (V)this.getInclude();
        }
        if (attribute == MonitorDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_STATUS_POPULATION) {
            return (V)this.getResourceStatusPopulation();
        }
        return super.getAttributeValue(attribute);
    }
}

