/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadSpecificationReference;
import com.ibm.cics.core.model.WorkloadSpecificationType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSRegionDefinitionReference;
import com.ibm.cics.model.ICICSRegionGroupDefinitionReference;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IWLMSpecificationsToSystem;
import com.ibm.cics.model.IWLMSpecificationsToSystemGroup;
import com.ibm.cics.model.IWorkloadGroupInWorkloadSpecification;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWorkloadSpecification;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableWorkloadSpecification
extends MutableCPSMDefinition
implements IMutableWorkloadSpecification {
    private IWorkloadSpecification delegate;
    private MutableSMRecord record;

    public MutableWorkloadSpecification(ICPSM cpsm, IContext context, IWorkloadSpecification cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WLMSPEC");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getTargetScope() {
        String result = this.record.get("AORSCOPE");
        if (result == null) {
            return this.delegate.getTargetScope();
        }
        return (String)((CICSAttribute)WorkloadSpecificationType.TARGET_SCOPE).get(result, this.record.getNormalizers());
    }

    public IWorkloadSpecification.DefaultAffinityValue getDefaultAffinity() {
        String result = this.record.get("AFFINITY");
        if (result == null) {
            return this.delegate.getDefaultAffinity();
        }
        return (IWorkloadSpecification.DefaultAffinityValue)((CICSAttribute)WorkloadSpecificationType.DEFAULT_AFFINITY).get(result, this.record.getNormalizers());
    }

    public IWorkloadSpecification.AffinityLifetimeValue getAffinityLifetime() {
        String result = this.record.get("AFFLIFE");
        if (result == null) {
            return this.delegate.getAffinityLifetime();
        }
        return (IWorkloadSpecification.AffinityLifetimeValue)((CICSAttribute)WorkloadSpecificationType.AFFINITY_LIFETIME).get(result, this.record.getNormalizers());
    }

    public IWorkloadSpecification.MatchValue getMatch() {
        String result = this.record.get("MATCH");
        if (result == null) {
            return this.delegate.getMatch();
        }
        return (IWorkloadSpecification.MatchValue)((CICSAttribute)WorkloadSpecificationType.MATCH).get(result, this.record.getNormalizers());
    }

    public IWorkloadSpecification.AlgorithmTypeValue getAlgorithmType() {
        String result = this.record.get("ALGTYPE");
        if (result == null) {
            return this.delegate.getAlgorithmType();
        }
        return (IWorkloadSpecification.AlgorithmTypeValue)((CICSAttribute)WorkloadSpecificationType.ALGORITHM_TYPE).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)WorkloadSpecificationType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getEventName() {
        String result = this.record.get("EVENTNAME");
        if (result == null) {
            return this.delegate.getEventName();
        }
        return (String)((CICSAttribute)WorkloadSpecificationType.EVENT_NAME).get(result, this.record.getNormalizers());
    }

    public Long getAbendcrit() {
        String result = this.record.get("ABENDCRIT");
        if (result == null) {
            return this.delegate.getAbendcrit();
        }
        return (Long)((CICSAttribute)WorkloadSpecificationType.ABENDCRIT).get(result, this.record.getNormalizers());
    }

    public Long getAbendthresh() {
        String result = this.record.get("ABENDTHRESH");
        if (result == null) {
            return this.delegate.getAbendthresh();
        }
        return (Long)((CICSAttribute)WorkloadSpecificationType.ABENDTHRESH).get(result, this.record.getNormalizers());
    }

    public IWorkloadSpecification.AutomaticAffinityCreationValue getAutomaticAffinityCreation() {
        String result = this.record.get("AFFAUTO");
        if (result == null) {
            return this.delegate.getAutomaticAffinityCreation();
        }
        return (IWorkloadSpecification.AutomaticAffinityCreationValue)((CICSAttribute)WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION).get(result, this.record.getNormalizers());
    }

    public void setTargetScope(String _targetScope) {
        if (_targetScope.equals(this.delegate.getTargetScope())) {
            this.record.set("AORSCOPE", null);
        } else {
            WorkloadSpecificationType.TARGET_SCOPE.validate((Object)_targetScope);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.TARGET_SCOPE).set(_targetScope, this.record.getNormalizers());
            this.record.set("AORSCOPE", connectionSpecificExternalValue);
        }
    }

    public void setDefaultAffinity(IWorkloadSpecification.DefaultAffinityValue _defaultAffinity) {
        if (_defaultAffinity.equals((Object)this.delegate.getDefaultAffinity())) {
            this.record.set("AFFINITY", null);
        } else {
            WorkloadSpecificationType.DEFAULT_AFFINITY.validate((Object)_defaultAffinity);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.DEFAULT_AFFINITY).set(_defaultAffinity, this.record.getNormalizers());
            this.record.set("AFFINITY", connectionSpecificExternalValue);
        }
    }

    public void setAffinityLifetime(IWorkloadSpecification.AffinityLifetimeValue _affinityLifetime) {
        if (_affinityLifetime.equals((Object)this.delegate.getAffinityLifetime())) {
            this.record.set("AFFLIFE", null);
        } else {
            WorkloadSpecificationType.AFFINITY_LIFETIME.validate((Object)_affinityLifetime);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.AFFINITY_LIFETIME).set(_affinityLifetime, this.record.getNormalizers());
            this.record.set("AFFLIFE", connectionSpecificExternalValue);
        }
    }

    public void setMatch(IWorkloadSpecification.MatchValue _match) {
        if (_match.equals((Object)this.delegate.getMatch())) {
            this.record.set("MATCH", null);
        } else {
            WorkloadSpecificationType.MATCH.validate((Object)_match);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.MATCH).set(_match, this.record.getNormalizers());
            this.record.set("MATCH", connectionSpecificExternalValue);
        }
    }

    public void setAlgorithmType(IWorkloadSpecification.AlgorithmTypeValue _algorithmType) {
        if (_algorithmType.equals((Object)this.delegate.getAlgorithmType())) {
            this.record.set("ALGTYPE", null);
        } else {
            WorkloadSpecificationType.ALGORITHM_TYPE.validate((Object)_algorithmType);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.ALGORITHM_TYPE).set(_algorithmType, this.record.getNormalizers());
            this.record.set("ALGTYPE", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESC", null);
        } else {
            WorkloadSpecificationType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public void setEventName(String _eventName) {
        if (_eventName.equals(this.delegate.getEventName())) {
            this.record.set("EVENTNAME", null);
        } else {
            WorkloadSpecificationType.EVENT_NAME.validate((Object)_eventName);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.EVENT_NAME).set(_eventName, this.record.getNormalizers());
            this.record.set("EVENTNAME", connectionSpecificExternalValue);
        }
    }

    public void setAbendcrit(Long _abendcrit) {
        if (_abendcrit.equals(this.delegate.getAbendcrit())) {
            this.record.set("ABENDCRIT", null);
        } else {
            WorkloadSpecificationType.ABENDCRIT.validate((Object)_abendcrit);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.ABENDCRIT).set(_abendcrit, this.record.getNormalizers());
            this.record.set("ABENDCRIT", connectionSpecificExternalValue);
        }
    }

    public void setAbendthresh(Long _abendthresh) {
        if (_abendthresh.equals(this.delegate.getAbendthresh())) {
            this.record.set("ABENDTHRESH", null);
        } else {
            WorkloadSpecificationType.ABENDTHRESH.validate((Object)_abendthresh);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.ABENDTHRESH).set(_abendthresh, this.record.getNormalizers());
            this.record.set("ABENDTHRESH", connectionSpecificExternalValue);
        }
    }

    public void setAutomaticAffinityCreation(IWorkloadSpecification.AutomaticAffinityCreationValue _automaticAffinityCreation) {
        if (_automaticAffinityCreation.equals((Object)this.delegate.getAutomaticAffinityCreation())) {
            this.record.set("AFFAUTO", null);
        } else {
            WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION.validate((Object)_automaticAffinityCreation);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION).set(_automaticAffinityCreation, this.record.getNormalizers());
            this.record.set("AFFAUTO", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadSpecificationType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadSpecificationType.TARGET_SCOPE) {
            return (V)this.getTargetScope();
        }
        if (attribute == WorkloadSpecificationType.DEFAULT_AFFINITY) {
            return (V)this.getDefaultAffinity();
        }
        if (attribute == WorkloadSpecificationType.AFFINITY_LIFETIME) {
            return (V)this.getAffinityLifetime();
        }
        if (attribute == WorkloadSpecificationType.MATCH) {
            return (V)this.getMatch();
        }
        if (attribute == WorkloadSpecificationType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        if (attribute == WorkloadSpecificationType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == WorkloadSpecificationType.EVENT_NAME) {
            return (V)this.getEventName();
        }
        if (attribute == WorkloadSpecificationType.ABENDCRIT) {
            return (V)this.getAbendcrit();
        }
        if (attribute == WorkloadSpecificationType.ABENDTHRESH) {
            return (V)this.getAbendthresh();
        }
        if (attribute == WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION) {
            return (V)this.getAutomaticAffinityCreation();
        }
        return super.getAttributeValue(attribute);
    }

    public WorkloadSpecificationType getObjectType() {
        return WorkloadSpecificationType.getInstance();
    }

    @Override
    public WorkloadSpecificationReference getCICSObjectReference() {
        return new WorkloadSpecificationReference(this.getCICSContainer(), this.getName());
    }

    public ICICSRegionGroupDefinitionReference getRegionGroupDefinitionReference() {
        return (ICICSRegionGroupDefinitionReference)WorkloadSpecificationType.REGION_GROUP_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSRegionDefinitionReference getRegionDefinitionReference() {
        return (ICICSRegionDefinitionReference)WorkloadSpecificationType.REGION_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSObjectSet<IWLMSpecificationsToSystemGroup> getFromWLMSpecificationsToSystemGroups() {
        return WorkloadSpecificationType.FROM_WLM_SPECIFICATIONS_TO_SYSTEM_GROUPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWLMSpecificationsToSystem> getFromWLMSpecificationsToSystems() {
        return WorkloadSpecificationType.FROM_WLM_SPECIFICATIONS_TO_SYSTEMS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadGroupInWorkloadSpecification> getGroupsMembers() {
        return WorkloadSpecificationType.GROUPS_MEMBERS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

